/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.console;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XBigDecimal;
import edu.neu.ccs.XBigInteger;
import edu.neu.ccs.XBoolean;
import edu.neu.ccs.XByte;
import edu.neu.ccs.XChar;
import edu.neu.ccs.XColor;
import edu.neu.ccs.XDouble;
import edu.neu.ccs.XFloat;
import edu.neu.ccs.XInt;
import edu.neu.ccs.XLong;
import edu.neu.ccs.XObject;
import edu.neu.ccs.XShort;
import edu.neu.ccs.XString;
import edu.neu.ccs.console.ConsoleInputListener;
import edu.neu.ccs.console.ConsoleTextPane;
import edu.neu.ccs.console.ConsoleWindow;
import edu.neu.ccs.filter.CaseActionFilter;
import edu.neu.ccs.filter.FilterException;
import edu.neu.ccs.filter.StringableFilter;
import edu.neu.ccs.gui.CancelledException;
import edu.neu.ccs.gui.Fonts;
import edu.neu.ccs.util.JPTConstants;
import edu.neu.ccs.util.StringableFactory;
import edu.neu.ccs.util.SystemUtilities;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import javax.swing.event.SwingPropertyChangeSupport;

public class ConsoleGateway
implements ConsoleInputListener,
JPTConstants,
Serializable {
    private static final int OUT = 0;
    private static final int ERR = 1;
    private static final int IN = 2;
    public static final String ACTIVATED = "activated";
    public static final String INPUT_COLOR = "input.color";
    public static final String OUTPUT_COLOR = "output.color";
    public static final String ERROR_COLOR = "error.color";
    protected SwingPropertyChangeSupport changeAdapter = new SwingPropertyChangeSupport(this);
    protected CaseActionFilter action = null;
    protected String input = "";
    protected transient InputStream inStream = null;
    protected transient OutputStream[] outStreams = null;
    protected transient String endl = null;
    protected ConsoleWindow window = null;
    public ConsoleInputStream in = new ConsoleInputStream();
    public PrintStream out = new PrintStream(new ConsoleOutputStream(0));
    public PrintStream err = new PrintStream(new ConsoleOutputStream(1));
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;

    public ConsoleGateway() {
        this.inStream = System.in;
        this.outStreams = new OutputStream[]{System.out, System.err};
        this.endl = SystemUtilities.getLineSeparator();
    }

    public synchronized void consoleInputPerformed(String text) {
        this.input = text.substring(0, text.indexOf(this.endl));
        this.notify();
    }

    public synchronized void prompt(String text) {
        if (text != null && text.length() > 0) {
            this.out.print(String.valueOf(text) + " ");
        }
    }

    public synchronized void prompt(String text, String response) {
        this.prompt(text);
        if (response != null && response.length() > 0) {
            this.out.print("[" + response + "] ");
        }
    }

    public synchronized void pressReturn() {
        this.pressReturn(null);
    }

    public synchronized void pressReturn(String prompt) {
        if (prompt != null && prompt.length() > 0) {
            this.out.println(prompt);
        }
        this.prompt("Press return to continue");
        this.getOneLine();
    }

    public synchronized boolean confirm(String prompt, boolean response) {
        String responseString = response ? "Y" : "N";
        String reply = "";
        while ((reply = this.in.demandString(prompt, responseString)).length() != 0) {
            if (Character.toUpperCase(reply.charAt(0)) == 'Y') {
                response = true;
                break;
            }
            if (Character.toUpperCase(reply.charAt(0)) == 'N') {
                response = false;
                break;
            }
            this.out.println("Must answer Y[es] or N[o].");
            this.out.println();
        }
        return response;
    }

    public synchronized void setCaseActionFilter(CaseActionFilter filter) {
        this.action = filter;
    }

    public synchronized CaseActionFilter getCaseActionFilter() {
        return this.action;
    }

    public synchronized void setActivated(boolean isActivated) {
        boolean oldActivated = this.isActivated();
        if (isActivated && !this.isActivated()) {
            this.window = new ConsoleWindow(this);
            this.window.setVisible(true);
            this.window.setLocation(7);
        } else if (!isActivated && this.isActivated()) {
            ConsoleWindow temp = this.window;
            this.window = null;
            temp.close();
        }
        if (this.isActivated() != oldActivated) {
            this.changeAdapter.firePropertyChange(ACTIVATED, oldActivated, this.isActivated());
        }
    }

    public synchronized boolean isActivated() {
        return this.window != null;
    }

    public void normal() {
        if (this.window != null) {
            this.window.normal();
        }
    }

    public void iconify() {
        if (this.window != null) {
            this.window.iconify();
        }
    }

    public void maximize() {
        if (this.window != null) {
            this.window.maximize();
        }
    }

    public void toggle() {
        if (this.window != null) {
            this.window.toggle();
        }
    }

    public synchronized void setInputColor(Color input) {
        if (this.isActivated()) {
            Color oldColor = this.getInputColor();
            this.window.setInputColor(input);
            this.changeAdapter.firePropertyChange(INPUT_COLOR, oldColor, this.getInputColor());
        }
    }

    public synchronized Color getInputColor() {
        if (this.isActivated()) {
            return this.window.getInputColor();
        }
        return null;
    }

    public synchronized void setOutputColor(Color output) {
        if (this.isActivated()) {
            Color oldColor = this.getOutputColor();
            this.window.setOutputColor(output);
            this.changeAdapter.firePropertyChange(OUTPUT_COLOR, oldColor, this.getOutputColor());
        }
    }

    public synchronized Color getOutputColor() {
        if (this.isActivated()) {
            return this.window.getOutputColor();
        }
        return null;
    }

    public synchronized void setErrorColor(Color error) {
        if (this.isActivated()) {
            Color oldColor = this.getErrorColor();
            this.window.setErrorColor(error);
            this.changeAdapter.firePropertyChange(ERROR_COLOR, oldColor, this.getErrorColor());
        }
    }

    public synchronized Color getErrorColor() {
        if (this.isActivated()) {
            return this.window.getErrorColor();
        }
        return null;
    }

    public synchronized void selectBlackTextScheme() {
        this.setOutputColor(Color.black);
        this.setInputColor(Color.black);
        this.setErrorColor(Color.black);
    }

    public synchronized void selectColorTextScheme() {
        this.setOutputColor(Color.black);
        this.setInputColor(Color.blue);
        this.setErrorColor(Color.red);
    }

    public static String getMonospacedFontFamilyName() {
        return Fonts.getMonospacedFontFamilyName();
    }

    public final String getFontFamilyName() {
        if (this.isActivated()) {
            return this.window.getFontFamilyName();
        }
        return "";
    }

    public final int getFontSize() {
        if (this.isActivated()) {
            return this.window.getFontSize();
        }
        return 0;
    }

    public static final int getMinimumFontSize() {
        return ConsoleTextPane.getMinimumFontSize();
    }

    public static final int getMaximumFontSize() {
        return ConsoleTextPane.getMaximumFontSize();
    }

    public final void setFontSize(int size) {
        if (this.isActivated()) {
            this.window.setFontSize(size);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(propertyName, listener);
    }

    protected synchronized String getOneLine() {
        if (this.isActivated()) {
            this.input = null;
            this.window.setInputMode(true);
            try {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            finally {
                if (this.input == null) {
                    this.input = "";
                }
            }
            this.window.setInputMode(false);
        } else {
            StringBuffer buffer = new StringBuffer("");
            while (buffer.toString().indexOf(this.endl) < 0) {
                try {
                    int ch = this.inStream.read();
                    if (ch < 0) {
                        buffer.append(this.endl);
                        continue;
                    }
                    buffer.append((char)ch);
                }
                catch (IOException ex) {
                    buffer.append(this.endl);
                }
            }
            this.input = buffer.toString();
            this.input = this.input.substring(0, this.input.indexOf(this.endl));
        }
        if (this.action != null) {
            try {
                XString x = (XString)this.action.filterStringable(new XString(this.input));
                this.input = x.getValue();
            }
            catch (FilterException filterException) {
                // empty catch block
            }
        }
        return this.input;
    }

    protected String getLineSeparator() {
        return this.endl;
    }

    protected void flush(int stream) throws IOException {
        if (!this.isActivated()) {
            this.outStreams[stream].flush();
        }
    }

    protected void write(String text, int stream) {
        if (text == null) {
            return;
        }
        if (this.isActivated()) {
            this.window.consoleOutputPerformed(text, stream);
        } else {
            try {
                this.outStreams[stream].write(text.getBytes());
            }
            catch (IOException ex) {
                System.err.print("Could not write to ");
                switch (stream) {
                    case 1: {
                        System.err.print("error");
                        break;
                    }
                    default: {
                        System.err.print("output");
                    }
                }
                System.err.println(" stream.");
                ex.printStackTrace();
            }
            try {
                this.outStreams[stream].flush();
            }
            catch (IOException ex) {
                System.err.print("Could not flush ");
                switch (stream) {
                    case 1: {
                        System.err.print("error");
                        break;
                    }
                    default: {
                        System.err.print("output");
                    }
                }
                System.err.println(" stream.");
                ex.printStackTrace();
            }
        }
    }

    public class ConsoleInputStream
    implements Serializable {
        protected StringableFactory factory = new StringableFactory(null);

        public void setDataType(Class c) {
            this.factory.setDataType(c);
        }

        public Class getDataType() {
            return this.factory.getDataType();
        }

        public Stringable demandObject(String prompt, String data, Stringable obj, StringableFilter filter) {
            if (obj == null) {
                obj = this.factory.getDefaultInstance();
            }
            while (true) {
                ConsoleGateway.this.prompt(prompt, data);
                String inputData = ConsoleGateway.this.getOneLine();
                if (inputData.length() == 0 && data != null) {
                    inputData = data;
                }
                try {
                    block9: {
                        try {
                            obj.fromStringData(inputData);
                            if (filter == null) break block9;
                            try {
                                obj = filter.filterStringable(obj);
                            }
                            catch (FilterException ex) {
                                throw new ParseException(ex.getMessage(), -1);
                            }
                        }
                        catch (NumberFormatException ex) {
                            throw new ParseException(ex.getMessage(), -1);
                        }
                    }
                    return obj;
                }
                catch (ParseException e) {
                    ConsoleGateway.this.err.println(XObject.formatErrorMessage(e, inputData));
                    continue;
                }
                break;
            }
        }

        public Stringable demandObject(String prompt) {
            return this.demandObject(prompt, null, null, null);
        }

        public Stringable demandObject(String prompt, StringableFilter filter) {
            return this.demandObject(prompt, null, null, filter);
        }

        public Stringable demandObject(String prompt, String data) {
            return this.demandObject(prompt, data, null, null);
        }

        public Stringable demandObject(String prompt, String data, StringableFilter filter) {
            return this.demandObject(prompt, data, null, filter);
        }

        public Stringable demandObject(Class dataType, String prompt, String data, StringableFilter filter) {
            Class oldDataType = this.getDataType();
            this.setDataType(dataType);
            Stringable obj = this.demandObject(prompt, data, filter);
            this.setDataType(oldDataType);
            return obj;
        }

        public void demand(String prompt, Stringable obj) {
            this.demand(prompt, null, obj, null);
        }

        public void demand(String prompt, Stringable obj, StringableFilter filter) {
            this.demand(prompt, null, obj, filter);
        }

        public void demand(String prompt, String data, Stringable obj) {
            this.demand(prompt, data, obj, null);
        }

        public void demand(String prompt, String data, Stringable obj, StringableFilter filter) {
            if (obj == null) {
                throw new NullPointerException("Null object in demand method.");
            }
            this.demandObject(prompt, data, obj, filter);
        }

        public Stringable requestObject(String prompt, Stringable obj, StringableFilter filter) throws CancelledException {
            if (obj == null) {
                obj = this.factory.getDefaultInstance();
            }
            while (true) {
                ConsoleGateway.this.prompt(prompt);
                String inputData = ConsoleGateway.this.getOneLine();
                if (inputData.length() == 0) {
                    throw new CancelledException();
                }
                try {
                    block9: {
                        try {
                            obj.fromStringData(inputData);
                            if (filter == null) break block9;
                            try {
                                obj = filter.filterStringable(obj);
                            }
                            catch (FilterException ex) {
                                throw new ParseException(ex.getMessage(), -1);
                            }
                        }
                        catch (NumberFormatException ex) {
                            throw new ParseException(ex.getMessage(), -1);
                        }
                    }
                    return obj;
                }
                catch (ParseException e) {
                    ConsoleGateway.this.err.println(XObject.formatErrorMessage(e, inputData));
                    continue;
                }
                break;
            }
        }

        public Stringable requestObject(String prompt) throws CancelledException {
            return this.requestObject(prompt, null, null);
        }

        public Stringable requestObject(String prompt, StringableFilter filter) throws CancelledException {
            return this.requestObject(prompt, null, filter);
        }

        public Stringable requestObject(Class dataType, String prompt, StringableFilter filter) throws CancelledException {
            Class oldDataType = this.getDataType();
            this.setDataType(dataType);
            Stringable obj = this.requestObject(prompt, filter);
            this.setDataType(oldDataType);
            return obj;
        }

        public void request(String prompt, Stringable obj) throws CancelledException {
            this.requestObject(prompt, obj, null);
        }

        public void request(String prompt, Stringable obj, StringableFilter filter) throws CancelledException {
            if (obj == null) {
                throw new NullPointerException("Null object in request method.");
            }
            this.requestObject(prompt, obj, filter);
        }

        public boolean reading(String prompt, Stringable obj) {
            return this.reading(prompt, obj, null);
        }

        public boolean reading(String prompt, Stringable obj, StringableFilter filter) {
            if (obj == null) {
                throw new NullPointerException("Null object in reading method.");
            }
            while (true) {
                ConsoleGateway.this.prompt(prompt);
                String inputData = ConsoleGateway.this.getOneLine();
                if (inputData.length() == 0) {
                    return false;
                }
                try {
                    block9: {
                        try {
                            obj.fromStringData(inputData);
                            if (filter == null) break block9;
                            try {
                                filter.filterStringable(obj);
                            }
                            catch (FilterException ex) {
                                throw new ParseException(ex.getMessage(), -1);
                            }
                        }
                        catch (NumberFormatException ex) {
                            throw new ParseException(ex.getMessage(), -1);
                        }
                    }
                    return true;
                }
                catch (ParseException ex) {
                    ConsoleGateway.this.err.println(XObject.formatErrorMessage(ex, inputData));
                    continue;
                }
                break;
            }
        }

        public byte demandByte(String prompt) {
            return this.demandByte(prompt, null);
        }

        public byte demandByte(String prompt, StringableFilter filter) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.neu.ccs.XByte");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XByte)this.demandObject(clazz, prompt, null, filter)).getValue();
        }

        public byte demandByte(String prompt, byte value) {
            return this.demandByte(prompt, value, null);
        }

        public byte demandByte(String prompt, byte value, StringableFilter filter) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.neu.ccs.XByte");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XByte)this.demandObject(clazz, prompt, String.valueOf(value), filter)).getValue();
        }

        public byte requestByte(String prompt) throws CancelledException {
            return this.requestByte(prompt, null);
        }

        public byte requestByte(String prompt, StringableFilter filter) throws CancelledException {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.neu.ccs.XByte");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XByte)this.requestObject(clazz, prompt, filter)).getValue();
        }

        public short demandShort(String prompt) {
            return this.demandShort(prompt, null);
        }

        public short demandShort(String prompt, StringableFilter filter) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("edu.neu.ccs.XShort");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XShort)this.demandObject(clazz, prompt, null, filter)).getValue();
        }

        public short demandShort(String prompt, short value) {
            return this.demandShort(prompt, value, null);
        }

        public short demandShort(String prompt, short value, StringableFilter filter) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("edu.neu.ccs.XShort");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XShort)this.demandObject(clazz, prompt, String.valueOf(value), filter)).getValue();
        }

        public short requestShort(String prompt) throws CancelledException {
            return this.requestShort(prompt, null);
        }

        public short requestShort(String prompt, StringableFilter filter) throws CancelledException {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("edu.neu.ccs.XShort");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XShort)this.requestObject(clazz, prompt, filter)).getValue();
        }

        public int demandInt(String prompt) {
            return this.demandInt(prompt, null);
        }

        public int demandInt(String prompt, StringableFilter filter) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("edu.neu.ccs.XInt");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XInt)this.demandObject(clazz, prompt, null, filter)).getValue();
        }

        public int demandInt(String prompt, int value) {
            return this.demandInt(prompt, value, null);
        }

        public int demandInt(String prompt, int value, StringableFilter filter) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("edu.neu.ccs.XInt");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XInt)this.demandObject(clazz, prompt, String.valueOf(value), filter)).getValue();
        }

        public int requestInt(String prompt) throws CancelledException {
            return this.requestInt(prompt, null);
        }

        public int requestInt(String prompt, StringableFilter filter) throws CancelledException {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("edu.neu.ccs.XInt");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XInt)this.requestObject(clazz, prompt, filter)).getValue();
        }

        public long demandLong(String prompt) {
            return this.demandLong(prompt, null);
        }

        public long demandLong(String prompt, StringableFilter filter) {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("edu.neu.ccs.XLong");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XLong)this.demandObject(clazz, prompt, null, filter)).getValue();
        }

        public long demandLong(String prompt, long value) {
            return this.demandLong(prompt, value, null);
        }

        public long demandLong(String prompt, long value, StringableFilter filter) {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("edu.neu.ccs.XLong");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XLong)this.demandObject(clazz, prompt, String.valueOf(value), filter)).getValue();
        }

        public long requestLong(String prompt) throws CancelledException {
            return this.requestLong(prompt, null);
        }

        public long requestLong(String prompt, StringableFilter filter) throws CancelledException {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("edu.neu.ccs.XLong");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XLong)this.requestObject(clazz, prompt, filter)).getValue();
        }

        public float demandFloat(String prompt) {
            return this.demandFloat(prompt, null);
        }

        public float demandFloat(String prompt, StringableFilter filter) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("edu.neu.ccs.XFloat");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XFloat)this.demandObject(clazz, prompt, null, filter)).getValue();
        }

        public float demandFloat(String prompt, float value) {
            return this.demandFloat(prompt, value, null);
        }

        public float demandFloat(String prompt, float value, StringableFilter filter) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("edu.neu.ccs.XFloat");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XFloat)this.demandObject(clazz, prompt, String.valueOf(value), filter)).getValue();
        }

        public float requestFloat(String prompt) throws CancelledException {
            return this.requestFloat(prompt, null);
        }

        public float requestFloat(String prompt, StringableFilter filter) throws CancelledException {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("edu.neu.ccs.XFloat");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XFloat)this.requestObject(clazz, prompt, filter)).getValue();
        }

        public double demandDouble(String prompt) {
            return this.demandDouble(prompt, null);
        }

        public double demandDouble(String prompt, StringableFilter filter) {
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("edu.neu.ccs.XDouble");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XDouble)this.demandObject(clazz, prompt, null, filter)).getValue();
        }

        public double demandDouble(String prompt, double value) {
            return this.demandDouble(prompt, value, null);
        }

        public double demandDouble(String prompt, double value, StringableFilter filter) {
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("edu.neu.ccs.XDouble");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XDouble)this.demandObject(clazz, prompt, String.valueOf(value), filter)).getValue();
        }

        public double requestDouble(String prompt) throws CancelledException {
            return this.requestDouble(prompt, null);
        }

        public double requestDouble(String prompt, StringableFilter filter) throws CancelledException {
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("edu.neu.ccs.XDouble");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XDouble)this.requestObject(clazz, prompt, filter)).getValue();
        }

        public char demandChar(String prompt) {
            return this.demandChar(prompt, null);
        }

        public char demandChar(String prompt, StringableFilter filter) {
            Class<?> clazz = class$6;
            if (clazz == null) {
                try {
                    clazz = class$6 = Class.forName("edu.neu.ccs.XChar");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XChar)this.demandObject(clazz, prompt, null, filter)).getValue();
        }

        public char demandChar(String prompt, char value) {
            return this.demandChar(prompt, value, null);
        }

        public char demandChar(String prompt, char value, StringableFilter filter) {
            Class<?> clazz = class$6;
            if (clazz == null) {
                try {
                    clazz = class$6 = Class.forName("edu.neu.ccs.XChar");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XChar)this.demandObject(clazz, prompt, String.valueOf(value), filter)).getValue();
        }

        public char requestChar(String prompt) throws CancelledException {
            return this.requestChar(prompt, null);
        }

        public char requestChar(String prompt, StringableFilter filter) throws CancelledException {
            Class<?> clazz = class$6;
            if (clazz == null) {
                try {
                    clazz = class$6 = Class.forName("edu.neu.ccs.XChar");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XChar)this.requestObject(clazz, prompt, filter)).getValue();
        }

        public boolean demandBoolean(String prompt) {
            return this.demandBoolean(prompt, null);
        }

        public boolean demandBoolean(String prompt, StringableFilter filter) {
            Class<?> clazz = class$7;
            if (clazz == null) {
                try {
                    clazz = class$7 = Class.forName("edu.neu.ccs.XBoolean");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XBoolean)this.demandObject(clazz, prompt, null, filter)).getValue();
        }

        public boolean demandBoolean(String prompt, boolean value) {
            return this.demandBoolean(prompt, value, null);
        }

        public boolean demandBoolean(String prompt, boolean value, StringableFilter filter) {
            Class<?> clazz = class$7;
            if (clazz == null) {
                try {
                    clazz = class$7 = Class.forName("edu.neu.ccs.XBoolean");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XBoolean)this.demandObject(clazz, prompt, String.valueOf(value), filter)).getValue();
        }

        public boolean requestBoolean(String prompt) throws CancelledException {
            return this.requestBoolean(prompt, null);
        }

        public boolean requestBoolean(String prompt, StringableFilter filter) throws CancelledException {
            Class<?> clazz = class$7;
            if (clazz == null) {
                try {
                    clazz = class$7 = Class.forName("edu.neu.ccs.XBoolean");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XBoolean)this.requestObject(clazz, prompt, filter)).getValue();
        }

        public String demandString(String prompt) {
            return this.demandString(prompt, (StringableFilter)null);
        }

        public String demandString(String prompt, StringableFilter filter) {
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("edu.neu.ccs.XString");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XString)this.demandObject(clazz, prompt, null, filter)).getValue();
        }

        public String demandString(String prompt, String value) {
            return this.demandString(prompt, value, null);
        }

        public String demandString(String prompt, String value, StringableFilter filter) {
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("edu.neu.ccs.XString");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XString)this.demandObject(clazz, prompt, String.valueOf(value), filter)).getValue();
        }

        public String requestString(String prompt) throws CancelledException {
            return this.requestString(prompt, null);
        }

        public String requestString(String prompt, StringableFilter filter) throws CancelledException {
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("edu.neu.ccs.XString");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XString)this.requestObject(clazz, prompt, filter)).getValue();
        }

        public BigInteger demandBigInteger(String prompt) {
            return this.demandBigInteger(prompt, (StringableFilter)null);
        }

        public BigInteger demandBigInteger(String prompt, StringableFilter filter) {
            Class<?> clazz = class$9;
            if (clazz == null) {
                try {
                    clazz = class$9 = Class.forName("edu.neu.ccs.XBigInteger");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XBigInteger)this.demandObject(clazz, prompt, null, filter)).getValue();
        }

        public BigInteger demandBigInteger(String prompt, BigInteger value) {
            return this.demandBigInteger(prompt, value, null);
        }

        public BigInteger demandBigInteger(String prompt, BigInteger value, StringableFilter filter) {
            String data = value == null ? null : "" + value;
            Class<?> clazz = class$9;
            if (clazz == null) {
                try {
                    clazz = class$9 = Class.forName("edu.neu.ccs.XBigInteger");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XBigInteger)this.demandObject(clazz, prompt, data, filter)).getValue();
        }

        public BigInteger requestBigInteger(String prompt) throws CancelledException {
            return this.requestBigInteger(prompt, null);
        }

        public BigInteger requestBigInteger(String prompt, StringableFilter filter) throws CancelledException {
            Class<?> clazz = class$9;
            if (clazz == null) {
                try {
                    clazz = class$9 = Class.forName("edu.neu.ccs.XBigInteger");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XBigInteger)this.requestObject(clazz, prompt, filter)).getValue();
        }

        public BigDecimal demandBigDecimal(String prompt) {
            return this.demandBigDecimal(prompt, (StringableFilter)null);
        }

        public BigDecimal demandBigDecimal(String prompt, StringableFilter filter) {
            Class<?> clazz = class$10;
            if (clazz == null) {
                try {
                    clazz = class$10 = Class.forName("edu.neu.ccs.XBigDecimal");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XBigDecimal)this.demandObject(clazz, prompt, null, filter)).getValue();
        }

        public BigDecimal demandBigDecimal(String prompt, BigDecimal value) {
            return this.demandBigDecimal(prompt, value, null);
        }

        public BigDecimal demandBigDecimal(String prompt, BigDecimal value, StringableFilter filter) {
            String data = value == null ? null : "" + value;
            Class<?> clazz = class$10;
            if (clazz == null) {
                try {
                    clazz = class$10 = Class.forName("edu.neu.ccs.XBigDecimal");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XBigDecimal)this.demandObject(clazz, prompt, data, filter)).getValue();
        }

        public BigDecimal requestBigDecimal(String prompt) throws CancelledException {
            return this.requestBigDecimal(prompt, null);
        }

        public BigDecimal requestBigDecimal(String prompt, StringableFilter filter) throws CancelledException {
            Class<?> clazz = class$10;
            if (clazz == null) {
                try {
                    clazz = class$10 = Class.forName("edu.neu.ccs.XBigDecimal");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XBigDecimal)this.requestObject(clazz, prompt, filter)).getValue();
        }

        public Color demandColor(String prompt) {
            return this.demandColor(prompt, (StringableFilter)null);
        }

        public Color demandColor(String prompt, StringableFilter filter) {
            Class<?> clazz = class$11;
            if (clazz == null) {
                try {
                    clazz = class$11 = Class.forName("edu.neu.ccs.XColor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XColor)this.demandObject(clazz, prompt, null, filter)).getValue();
        }

        public Color demandColor(String prompt, Color value) {
            return this.demandColor(prompt, value, null);
        }

        public Color demandColor(String prompt, Color value, StringableFilter filter) {
            String data = value == null ? null : XColor.colorToString(value);
            Class<?> clazz = class$11;
            if (clazz == null) {
                try {
                    clazz = class$11 = Class.forName("edu.neu.ccs.XColor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XColor)this.demandObject(clazz, prompt, data, filter)).getValue();
        }

        public Color requestColor(String prompt) throws CancelledException {
            return this.requestColor(prompt, null);
        }

        public Color requestColor(String prompt, StringableFilter filter) throws CancelledException {
            Class<?> clazz = class$11;
            if (clazz == null) {
                try {
                    clazz = class$11 = Class.forName("edu.neu.ccs.XColor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ((XColor)this.requestObject(clazz, prompt, filter)).getValue();
        }
    }

    public class ConsoleOutputStream
    extends OutputStream {
        private int stream = 0;

        public ConsoleOutputStream(int destination) {
            this.stream = destination;
        }

        public void close() {
        }

        public void flush() throws IOException {
            ConsoleGateway.this.flush(this.stream);
        }

        public void write(byte[] b) {
            ConsoleGateway.this.write(new String(b), this.stream);
        }

        public void write(byte[] b, int offset, int length) {
            ConsoleGateway.this.write(new String(b, offset, length), this.stream);
        }

        public void write(int b) {
            ConsoleGateway.this.write("" + (char)b, this.stream);
        }
    }
}

