/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.Strings;
import edu.neu.ccs.util.JPTConstants;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Arrays;
import javax.swing.event.SwingPropertyChangeSupport;

public class XRect
extends Rectangle2D.Double
implements Serializable,
Stringable,
JPTConstants {
    private static String[] BLANK = new String[]{"", "", "", ""};
    private static String[] XYWH = new String[]{"x", "y", "w", "h"};
    private static String[] XYRS = new String[]{"xc", "yc", "r", "s"};
    private static String[] X1Y1X2Y2 = new String[]{"x1", "y1", "x2", "y2"};
    public static final String standardMessage = "\nXRect Error: Data format must be\n[...;...;...;...] or\n[x=...;y=...;w=...;h=...]\nwhere ... stands for\ncorner coordinate data x,y\nand width-height data w,h\nor must be\n[xc=...;yc=...;r=...;s=...]\nwhere ... stands for\ncenter coordinate data xc,yc\nand radius data r,s\nor must be\n[x1=...;y1=...;x2=...;y2=...]\nwhere ... stands for\nopposite`corner coordinate data\nx1,y1 and x2,y2\n";
    protected SwingPropertyChangeSupport changeAdapter = new SwingPropertyChangeSupport(this);

    public XRect() {
    }

    public XRect(double x, double y, double w, double h) {
        this.setXYWH(x, y, w, h);
    }

    public XRect(Rectangle2D rect) {
        this.setRect(rect);
    }

    public XRect(double r, double s) {
        this.setXYRS(0.0, 0.0, r, s);
    }

    public String toString() {
        double x = this.getX();
        double y = this.getY();
        double w = this.getWidth();
        double h = this.getHeight();
        return "XRect[x=" + x + ";y=" + y + ";w=" + w + ";h=" + h + "]";
    }

    public String toStringAsXYRS() {
        double xc = this.getCenterX();
        double yc = this.getCenterY();
        double r = this.getWidth() / 2.0;
        double s = this.getHeight() / 2.0;
        return "XRect[xc=" + xc + ";yc=" + yc + ";r=" + r + ";s=" + s + "]";
    }

    public String toStringAsX1Y1X2Y2() {
        double x1 = this.getMinX();
        double y1 = this.getMinY();
        double x2 = this.getMaxX();
        double y2 = this.getMaxY();
        return "XRect[x1=" + x1 + ";y1=" + y1 + ";x2=" + x2 + ";y2=" + y2 + "]";
    }

    public String toStringData() {
        double x = this.getX();
        double y = this.getY();
        double w = this.getWidth();
        double h = this.getHeight();
        return "[" + x + ";" + y + ";" + w + ";" + h + "]";
    }

    public void fromStringData(String data) throws ParseException {
        if (data == null) {
            throw new ParseException(standardMessage, -1);
        }
        String[] strings = Strings.decode(data);
        if (strings == null) {
            throw new ParseException(standardMessage, -1);
        }
        if (strings.length != 4) {
            throw new ParseException(standardMessage, -1);
        }
        Object[] names = Strings.getNames(strings);
        String[] values = Strings.getValues(strings);
        if (Arrays.equals(names, BLANK) || Arrays.equals(names, XYWH)) {
            names = XYWH;
        } else if (Arrays.equals(names, XYRS)) {
            names = XYRS;
        } else if (Arrays.equals(names, X1Y1X2Y2)) {
            names = X1Y1X2Y2;
        } else {
            throw new ParseException(standardMessage, -1);
        }
        double[] result = null;
        try {
            result = Strings.stringsToDoubles(values);
        }
        catch (ParseException ex) {
            throw Strings.makeAdjustedParseException(ex, "XRect", (String[])names);
        }
        if (names == XYWH) {
            this.setXYWH(result[0], result[1], result[2], result[3]);
            return;
        }
        if (names == XYRS) {
            this.setXYRS(result[0], result[1], result[2], result[3]);
            return;
        }
        if (names == X1Y1X2Y2) {
            this.setX1Y1X2Y2(result[0], result[1], result[2], result[3]);
            return;
        }
    }

    public void setXYWH(double x, double y, double w, double h) {
        if (w < 0.0) {
            w = Math.abs(w);
            x -= w;
        }
        if (h < 0.0) {
            h = Math.abs(h);
            y -= h;
        }
        super.setRect(x, y, w, h);
        this.changeAdapter.firePropertyChange("value", null, null);
    }

    public void setXYRS(double x, double y, double r, double s) {
        r = Math.abs(r);
        s = Math.abs(s);
        this.setXYWH(x - r, y - s, 2.0 * r, 2.0 * s);
    }

    public void setX1Y1X2Y2(double x1, double y1, double x2, double y2) {
        this.setXYWH(x1, y1, x2 - x1, y2 - y1);
    }

    public void setFrame(double x, double y, double w, double h) {
        this.setXYWH(x, y, w, h);
    }

    public void setFrame(Rectangle2D rect) {
        if (rect == null) {
            return;
        }
        double x = rect.getX();
        double y = rect.getY();
        double w = rect.getWidth();
        double h = rect.getHeight();
        this.setXYWH(x, y, w, h);
    }

    public void setFrame(Point2D point, Dimension2D dimension) {
        if (point == null || dimension == null) {
            return;
        }
        double x = point.getX();
        double y = point.getY();
        double w = dimension.getWidth();
        double h = dimension.getHeight();
        this.setXYWH(x, y, w, h);
    }

    public void setRect(double x, double y, double w, double h) {
        this.setXYWH(x, y, w, h);
    }

    public void setRect(Rectangle2D rect) {
        if (rect == null) {
            return;
        }
        double x = rect.getX();
        double y = rect.getY();
        double w = rect.getWidth();
        double h = rect.getHeight();
        this.setXYWH(x, y, w, h);
    }

    public void move(double dx, double dy) {
        double x = this.getX();
        double y = this.getY();
        double w = this.getWidth();
        double h = this.getHeight();
        this.setXYWH(x + dx, y + dy, w, h);
    }

    public void move(Point2D p) {
        if (p == null) {
            return;
        }
        this.move(p.getX(), p.getY());
    }

    public XRect createIntersectionRect(Rectangle2D rect) {
        return new XRect(this.createIntersection(rect));
    }

    public XRect createUnionRect(Rectangle2D rect) {
        return new XRect(this.createUnion(rect));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(propertyName, listener);
    }
}

