/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.Function;
import edu.neu.ccs.Parameter;
import edu.neu.ccs.Stringable;
import edu.neu.ccs.Strings;
import edu.neu.ccs.util.JPTConstants;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.ParseException;
import javax.swing.event.SwingPropertyChangeSupport;

public class XPolynomial
implements Function.OneArg,
Parameter.ArrayParam,
Stringable,
JPTConstants,
Serializable {
    public static final String standardMessage = "\nXPolynomial Error: Data format must be\n[...;...;...;etc] or\n[c0=...;c1=...;c2=...;etc]\nwhere ... stands for the polynomial coefficients\nin increasing order starting at index 0\nfrom left to right\n";
    private static String divisionMessage = "Division by zero in class XPolynomial";
    protected double[] coefficients = null;
    protected SwingPropertyChangeSupport changeAdapter = new SwingPropertyChangeSupport(this);

    public XPolynomial() {
    }

    public XPolynomial(int capacity) {
        this.setCapacity(capacity);
    }

    public XPolynomial(double[] params) {
        this.setCoefficients(params);
    }

    public XPolynomial(XPolynomial polynomial) {
        this.setCoefficients(polynomial);
    }

    public XPolynomial(String data) throws ParseException {
        this.fromStringData(data);
    }

    public XPolynomial(String[] strings) throws ParseException {
        this.fromStringArrayData(strings);
    }

    public void setPolynomialToZero() {
        if (this.coefficients != null) {
            this.coefficients = null;
            this.changeAdapter.firePropertyChange("value", null, null);
        }
    }

    public int getDegree() {
        if (this.coefficients == null) {
            return -1;
        }
        int d = this.coefficients.length - 1;
        while (d >= 0 && this.coefficients[d] == 0.0) {
            --d;
        }
        return d;
    }

    public int getCapacity() {
        if (this.coefficients == null) {
            return -1;
        }
        return this.coefficients.length - 1;
    }

    public void setCapacity(int capacity) {
        if (capacity < 0) {
            capacity = -1;
        }
        if (this.getCapacity() == capacity) {
            return;
        }
        int d = this.getDegree();
        if (capacity < 0) {
            this.coefficients = null;
        } else {
            int size = capacity + 1;
            double[] data = new double[size];
            if (this.coefficients != null) {
                size = Math.min(size, this.coefficients.length);
                int i = 0;
                while (i < size) {
                    data[i] = this.coefficients[i];
                    ++i;
                }
            }
            this.coefficients = data;
        }
        if (capacity < d) {
            this.changeAdapter.firePropertyChange("value", null, null);
        }
    }

    public void shrinkCapacity() {
        this.setCapacity(this.getDegree());
    }

    public double[] getCoefficients() {
        int d = this.getDegree();
        double[] values = new double[d + 1];
        int i = 0;
        while (i <= d) {
            values[i] = this.coefficients[i];
            ++i;
        }
        return values;
    }

    public void setCoefficients(double[] params) {
        if (params == null || params.length == 0) {
            this.coefficients = null;
        } else {
            int size = params.length;
            this.coefficients = new double[size];
            int i = 0;
            while (i < size) {
                this.coefficients[i] = params[i];
                ++i;
            }
        }
        this.changeAdapter.firePropertyChange("value", null, null);
    }

    public void setCoefficients(XPolynomial polynomial) {
        if (polynomial == null) {
            this.setPolynomialToZero();
        } else {
            this.setCoefficients(polynomial.getCoefficients());
        }
    }

    public double getCoefficient(int index) {
        if (index < 0) {
            return 0.0;
        }
        int capacity = this.getCapacity();
        if (index > capacity) {
            return 0.0;
        }
        return this.coefficients[index];
    }

    public void setCoefficient(int index, double value) {
        if (index < 0) {
            return;
        }
        int capacity = this.getCapacity();
        if (index > capacity) {
            this.setCapacity(index);
        }
        this.coefficients[index] = value;
        this.changeAdapter.firePropertyChange("value", null, null);
    }

    public double maxCoefficient() {
        int d = this.getDegree();
        if (d == -1) {
            return 0.0;
        }
        double max = Math.abs(this.coefficients[d]);
        int i = 0;
        while (i < d) {
            max = Math.max(max, Math.abs(this.coefficients[i]));
            ++i;
        }
        return max;
    }

    public boolean isZero() {
        return this.getDegree() == -1;
    }

    public boolean isAlmostZero(double epsilon) {
        int d = this.getDegree();
        if (d == -1) {
            return true;
        }
        epsilon = Math.abs(epsilon);
        int i = 0;
        while (i <= d) {
            if (Math.abs(this.coefficients[i]) > epsilon) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEqualTo(XPolynomial p) {
        if (p == null) {
            return this.isZero();
        }
        int d = this.getDegree();
        int e = p.getDegree();
        if (e != d) {
            return false;
        }
        int i = 0;
        while (i <= d) {
            if (this.coefficients[i] != p.coefficients[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isAlmostEqualTo(XPolynomial p, double epsilon) {
        if (p == null) {
            return this.isAlmostZero(epsilon);
        }
        epsilon = Math.abs(epsilon);
        int d = this.getDegree();
        int e = p.getDegree();
        int m = Math.min(d, e);
        int i = 0;
        while (i <= m) {
            if (Math.abs(this.coefficients[i] - p.coefficients[i]) > epsilon) {
                return false;
            }
            ++i;
        }
        i = m + 1;
        while (i <= d) {
            if (Math.abs(this.coefficients[i]) > epsilon) {
                return false;
            }
            ++i;
        }
        i = m + 1;
        while (i <= e) {
            if (Math.abs(p.coefficients[i]) > epsilon) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public double evaluate(double x) {
        int d = this.getDegree();
        if (d < 0) {
            return 0.0;
        }
        if (x == 0.0) {
            return this.coefficients[0];
        }
        double result = this.coefficients[d];
        int i = d - 1;
        while (i >= 0) {
            result *= x;
            result += this.coefficients[i];
            --i;
        }
        return result;
    }

    public void setParam(double[] params) {
        this.setCoefficients(params);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("XPolynomial[");
        int d = this.getDegree();
        int i = 0;
        while (i <= d) {
            buffer.append('c');
            buffer.append(Integer.toString(i));
            buffer.append('=');
            buffer.append(Double.toString(this.coefficients[i]));
            if (i < d) {
                buffer.append(';');
            }
            ++i;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public String toStringData() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        int d = this.getDegree();
        int i = 0;
        while (i <= d) {
            buffer.append(Double.toString(this.coefficients[i]));
            if (i < d) {
                buffer.append(';');
            }
            ++i;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public String[] toStringArrayData() {
        int d = this.getDegree();
        String[] strings = new String[d + 1];
        int i = 0;
        while (i <= d) {
            strings[i] = Double.toString(this.coefficients[i]);
            ++i;
        }
        return strings;
    }

    public void fromStringData(String data) throws ParseException {
        if (data == null) {
            throw new ParseException(standardMessage, -1);
        }
        data = data.trim();
        String[] split = Strings.splitIn2(data);
        String input = split[1].trim();
        String[] items = Strings.trim(Strings.decode(input));
        this.fromStringArrayData(items);
    }

    public void fromStringArrayData(String[] strings) throws ParseException {
        if (strings == null) {
            throw new ParseException(standardMessage, -1);
        }
        String[] values = Strings.getValues(strings);
        try {
            this.setCoefficients(Strings.stringsToDoubles(values));
        }
        catch (ParseException ex) {
            String message = ex.getMessage();
            int offset = ex.getErrorOffset();
            message = "\nXPolynomial error in term " + message + "\nat offset " + offset + "\n";
            throw new ParseException(message, -1);
        }
    }

    public static XPolynomial scale(double f, XPolynomial p) {
        if (p == null) {
            return new XPolynomial();
        }
        int d = p.getDegree();
        if (d == -1) {
            return new XPolynomial();
        }
        XPolynomial result = new XPolynomial(d);
        int i = 0;
        while (i <= d) {
            result.coefficients[i] = f * p.getCoefficient(i);
            ++i;
        }
        return result;
    }

    public static XPolynomial add(XPolynomial p, XPolynomial q) {
        if (p == null) {
            return new XPolynomial(q);
        }
        if (q == null) {
            return new XPolynomial(p);
        }
        int d = p.getDegree();
        int e = q.getDegree();
        if (d == -1) {
            return new XPolynomial(q);
        }
        if (e == -1) {
            return new XPolynomial(p);
        }
        int n = Math.max(d, e);
        XPolynomial result = new XPolynomial(n);
        int i = 0;
        while (i <= n) {
            result.coefficients[i] = p.getCoefficient(i) + q.getCoefficient(i);
            ++i;
        }
        return result;
    }

    public static XPolynomial subtract(XPolynomial p, XPolynomial q) {
        if (p == null) {
            return XPolynomial.scale(-1.0, q);
        }
        if (q == null) {
            return new XPolynomial(p);
        }
        int d = p.getDegree();
        int e = q.getDegree();
        if (d == -1) {
            return XPolynomial.scale(-1.0, q);
        }
        if (e == -1) {
            return new XPolynomial(p);
        }
        int n = Math.max(d, e);
        XPolynomial result = new XPolynomial(n);
        int i = 0;
        while (i <= n) {
            result.coefficients[i] = p.getCoefficient(i) - q.getCoefficient(i);
            ++i;
        }
        return result;
    }

    public static XPolynomial multiply(XPolynomial p, XPolynomial q) {
        if (p == null || q == null) {
            return new XPolynomial();
        }
        int d = p.getDegree();
        int e = q.getDegree();
        if (d == -1 || e == -1) {
            return new XPolynomial();
        }
        int n = d + e;
        XPolynomial result = new XPolynomial(n);
        int i = 0;
        while (i <= d) {
            int j = 0;
            while (j <= e) {
                int n2 = i + j;
                result.coefficients[n2] = result.coefficients[n2] + p.getCoefficient(i) * q.getCoefficient(j);
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static XPolynomial[] divide(XPolynomial p, XPolynomial q) {
        if (q == null) {
            throw new ArithmeticException(divisionMessage);
        }
        int e = q.getDegree();
        if (e == -1) {
            throw new ArithmeticException(divisionMessage);
        }
        if (p == null) {
            return new XPolynomial[]{new XPolynomial(), new XPolynomial()};
        }
        int d = p.getDegree();
        if (d == -1) {
            return new XPolynomial[]{new XPolynomial(), new XPolynomial()};
        }
        int n = d - e;
        XPolynomial quo = new XPolynomial(n);
        XPolynomial rem = new XPolynomial(p);
        if (n >= 0) {
            double leading = q.coefficients[e];
            int i = n;
            while (i >= 0) {
                double ratio;
                quo.coefficients[i] = ratio = rem.coefficients[e + i] / leading;
                rem.coefficients[e + i] = 0.0;
                int j = 0;
                while (j < e) {
                    int n2 = j + i;
                    rem.coefficients[n2] = rem.coefficients[n2] - ratio * q.coefficients[j];
                    ++j;
                }
                --i;
            }
        }
        rem.shrinkCapacity();
        return new XPolynomial[]{quo, rem};
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(propertyName, listener);
    }
}

