/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.Strings;
import edu.neu.ccs.XDouble;
import edu.neu.ccs.util.JPTConstants;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Arrays;
import javax.swing.event.SwingPropertyChangeSupport;

public class XPoint2D
extends Point2D.Double
implements Serializable,
Stringable,
JPTConstants {
    public static final String[] BLANK = new String[]{"", ""};
    public static final String[] XY = new String[]{"x", "y"};
    public static final String standardMessage = "\nXPoint2D Error: Data format must be\n[...;...] or\n[x=...;y=...]\nwhere ... stands for\nthe x,y coordinate data\n";
    protected SwingPropertyChangeSupport changeAdapter = new SwingPropertyChangeSupport(this);

    public XPoint2D() {
    }

    public XPoint2D(double x, double y) {
        this.setValue(x, y);
    }

    public XPoint2D(Point2D p) {
        this.setValue(p);
    }

    public XPoint2D(double[] data) {
        this.setValue(data);
    }

    public XPoint2D(float[] data) {
        this.setValue(data);
    }

    public XPoint2D(String data) throws ParseException {
        this.fromStringData(data);
    }

    public String toString() {
        return "XPoint2D[x=" + this.x + ";y=" + this.y + "]";
    }

    public String toStringData() {
        return "[" + this.x + ";" + this.y + "]";
    }

    public void fromStringData(String data) throws ParseException {
        if (data == null) {
            throw new ParseException(standardMessage, -1);
        }
        String[] strings = Strings.decode(data);
        if (strings == null) {
            throw new ParseException(standardMessage, -1);
        }
        if (strings.length != 2) {
            throw new ParseException(standardMessage, -1);
        }
        Object[] names = Strings.getNames(strings);
        String[] values = Strings.getValues(strings);
        if (!Arrays.equals(names, BLANK) && !Arrays.equals(names, XY)) {
            throw new ParseException(standardMessage, -1);
        }
        names = XY;
        double[] result = null;
        try {
            result = Strings.stringsToDoubles(values);
        }
        catch (ParseException ex) {
            throw Strings.makeAdjustedParseException(ex, "XPoint2D", (String[])names);
        }
        this.setValue(result[0], result[1]);
    }

    public void setValue(double x, double y) {
        double oldX = this.x;
        double oldY = this.y;
        if (x != oldX || y != oldY) {
            this.x = x;
            this.y = y;
            this.changeAdapter.firePropertyChange("value", null, null);
        }
    }

    public void setValue(Point2D p) {
        if (p != null) {
            this.setValue(p.getX(), p.getY());
        }
    }

    public void setValue(double[] data) {
        if (data == null || data.length != 2) {
            return;
        }
        this.setValue(data[0], data[1]);
    }

    public void setValue(float[] data) {
        if (data == null || data.length != 2) {
            return;
        }
        this.setValue(data[0], data[1]);
    }

    public void setLocation(double x, double y) {
        this.setValue(x, y);
    }

    public void setLocation(Point2D p) {
        this.setValue(p);
    }

    public void setLocation(double[] data) {
        if (data == null || data.length != 2) {
            return;
        }
        this.setValue(data[0], data[1]);
    }

    public void setLocation(float[] data) {
        if (data == null || data.length != 2) {
            return;
        }
        this.setValue(data[0], data[1]);
    }

    public void move(double dx, double dy) {
        double x = this.getX();
        double y = this.getY();
        this.setValue(x + dx, y + dy);
    }

    public void move(Point2D p) {
        if (p != null) {
            this.move(p.getX(), p.getY());
        }
    }

    public double[] toDoubleArray() {
        return new double[]{this.x, this.y};
    }

    public float[] toFloatArray() {
        return new float[]{(float)this.x, (float)this.y};
    }

    public double radius() {
        return this.distance(0.0, 0.0);
    }

    public double radiusSq() {
        return this.distanceSq(0.0, 0.0);
    }

    public double angleInRadians() {
        return XPoint2D.angleInRadians(1.0, 0.0, this.x, this.y);
    }

    public static double angleInRadians(Point2D p, Point2D q) {
        if (p != null && q != null) {
            return XPoint2D.angleInRadians(p.getX(), p.getY(), q.getX(), q.getY());
        }
        return 0.0;
    }

    public static double angleInRadians(double x1, double y1, double x2, double y2) {
        double radians = Math.atan2(y2, x2) - Math.atan2(y1, x1);
        if (radians < 0.0) {
            radians += Math.PI * 2;
        }
        return radians;
    }

    public double angleInDegrees() {
        return Math.toDegrees(this.angleInRadians());
    }

    public static double angleInDegrees(Point2D p, Point2D q) {
        return Math.toDegrees(XPoint2D.angleInRadians(p, q));
    }

    public static double angleInDegrees(double x1, double y1, double x2, double y2) {
        return Math.toDegrees(XPoint2D.angleInRadians(x1, y1, x2, y2));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(propertyName, listener);
    }

    public boolean isFinite() {
        return XPoint2D.isFinite(this);
    }

    public static boolean isFinite(Point2D p) {
        if (p == null) {
            return false;
        }
        return XDouble.isFinite(p.getX()) && XDouble.isFinite(p.getY());
    }
}

