/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.Strings;
import edu.neu.ccs.XPoint2D;
import edu.neu.ccs.util.JPTConstants;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Arrays;
import javax.swing.event.SwingPropertyChangeSupport;

public final class XLine2D
extends Line2D.Double
implements Serializable,
Stringable,
JPTConstants {
    private static String[] BLANK = new String[]{"", "", "", ""};
    private static String[] X1Y1X2Y2 = new String[]{"x1", "y1", "x2", "y2"};
    public static final String standardMessage = "\nXLine2D Error: Data format must be\n[...;...;...;...] or\n[x1=...;y1=...;x2=...;y2=...]\nwhere ... stands for\nthe endpoint coordinate data\nx1,y1 and x2,y2\n";
    protected SwingPropertyChangeSupport changeAdapter = new SwingPropertyChangeSupport(this);

    public XLine2D() {
    }

    public XLine2D(Line2D line) {
        this.setValue(line);
    }

    public XLine2D(Point2D p1, Point2D p2) {
        this.setValue(p1, p2);
    }

    public XLine2D(double x1, double y1, double x2, double y2) {
        this.setValue(x1, y1, x2, y2);
    }

    public XLine2D(String data) throws ParseException {
        this.fromStringData(data);
    }

    public String toString() {
        return "XLine2D[x1=" + this.x1 + ";y1=" + this.y1 + ";x2=" + this.x2 + ";y2=" + this.y2 + "]";
    }

    public String toStringData() {
        return "[" + this.x1 + ";" + this.y1 + ";" + this.x2 + ";" + this.y2 + "]";
    }

    public void fromStringData(String data) throws ParseException {
        if (data == null) {
            throw new ParseException(standardMessage, -1);
        }
        String[] strings = Strings.decode(data);
        if (strings == null) {
            throw new ParseException(standardMessage, -1);
        }
        if (strings.length != 4) {
            throw new ParseException(standardMessage, -1);
        }
        Object[] names = Strings.getNames(strings);
        String[] values = Strings.getValues(strings);
        if (!Arrays.equals(names, BLANK) && !Arrays.equals(names, X1Y1X2Y2)) {
            throw new ParseException(standardMessage, -1);
        }
        names = X1Y1X2Y2;
        double[] result = null;
        try {
            result = Strings.stringsToDoubles(values);
        }
        catch (ParseException ex) {
            throw Strings.makeAdjustedParseException(ex, "XLine2D", (String[])names);
        }
        this.setValue(result[0], result[1], result[2], result[3]);
    }

    public void setValue(Line2D line) {
        if (line != null) {
            this.setValue(line.getX1(), line.getY1(), line.getX2(), line.getY2());
        }
    }

    public void setValue(Point2D p1, Point2D p2) {
        if (p1 != null && p2 != null) {
            this.setValue(p1.getX(), p1.getY(), p2.getX(), p2.getY());
        }
    }

    public void setValue(double x1, double y1, double x2, double y2) {
        double oldX1 = this.x1;
        double oldY1 = this.y1;
        double oldX2 = this.x2;
        double oldY2 = this.y2;
        if (x1 != oldX1 || y1 != oldY1 || x2 != oldX2 || y2 != oldY2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.changeAdapter.firePropertyChange("value", null, null);
        }
    }

    public void setLine(Line2D line) {
        this.setValue(line);
    }

    public void setLine(Point2D p1, Point2D p2) {
        this.setValue(p1, p2);
    }

    public void setLine(double x1, double y1, double x2, double y2) {
        this.setValue(x1, y1, x2, y2);
    }

    public void move(double dx, double dy) {
        this.setValue(this.x1 + dx, this.y1 + dy, this.x2 + dx, this.y2 + dy);
    }

    public void move(Point2D p) {
        if (p == null) {
            return;
        }
        this.move(p.getX(), p.getY());
    }

    public double length() {
        return Point2D.distance(this.x1, this.y1, this.x2, this.y2);
    }

    public double lengthSq() {
        return Point2D.distanceSq(this.x1, this.y1, this.x2, this.y2);
    }

    public double angleInRadians() {
        return XPoint2D.angleInRadians(this.x1, this.y1, this.x2, this.y2);
    }

    public double angleInDegrees() {
        return XPoint2D.angleInDegrees(this.x1, this.y1, this.x2, this.y2);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(propertyName, listener);
    }
}

