/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.Function;
import edu.neu.ccs.Stringable;
import edu.neu.ccs.Strings;
import edu.neu.ccs.XDouble;
import edu.neu.ccs.util.JPTConstants;
import edu.neu.ccs.util.MathUtilities;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.ParseException;
import javax.swing.event.SwingPropertyChangeSupport;

public class XFourier
implements Function.OneArg,
Stringable,
JPTConstants,
Serializable {
    public static final String standardMessage = "\nXFourier Error: Data format must be\n{type|constant|[...;...]|[...;...]} or\n{type|constant|[s1=...;s2=...;etc]|[c1=...;c2=...;etc]}\nwhere type is the letter r or d for radians or degrees,\nconstant is the fourier constant term,\nand the two groups [...;...] stand\nfor the fourier sin coefficients\nand the fourier cos coefficients\nin increasing order starting at index 1\nfrom left to right\n";
    public static final Type RADIANS = new Type(){

        public double sin(double x) {
            return Math.sin(x);
        }

        public double cos(double x) {
            return Math.cos(x);
        }

        public String toString() {
            return "r";
        }
    };
    public static final Type DEGREES = new Type(){

        public double sin(double x) {
            return MathUtilities.sindeg(x);
        }

        public double cos(double x) {
            return MathUtilities.cosdeg(x);
        }

        public String toString() {
            return "d";
        }
    };
    protected Type type = RADIANS;
    protected double constant = 0.0;
    protected double[] sinCoefficients = null;
    protected double[] cosCoefficients = null;
    protected SwingPropertyChangeSupport changeAdapter = new SwingPropertyChangeSupport(this);

    public XFourier() {
    }

    public XFourier(Type type, double constant, double[] sinArray, double[] cosArray) {
        this.setFourier(type, constant, sinArray, cosArray);
    }

    public XFourier(XFourier fourier) {
        this.copyFourier(fourier);
    }

    public XFourier(String data) throws ParseException {
        this.fromStringData(data);
    }

    public void setFourierToZero() {
        this.setFourier(this.type, 0.0, null, null);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        if (type == null) {
            type = RADIANS;
        }
        this.type = type;
        this.changeAdapter.firePropertyChange("value", null, null);
    }

    public void setTypeViaString(String type) {
        this.setType(this.getTypeViaString(type));
    }

    private Type getTypeViaString(String string) {
        char c;
        Type type = RADIANS;
        if (string != null && string.length() > 0 && ((c = string.charAt(0)) == 'D' || c == 'd')) {
            type = DEGREES;
        }
        return type;
    }

    public double getConstant() {
        return this.constant;
    }

    public void setConstant(double constant) {
        this.constant = constant;
        this.changeAdapter.firePropertyChange("value", null, null);
    }

    public int getSinDegree() {
        if (this.sinCoefficients == null) {
            return -1;
        }
        int d = this.sinCoefficients.length - 1;
        while (d >= 1 && this.sinCoefficients[d] == 0.0) {
            --d;
        }
        if (d == 0) {
            d = -1;
        }
        return d;
    }

    public int getCosDegree() {
        if (this.cosCoefficients == null) {
            return -1;
        }
        int d = this.cosCoefficients.length - 1;
        while (d >= 1 && this.cosCoefficients[d] == 0.0) {
            --d;
        }
        if (d == 0) {
            d = -1;
        }
        return d;
    }

    public int getSinCapacity() {
        if (this.sinCoefficients == null) {
            return -1;
        }
        int d = this.sinCoefficients.length - 1;
        if (d == 0) {
            d = -1;
        }
        return d;
    }

    public int getCosCapacity() {
        if (this.cosCoefficients == null) {
            return -1;
        }
        int d = this.cosCoefficients.length - 1;
        if (d == 0) {
            d = -1;
        }
        return d;
    }

    public void setSinCapacity(int capacity) {
        if (capacity <= 0) {
            capacity = -1;
        }
        if (this.getSinCapacity() == capacity) {
            return;
        }
        int d = this.getSinDegree();
        if (capacity < 0) {
            this.sinCoefficients = null;
        } else {
            int size = capacity + 1;
            double[] data = new double[size];
            if (this.sinCoefficients != null) {
                size = Math.min(size, this.sinCoefficients.length);
                int i = 1;
                while (i < size) {
                    data[i] = this.sinCoefficients[i];
                    ++i;
                }
            }
            this.sinCoefficients = data;
        }
        if (capacity < d) {
            this.changeAdapter.firePropertyChange("value", null, null);
        }
    }

    public void setCosCapacity(int capacity) {
        if (capacity <= 0) {
            capacity = -1;
        }
        if (this.getCosCapacity() == capacity) {
            return;
        }
        int d = this.getCosDegree();
        if (capacity < 0) {
            this.cosCoefficients = null;
        } else {
            int size = capacity + 1;
            double[] data = new double[size];
            if (this.cosCoefficients != null) {
                size = Math.min(size, this.cosCoefficients.length);
                int i = 1;
                while (i < size) {
                    data[i] = this.cosCoefficients[i];
                    ++i;
                }
            }
            this.cosCoefficients = data;
        }
        if (capacity < d) {
            this.changeAdapter.firePropertyChange("value", null, null);
        }
    }

    public void shrinkCapacity() {
        this.setSinCapacity(this.getSinDegree());
        this.setCosCapacity(this.getCosDegree());
    }

    public double[] getSinCoefficients() {
        int d = this.getSinDegree();
        double[] values = new double[d + 1];
        int i = 1;
        while (i <= d) {
            values[i] = this.sinCoefficients[i];
            ++i;
        }
        return values;
    }

    public double[] getCosCoefficients() {
        int d = this.getCosDegree();
        double[] values = new double[d + 1];
        int i = 1;
        while (i <= d) {
            values[i] = this.cosCoefficients[i];
            ++i;
        }
        return values;
    }

    public void setSinCoefficients(double[] sinArray) {
        if (sinArray == null || sinArray.length <= 1) {
            this.sinCoefficients = null;
        } else {
            int size = sinArray.length;
            this.sinCoefficients = new double[size];
            int i = 1;
            while (i < size) {
                this.sinCoefficients[i] = sinArray[i];
                ++i;
            }
        }
        this.changeAdapter.firePropertyChange("value", null, null);
    }

    public void setCosCoefficients(double[] cosArray) {
        if (cosArray == null || cosArray.length <= 1) {
            this.cosCoefficients = null;
        } else {
            int size = cosArray.length;
            this.cosCoefficients = new double[size];
            int i = 1;
            while (i < size) {
                this.cosCoefficients[i] = cosArray[i];
                ++i;
            }
        }
        this.changeAdapter.firePropertyChange("value", null, null);
    }

    public double getSinCoefficient(int index) {
        if (index <= 0) {
            return 0.0;
        }
        int capacity = this.getSinCapacity();
        if (index > capacity) {
            return 0.0;
        }
        return this.sinCoefficients[index];
    }

    public double getCosCoefficient(int index) {
        if (index <= 0) {
            return 0.0;
        }
        int capacity = this.getCosCapacity();
        if (index > capacity) {
            return 0.0;
        }
        return this.cosCoefficients[index];
    }

    public void setSinCoefficient(int index, double value) {
        if (index <= 0) {
            return;
        }
        int capacity = this.getSinCapacity();
        if (index > capacity) {
            this.setSinCapacity(index);
        }
        this.sinCoefficients[index] = value;
        this.changeAdapter.firePropertyChange("value", null, null);
    }

    public void setCosCoefficient(int index, double value) {
        if (index <= 0) {
            return;
        }
        int capacity = this.getCosCapacity();
        if (index > capacity) {
            this.setCosCapacity(index);
        }
        this.cosCoefficients[index] = value;
        this.changeAdapter.firePropertyChange("value", null, null);
    }

    public double maxCoefficient() {
        int i;
        double max = Math.abs(this.constant);
        int d = this.getSinDegree();
        if (d >= 1) {
            i = 1;
            while (i <= d) {
                max = Math.max(max, Math.abs(this.sinCoefficients[i]));
                ++i;
            }
        }
        if ((d = this.getCosDegree()) >= 1) {
            i = 1;
            while (i <= d) {
                max = Math.max(max, Math.abs(this.cosCoefficients[i]));
                ++i;
            }
        }
        return max;
    }

    public void setFourier(Type type, double constant, double[] sinArray, double[] cosArray) {
        int i;
        int size;
        if (type == null) {
            type = RADIANS;
        }
        this.type = type;
        this.constant = constant;
        if (sinArray == null || sinArray.length <= 1) {
            this.sinCoefficients = null;
        } else {
            size = sinArray.length;
            this.sinCoefficients = new double[size];
            i = 1;
            while (i < size) {
                this.sinCoefficients[i] = sinArray[i];
                ++i;
            }
        }
        if (cosArray == null || cosArray.length <= 1) {
            this.cosCoefficients = null;
        } else {
            size = cosArray.length;
            this.cosCoefficients = new double[size];
            i = 1;
            while (i < size) {
                this.cosCoefficients[i] = cosArray[i];
                ++i;
            }
        }
        this.changeAdapter.firePropertyChange("value", null, null);
    }

    public void copyFourier(XFourier fourier) {
        if (fourier == null) {
            this.setFourierToZero();
        } else {
            this.setFourier(fourier.getType(), fourier.getConstant(), fourier.getSinCoefficients(), fourier.getCosCoefficients());
        }
    }

    public boolean isZero() {
        return this.constant == 0.0 && this.getSinDegree() == -1 && this.getCosDegree() == -1;
    }

    public boolean isAlmostZero(double epsilon) {
        epsilon = Math.abs(epsilon);
        return this.maxCoefficient() <= epsilon;
    }

    public boolean isEqualTo(XFourier fourier) {
        if (fourier == null) {
            return false;
        }
        if (fourier.getType() != this.type) {
            return false;
        }
        if (fourier.getConstant() != this.constant) {
            return false;
        }
        int ds = this.getSinDegree();
        int dc = this.getCosDegree();
        int es = fourier.getSinDegree();
        int ec = fourier.getCosDegree();
        if (es != ds || ec != dc) {
            return false;
        }
        int i = 1;
        while (i <= ds) {
            if (fourier.getSinCoefficient(i) != this.getSinCoefficient(i)) {
                return false;
            }
            ++i;
        }
        i = 1;
        while (i <= es) {
            if (fourier.getCosCoefficient(i) != this.getCosCoefficient(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isAlmostEqualTo(XFourier fourier, double epsilon) {
        if (fourier == null) {
            return false;
        }
        if (fourier.getType() != this.type) {
            return false;
        }
        return XFourier.subtract(this, fourier).isAlmostZero(epsilon);
    }

    public double evaluate(double x) {
        double result = this.constant;
        int ds = this.getSinDegree();
        int i = 1;
        while (i <= ds) {
            double z = this.sinCoefficients[i];
            if (z != 0.0) {
                result += z * this.type.sin((double)i * x);
            }
            ++i;
        }
        int dc = this.getCosDegree();
        int i2 = 1;
        while (i2 <= dc) {
            double z = this.cosCoefficients[i2];
            if (z != 0.0) {
                result += z * this.type.cos((double)i2 * x);
            }
            ++i2;
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("XFourier{");
        buffer.append(this.type);
        if (!this.isZero()) {
            buffer.append('|');
            buffer.append(this.constant);
            buffer.append('|');
            buffer.append('[');
            int ds = this.getSinDegree();
            int i = 1;
            while (i <= ds) {
                buffer.append('s');
                buffer.append(Integer.toString(i));
                buffer.append('=');
                buffer.append(Double.toString(this.sinCoefficients[i]));
                if (i < ds) {
                    buffer.append(';');
                }
                ++i;
            }
            buffer.append(']');
            buffer.append('|');
            buffer.append('[');
            int dc = this.getCosDegree();
            int i2 = 1;
            while (i2 <= dc) {
                buffer.append('c');
                buffer.append(Integer.toString(i2));
                buffer.append('=');
                buffer.append(Double.toString(this.cosCoefficients[i2]));
                if (i2 < ds) {
                    buffer.append(';');
                }
                ++i2;
            }
            buffer.append(']');
        }
        buffer.append("}");
        return buffer.toString();
    }

    public String toStringData() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        buffer.append(this.type);
        if (!this.isZero()) {
            buffer.append('|');
            buffer.append(this.constant);
            buffer.append('|');
            buffer.append('[');
            int ds = this.getSinDegree();
            int i = 1;
            while (i <= ds) {
                buffer.append(Double.toString(this.sinCoefficients[i]));
                if (i < ds) {
                    buffer.append(';');
                }
                ++i;
            }
            buffer.append(']');
            buffer.append('|');
            buffer.append('[');
            int dc = this.getCosDegree();
            int i2 = 1;
            while (i2 <= dc) {
                buffer.append(Double.toString(this.cosCoefficients[i2]));
                if (i2 < ds) {
                    buffer.append(';');
                }
                ++i2;
            }
            buffer.append(']');
        }
        buffer.append("}");
        return buffer.toString();
    }

    public void fromStringData(String data) throws ParseException {
        if (data == null) {
            throw new ParseException(standardMessage, -1);
        }
        String[] split = Strings.splitIn2(data = data.trim());
        String input = split[1].trim();
        if (!Strings.isStartEnd(input, '{', '}')) {
            throw new ParseException(standardMessage, -1);
        }
        String[] items = Strings.trim(Strings.decode(input));
        int length = items.length;
        if (length == 1) {
            this.setFourier(this.getTypeViaString(items[0]), 0.0, null, null);
            return;
        }
        if (length == 4) {
            this.parse4(items);
            return;
        }
        throw new ParseException(standardMessage, -1);
    }

    private void parse4(String[] items) throws ParseException {
        Type type = this.getTypeViaString(items[0]);
        double constant = this.parseFourierConstant(items[1]);
        double[] sinArray = this.parseFourierCoefficients(items[2], "sin");
        double[] cosArray = this.parseFourierCoefficients(items[3], "cos");
        this.setFourier(type, constant, sinArray, cosArray);
    }

    private double parseFourierConstant(String term) throws ParseException {
        double value = 0.0;
        try {
            XDouble xdouble = new XDouble();
            xdouble.fromStringData(term);
            value = xdouble.getValue();
        }
        catch (ParseException ex) {
            String message = ex.getMessage();
            int offset = ex.getErrorOffset();
            message = "\nXFourier constant error:\n" + message + "\nat offset: " + offset + "\n";
            throw new ParseException(message, -1);
        }
        return value;
    }

    private double[] parseFourierCoefficients(String terms, String name) throws ParseException {
        double[] array = null;
        try {
            if (!Strings.isStartEnd(terms, '[', ']')) {
                throw new ParseException(standardMessage, -1);
            }
            String expandedterms = "[0;" + terms.substring(1);
            String[] inner = Strings.trim(Strings.decode(expandedterms));
            inner = Strings.getValues(inner);
            array = Strings.stringsToDoubles(inner);
        }
        catch (ParseException ex) {
            String message = ex.getMessage();
            int offset = ex.getErrorOffset();
            message = "\nXFourier " + name + " term error:\n" + terms + "\nin term " + message + "\nat offset " + offset + "\n";
            throw new ParseException(message, -1);
        }
        return array;
    }

    public static XFourier scale(double f, XFourier fourier) {
        if (fourier == null) {
            return new XFourier();
        }
        Type type = fourier.getType();
        double constant = f * fourier.getConstant();
        int ds = fourier.getSinDegree();
        int dc = fourier.getCosDegree();
        double[] sinArray = null;
        double[] cosArray = null;
        if (ds > 0) {
            sinArray = new double[ds + 1];
        }
        if (dc > 0) {
            cosArray = new double[dc + 1];
        }
        int i = 1;
        while (i <= ds) {
            sinArray[i] = f * fourier.getSinCoefficient(i);
            ++i;
        }
        i = 1;
        while (i <= dc) {
            cosArray[i] = f * fourier.getCosCoefficient(i);
            ++i;
        }
        return new XFourier(type, constant, sinArray, cosArray);
    }

    public static XFourier add(XFourier p, XFourier q) {
        if (p == null) {
            return new XFourier(q);
        }
        if (q == null) {
            return new XFourier(p);
        }
        if (p.getType() != q.getType()) {
            throw new RuntimeException("Input type mismatch in XFourier.add");
        }
        Type type = p.getType();
        double constant = p.getConstant() + q.getConstant();
        int ds = Math.max(p.getSinDegree(), q.getSinDegree());
        int dc = Math.max(p.getCosDegree(), q.getCosDegree());
        double[] sinArray = null;
        double[] cosArray = null;
        if (ds > 0) {
            sinArray = new double[ds + 1];
        }
        if (dc > 0) {
            cosArray = new double[dc + 1];
        }
        int i = 1;
        while (i <= ds) {
            sinArray[i] = p.getSinCoefficient(i) + q.getSinCoefficient(i);
            ++i;
        }
        i = 1;
        while (i <= dc) {
            cosArray[i] = p.getCosCoefficient(i) + q.getCosCoefficient(i);
            ++i;
        }
        return new XFourier(type, constant, sinArray, cosArray);
    }

    public static XFourier subtract(XFourier p, XFourier q) {
        if (p == null) {
            return XFourier.scale(-1.0, q);
        }
        if (q == null) {
            return new XFourier(p);
        }
        if (p.getType() != q.getType()) {
            throw new RuntimeException("Input type mismatch in XFourier.subtract");
        }
        Type type = p.getType();
        double constant = p.getConstant() - q.getConstant();
        int ds = Math.max(p.getSinDegree(), q.getSinDegree());
        int dc = Math.max(p.getCosDegree(), q.getCosDegree());
        double[] sinArray = null;
        double[] cosArray = null;
        if (ds > 0) {
            sinArray = new double[ds + 1];
        }
        if (dc > 0) {
            cosArray = new double[dc + 1];
        }
        int i = 1;
        while (i <= ds) {
            sinArray[i] = p.getSinCoefficient(i) - q.getSinCoefficient(i);
            ++i;
        }
        i = 1;
        while (i <= dc) {
            cosArray[i] = p.getCosCoefficient(i) - q.getCosCoefficient(i);
            ++i;
        }
        return new XFourier(type, constant, sinArray, cosArray);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(propertyName, listener);
    }

    public static abstract class Type {
        Type() {
        }

        public abstract double sin(double var1);

        public abstract double cos(double var1);

        public abstract String toString();
    }
}

