/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.XNumber;
import edu.neu.ccs.parser.BaseParser;
import edu.neu.ccs.parser.ParserUtilities;
import java.text.ParseException;

public class XFloat
extends XNumber {
    private float value = 0.0f;

    public XFloat() {
    }

    public XFloat(float v) {
        this.value = v;
    }

    public XFloat(String s) throws ParseException {
        this.fromStringData(s);
    }

    public void fromStringData(String data) throws ParseException {
        float oldValue = this.value;
        BaseParser p = ParserUtilities.getDefaultParser();
        Object obj = p.parse(data);
        if (!(obj instanceof XNumber)) {
            throw new ParseException("Expected numeric value.", data.length());
        }
        XNumber n = (XNumber)obj;
        this.value = n.floatValue();
        this.changeAdapter.firePropertyChange("value", new Float(oldValue), data);
    }

    public String toStringData() {
        return String.valueOf(this.value);
    }

    public byte byteValue() {
        if (this.getValue() > 127.0f || this.getValue() < -128.0f) {
            throw new NumberFormatException("Number beyond precision of a byte.");
        }
        return (byte)this.getValue();
    }

    public short shortValue() {
        if (this.getValue() > 32767.0f || this.getValue() < -32768.0f) {
            throw new NumberFormatException("Number beyond precision of a short.");
        }
        return (short)this.getValue();
    }

    public int intValue() {
        if (this.getValue() > 2.1474836E9f || this.getValue() < -2.1474836E9f) {
            throw new NumberFormatException("Number beyond precision of an int.");
        }
        return (int)this.getValue();
    }

    public long longValue() {
        if (this.getValue() > 9.223372E18f || this.getValue() < -9.223372E18f) {
            throw new NumberFormatException("Number beyond precision of a long.");
        }
        return (long)this.getValue();
    }

    public float floatValue() {
        return this.getValue();
    }

    public double doubleValue() {
        return this.getValue();
    }

    public boolean equals(Object other) {
        if (other instanceof XFloat) {
            return this.getValue() == ((XFloat)other).getValue();
        }
        return false;
    }

    public int hashCode() {
        return new Float(this.getValue()).hashCode();
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public void setValue(float f) {
        float oldValue = this.value;
        this.value = f;
        if (this.getValue() != oldValue) {
            this.changeAdapter.firePropertyChange("value", new Float(oldValue), new Float(this.value));
        }
    }

    public float getValue() {
        return this.value;
    }

    public static float parseFloat(String s) throws NumberFormatException {
        try {
            return new XFloat((String)s).value;
        }
        catch (ParseException e) {
            throw new NumberFormatException(XFloat.formatErrorMessage(e, s));
        }
    }

    public static float[] toPrimitiveArray(XFloat[] x) {
        if (x == null) {
            return null;
        }
        float[] temp = new float[x.length];
        int i = 0;
        while (i < temp.length) {
            if (x[i] != null) {
                temp[i] = x[i].getValue();
            }
            ++i;
        }
        return temp;
    }

    public static XFloat[] toXArray(float[] a) {
        if (a == null) {
            return null;
        }
        XFloat[] temp = new XFloat[a.length];
        int i = 0;
        while (i < temp.length) {
            temp[i] = new XFloat(a[i]);
            ++i;
        }
        return temp;
    }
}

