/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.Colors;
import edu.neu.ccs.XLong;
import edu.neu.ccs.XObject;
import edu.neu.ccs.filter.FilterException;
import edu.neu.ccs.filter.RangeFilter;
import edu.neu.ccs.util.Hex;
import java.awt.Color;
import java.text.ParseException;
import java.util.StringTokenizer;

public final class XColor
extends XObject {
    private Color color = Color.black;

    public XColor() {
    }

    public XColor(Color c) {
        this.setValue(c);
    }

    public XColor(int r, int g, int b) {
        this(new Color(r, g, b));
    }

    public XColor(int r, int g, int b, int a) {
        this(new Color(r, g, b, a));
    }

    public XColor(float r, float g, float b) {
        this(new Color(r, g, b));
    }

    public XColor(float r, float g, float b, float a) {
        this(new Color(r, g, b, a));
    }

    public XColor(String s) throws ParseException {
        this.fromStringData(s);
    }

    public void fromStringData(String data) throws ParseException {
        if (data == null) {
            throw new ParseException("Color string data is null", -1);
        }
        if (data.length() == 0) {
            throw new ParseException("Color string data has zero length", -1);
        }
        if ((data = data.trim()).length() == 0) {
            throw new ParseException("Color string data contains only white space", -1);
        }
        char first = data.charAt(0);
        if (Character.isLetter(first)) {
            Color color = Colors.getColorFromName(data);
            if (color != null) {
                this.setValue(color);
                return;
            }
            throw new ParseException("Unrecognized color name in color string data", -1);
        }
        if (first == '#') {
            this.setValue(this.getColorFromHexidecimal(data));
            return;
        }
        if (Character.isDigit(first)) {
            this.setValue(this.getColorFromDecimal(data));
            return;
        }
        throw new ParseException("Color string data must be decimal r,g,b,alpha data, or hex data, or a name", -1);
    }

    private Color getColorFromDecimal(String data) throws ParseException {
        String message = "Decimal color data must have the form r,g,b or r,g,b,alpha with values between 0 and 255";
        StringTokenizer tokenizer = new StringTokenizer(data, ", ");
        int arraysize = tokenizer.countTokens();
        if (arraysize < 3 || arraysize > 4) {
            throw new ParseException(message, -1);
        }
        String[] component = new String[arraysize];
        int i = 0;
        while (i < arraysize) {
            component[i] = tokenizer.nextToken();
            ++i;
        }
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 255;
        try {
            RangeFilter.Long filter = new RangeFilter.Long(0L, 255L);
            XLong R = (XLong)filter.filterStringable(new XLong(component[0]));
            r = (int)R.getValue();
            XLong G = (XLong)filter.filterStringable(new XLong(component[1]));
            g = (int)G.getValue();
            XLong B = (XLong)filter.filterStringable(new XLong(component[2]));
            b = (int)B.getValue();
            if (arraysize == 4) {
                XLong A = (XLong)filter.filterStringable(new XLong(component[3]));
                a = (int)A.getValue();
            }
        }
        catch (NumberFormatException ex) {
            throw new ParseException(message, -1);
        }
        catch (FilterException ex) {
            throw new ParseException(message, -1);
        }
        return new Color(r, g, b, a);
    }

    private Color getColorFromHexidecimal(String data) throws ParseException {
        boolean ok;
        String message = "Hexidecimal color data must have the form #... with 3, 4, 6, or 8 hex digits";
        int length = (data = data.substring(1)).length();
        boolean bl = ok = length == 3 || length == 4 || length == 6 || length == 8;
        if (ok) {
            int i = 0;
            while (i < length) {
                if (!Hex.isHexDigit(data.charAt(i))) {
                    ok = false;
                    break;
                }
                ++i;
            }
        }
        if (!ok) {
            throw new ParseException(message, -1);
        }
        StringBuffer buffer = new StringBuffer(8);
        if (length <= 4) {
            char r = data.charAt(0);
            char g = data.charAt(1);
            char b = data.charAt(2);
            buffer.append(r);
            buffer.append(r);
            buffer.append(g);
            buffer.append(g);
            buffer.append(b);
            buffer.append(b);
            if (length == 4) {
                char a = data.charAt(3);
                buffer.append(a);
                buffer.append(a);
            }
            data = buffer.toString();
            length *= 2;
        }
        String rR = data.substring(0, 2);
        String gG = data.substring(2, 4);
        String bB = data.substring(4, 6);
        String aA = length == 8 ? data.substring(6, 8) : "ff";
        return new Color(Hex.hexToInt(rR), Hex.hexToInt(gG), Hex.hexToInt(bB), Hex.hexToInt(aA));
    }

    public String toStringData() {
        int r = this.color.getRed();
        int g = this.color.getGreen();
        int b = this.color.getBlue();
        int a = this.color.getAlpha();
        if (a == 255) {
            return String.valueOf(r) + ", " + g + ", " + b;
        }
        return String.valueOf(r) + ", " + g + ", " + b + ", " + a;
    }

    public String toString() {
        return this.toStringData();
    }

    public boolean equals(Object other) {
        if (other instanceof XColor) {
            return this.getValue().equals(((XColor)other).getValue());
        }
        return false;
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public void setValue(Color c) {
        Color oldValue = this.color;
        if (c == null) {
            c = Color.black;
        }
        this.color = c;
        if (!this.getValue().equals(oldValue)) {
            this.changeAdapter.firePropertyChange("value", oldValue, this.getValue());
        }
    }

    public void setValue(int r, int g, int b) {
        this.setValue(new Color(r, g, b));
    }

    public void setValue(int r, int g, int b, int a) {
        this.setValue(new Color(r, g, b, a));
    }

    public void setValue(float r, float g, float b) {
        this.setValue(new Color(r, g, b));
    }

    public void setValue(float r, float g, float b, float a) {
        this.setValue(new Color(r, g, b, a));
    }

    public Color getValue() {
        return this.color;
    }

    public static Color getColor(String data) {
        try {
            return XColor.parseColor(data);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public static Color parseColor(String data) throws ParseException {
        return new XColor((String)data).color;
    }

    public static String colorToString(Color color) {
        return new XColor(color).toStringData();
    }

    public static Color[] toPrimitiveArray(XColor[] x) {
        if (x == null) {
            return null;
        }
        Color[] temp = new Color[x.length];
        int i = 0;
        while (i < temp.length) {
            if (x[i] != null) {
                temp[i] = x[i].getValue();
            }
            ++i;
        }
        return temp;
    }

    public static XColor[] toXArray(Color[] a) {
        if (a == null) {
            return null;
        }
        XColor[] temp = new XColor[a.length];
        int i = 0;
        while (i < temp.length) {
            if (a[i] != null) {
                temp[i] = new XColor(a[i]);
            }
            ++i;
        }
        return temp;
    }
}

