/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.XObject;
import edu.neu.ccs.parser.BaseParser;
import edu.neu.ccs.parser.ParserUtilities;
import java.text.ParseException;

public class XBoolean
extends XObject {
    private boolean value = false;

    public XBoolean() {
    }

    public XBoolean(boolean b) {
        this.value = b;
    }

    public XBoolean(String s) throws ParseException {
        this.fromStringData(s);
    }

    public void fromStringData(String data) throws ParseException {
        boolean oldValue = this.value;
        BaseParser p = ParserUtilities.getDefaultParser();
        Object obj = p.parse(data);
        if (!(obj instanceof XBoolean)) {
            throw new ParseException("Expected boolean value.", data.length());
        }
        XBoolean b = (XBoolean)obj;
        this.value = b.getValue();
        this.changeAdapter.firePropertyChange("value", new Boolean(oldValue), data);
    }

    public String toStringData() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object other) {
        if (other instanceof XBoolean) {
            return this.getValue() == ((XBoolean)other).getValue();
        }
        return false;
    }

    public int hashCode() {
        return new Boolean(this.getValue()).hashCode();
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public void setValue(boolean b) {
        boolean oldValue = this.value;
        this.value = b;
        if (this.getValue() != oldValue) {
            this.changeAdapter.firePropertyChange("value", new Boolean(oldValue), new Boolean(this.getValue()));
        }
    }

    public boolean getValue() {
        return this.value;
    }

    public static boolean parseBoolean(String data) throws NumberFormatException {
        try {
            return new XBoolean((String)data).value;
        }
        catch (ParseException e) {
            throw new NumberFormatException(XBoolean.formatErrorMessage(e, data));
        }
    }

    public static boolean[] toPrimitiveArray(XBoolean[] x) {
        if (x == null) {
            return null;
        }
        boolean[] temp = new boolean[x.length];
        int i = 0;
        while (i < temp.length) {
            if (x[i] != null) {
                temp[i] = x[i].getValue();
            }
            ++i;
        }
        return temp;
    }

    public static XBoolean[] toXArray(boolean[] a) {
        if (a == null) {
            return null;
        }
        XBoolean[] temp = new XBoolean[a.length];
        int i = 0;
        while (i < temp.length) {
            temp[i] = new XBoolean(a[i]);
            ++i;
        }
        return temp;
    }
}

