/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.XNumber;
import edu.neu.ccs.parser.BaseParser;
import edu.neu.ccs.parser.ParserUtilities;
import java.math.BigInteger;
import java.text.ParseException;

public class XBigInteger
extends XNumber
implements Comparable {
    private static final BigInteger ZERO = BigInteger.ZERO;
    private static final BigInteger MINUSONE = new BigInteger("-1");
    private static final char zero = '0';
    private static final char one = '1';
    private static final char period = '.';
    private static final String positive = "...0";
    private static final String negative = "...1";
    public static final String standardMessage = "\nXBigInteger Error: Data format must be\na big integer in decimal format with an optional sign\nor a big integer expression with data in decimal format\nor a binary bit representation formatted as follows.\nRepresent a positive big integer in binary bits as ...0bbb\nRepresent a negative big integer in binary bits as ...1bbb\nThe prefix ...0 or ...1 is mandatory and must be typed as is\nThe sequence bbb stands for zero or more additional 0,1 digits\n";
    private BigInteger value = BigInteger.ZERO;

    public XBigInteger() {
    }

    public XBigInteger(BigInteger b) {
        this.setValue(b);
    }

    public XBigInteger(XBigInteger b) {
        this.setValue(b);
    }

    public XBigInteger(long n) {
        this.setValue(n);
    }

    public XBigInteger(String s) throws ParseException {
        this.fromStringData(s);
    }

    public XBigInteger(String s, int radix) {
        this.setValue(s, radix);
    }

    public XBigInteger(byte[] val) {
        this.setValue(val);
    }

    public final void fromStringData(String data) throws ParseException {
        if (data == null) {
            throw new ParseException("\nXBigInteger fromStringData(String) Error: Data was null\n", -1);
        }
        BigInteger oldValue = this.value;
        int length = (data = data.trim()).length();
        if (length >= 4 && data.charAt(0) == '.') {
            this.fromBits(data);
        } else {
            try {
                BaseParser p = ParserUtilities.getDefaultParser();
                Object obj = p.parse(data);
                if (obj instanceof XNumber) {
                    XBigInteger x = ParserUtilities.toXBigInteger((XNumber)obj);
                    this.value = x.getValue();
                }
            }
            catch (Exception ex) {
                throw new ParseException(standardMessage, -1);
            }
        }
        this.changeAdapter.firePropertyChange("value", oldValue, this.value);
    }

    public final String toStringData() {
        return this.toString();
    }

    public final String toString() {
        return this.getValue().toString();
    }

    public final String toString(int radix) {
        return this.getValue().toString(radix);
    }

    public String toBits() {
        String start = "";
        int compare = this.getValue().compareTo(BigInteger.ZERO);
        start = compare >= 0 ? positive : negative;
        int length = this.getValue().bitLength();
        if (length == 0) {
            return start;
        }
        StringBuffer buffer = new StringBuffer(length);
        int k = length - 1;
        int i = 0;
        while (i <= k) {
            if (this.getValue().testBit(k - i)) {
                buffer.append('1');
            } else {
                buffer.append('0');
            }
            ++i;
        }
        return String.valueOf(start) + buffer.toString();
    }

    private void fromBits(String bits) throws ParseException {
        BigInteger result;
        if (bits == null) {
            throw new ParseException("\nXBigInteger fromBits(String) Error: Data was null\n", -1);
        }
        if (bits.startsWith(positive)) {
            result = ZERO;
        } else if (bits.startsWith(negative)) {
            result = MINUSONE;
        } else {
            throw new ParseException(standardMessage, -1);
        }
        bits = bits.substring(4);
        int length = bits.length();
        if (length == 0) {
            this.value = result;
            return;
        }
        int k = length - 1;
        result = result.shiftLeft(length);
        int i = 0;
        while (i <= k) {
            if (bits.charAt(i) == '1') {
                result = result.setBit(k - i);
            } else if (bits.charAt(i) == '0') {
                result = result.clearBit(k - i);
            } else {
                throw new ParseException(standardMessage, -1);
            }
            ++i;
        }
        this.value = result;
    }

    public final int digits() {
        String string = this.toString();
        int length = string.length();
        if (string.charAt(0) == '-') {
            return length - 1;
        }
        return length;
    }

    public final int digits(int radix) {
        String string = this.toString(radix);
        int length = string.length();
        if (string.charAt(0) == '-') {
            return length - 1;
        }
        return length;
    }

    public final boolean equals(Object other) {
        if (other instanceof XBigInteger) {
            XBigInteger object = (XBigInteger)other;
            return this.getValue().equals(object.getValue());
        }
        return false;
    }

    public final int hashCode() {
        return this.getValue().hashCode();
    }

    public final void setValue(BigInteger b) {
        BigInteger oldValue = this.value;
        BigInteger bigInteger = this.value = b == null ? BigInteger.ZERO : b;
        if (!this.value.equals(oldValue)) {
            this.changeAdapter.firePropertyChange("value", oldValue, this.value);
        }
    }

    public final void setValue(XBigInteger b) {
        this.setValue(b == null ? BigInteger.ZERO : b.getValue());
    }

    public final void setValue(long n) {
        this.setValue(BigInteger.valueOf(n));
    }

    public final void setValue(String data) throws ParseException {
        if (data == null) {
            throw new ParseException("\nXBigInteger setValue(String) Error: Data was null\n", -1);
        }
        this.fromStringData(data);
    }

    public final void setValue(String s, int radix) {
        if (s == null) {
            throw new NumberFormatException("\nXBigInteger setValue(String, int) Error: Data was null\n");
        }
        this.setValue(new BigInteger(s, radix));
    }

    public final void setValue(byte[] val) {
        this.setValue(val == null || val.length == 0 ? BigInteger.ZERO : new BigInteger(val));
    }

    public final BigInteger getValue() {
        return this.value;
    }

    public final byte byteValue() {
        BigInteger max = new BigInteger("127");
        BigInteger min = new BigInteger("-128");
        if (this.getValue().compareTo(max) > 0 || this.getValue().compareTo(min) < 0) {
            throw new NumberFormatException("Number beyond precision of a byte.");
        }
        return (byte)this.getValue().intValue();
    }

    public final short shortValue() {
        BigInteger max = new BigInteger("32767");
        BigInteger min = new BigInteger("-32768");
        if (this.getValue().compareTo(max) > 0 || this.getValue().compareTo(min) < 0) {
            throw new NumberFormatException("Number beyond precision of a short.");
        }
        return (short)this.getValue().intValue();
    }

    public final int intValue() {
        BigInteger max = new BigInteger("2147483647");
        BigInteger min = new BigInteger("-2147483648");
        if (this.getValue().compareTo(max) > 0 || this.getValue().compareTo(min) < 0) {
            throw new NumberFormatException("Number beyond precision of an int.");
        }
        return this.getValue().intValue();
    }

    public final long longValue() {
        BigInteger max = new BigInteger("9223372036854775807");
        BigInteger min = new BigInteger("-9223372036854775808");
        if (this.getValue().compareTo(max) > 0 || this.getValue().compareTo(min) < 0) {
            throw new NumberFormatException("Number beyond precision of a long.");
        }
        return this.getValue().longValue();
    }

    public final float floatValue() {
        return this.getValue().floatValue();
    }

    public final double doubleValue() {
        return this.getValue().doubleValue();
    }

    public final int signum() {
        return this.getValue().signum();
    }

    public final void abs() {
        this.setValue(this.getValue().abs());
    }

    public static XBigInteger abs(XBigInteger y) {
        BigInteger yy = y == null ? BigInteger.ZERO : y.getValue();
        return new XBigInteger(yy.abs());
    }

    public final void negate() {
        this.setValue(this.getValue().negate());
    }

    public static XBigInteger negate(XBigInteger y) {
        BigInteger yy = y == null ? BigInteger.ZERO : y.getValue();
        return new XBigInteger(yy.negate());
    }

    public final void max(XBigInteger y) {
        BigInteger yy = y == null ? BigInteger.ZERO : y.getValue();
        this.setValue(this.getValue().max(yy));
    }

    public static XBigInteger max(XBigInteger x, XBigInteger y) {
        BigInteger xx = x == null ? BigInteger.ZERO : x.getValue();
        BigInteger yy = y == null ? BigInteger.ZERO : y.getValue();
        return new XBigInteger(xx.max(yy));
    }

    public final void min(XBigInteger y) {
        BigInteger yy = y == null ? BigInteger.ZERO : y.getValue();
        this.setValue(this.getValue().min(yy));
    }

    public static XBigInteger min(XBigInteger x, XBigInteger y) {
        BigInteger xx = x == null ? BigInteger.ZERO : x.getValue();
        BigInteger yy = y == null ? BigInteger.ZERO : y.getValue();
        return new XBigInteger(xx.min(yy));
    }

    public final void add(XBigInteger y) {
        BigInteger yy = y == null ? BigInteger.ZERO : y.getValue();
        this.setValue(this.getValue().add(yy));
    }

    public static XBigInteger add(XBigInteger x, XBigInteger y) {
        BigInteger xx = x == null ? BigInteger.ZERO : x.getValue();
        BigInteger yy = y == null ? BigInteger.ZERO : y.getValue();
        return new XBigInteger(xx.add(yy));
    }

    public final void subtract(XBigInteger y) {
        BigInteger yy = y == null ? BigInteger.ZERO : y.getValue();
        this.setValue(this.getValue().subtract(yy));
    }

    public static XBigInteger subtract(XBigInteger x, XBigInteger y) {
        BigInteger xx = x == null ? BigInteger.ZERO : x.getValue();
        BigInteger yy = y == null ? BigInteger.ZERO : y.getValue();
        return new XBigInteger(xx.subtract(yy));
    }

    public final void multiply(XBigInteger y) {
        BigInteger yy = y == null ? BigInteger.ZERO : y.getValue();
        this.setValue(this.getValue().multiply(yy));
    }

    public static XBigInteger multiply(XBigInteger x, XBigInteger y) {
        BigInteger xx = x == null ? BigInteger.ZERO : x.getValue();
        BigInteger yy = y == null ? BigInteger.ZERO : y.getValue();
        return new XBigInteger(xx.multiply(yy));
    }

    public final void divide(XBigInteger y) {
        BigInteger yy;
        BigInteger bigInteger = yy = y == null ? BigInteger.ZERO : y.getValue();
        if (yy.equals(BigInteger.ZERO)) {
            throw new ArithmeticException("Zero divisor in XBigInteger.divide(y)");
        }
        this.setValue(this.getValue().divide(yy));
    }

    public static XBigInteger divide(XBigInteger x, XBigInteger y) {
        BigInteger yy;
        BigInteger xx = x == null ? BigInteger.ZERO : x.getValue();
        BigInteger bigInteger = yy = y == null ? BigInteger.ZERO : y.getValue();
        if (yy.equals(BigInteger.ZERO)) {
            throw new ArithmeticException("Zero divisor in XBigInteger.divide(x,y)");
        }
        return new XBigInteger(xx.divide(yy));
    }

    public final void remainder(XBigInteger y) {
        BigInteger yy;
        BigInteger bigInteger = yy = y == null ? BigInteger.ZERO : y.getValue();
        if (yy.equals(BigInteger.ZERO)) {
            throw new ArithmeticException("Zero divisor in XBigInteger.remainder(y)");
        }
        this.setValue(this.getValue().remainder(yy));
    }

    public static XBigInteger remainder(XBigInteger x, XBigInteger y) {
        BigInteger yy;
        BigInteger xx = x == null ? BigInteger.ZERO : x.value;
        BigInteger bigInteger = yy = y == null ? BigInteger.ZERO : y.value;
        if (yy.equals(BigInteger.ZERO)) {
            throw new ArithmeticException("Zero divisor in XBigInteger.remainder(x,y)");
        }
        return new XBigInteger(xx.remainder(yy));
    }

    public static XBigInteger[] divideAndRemainder(XBigInteger x, XBigInteger y) {
        BigInteger yy;
        BigInteger xx = x == null ? BigInteger.ZERO : x.getValue();
        BigInteger bigInteger = yy = y == null ? BigInteger.ZERO : y.getValue();
        if (yy.equals(BigInteger.ZERO)) {
            throw new ArithmeticException("Zero divisor in XBigInteger.divideAndRemainder(x,y)");
        }
        BigInteger[] array = xx.divideAndRemainder(yy);
        return new XBigInteger[]{new XBigInteger(array[0]), new XBigInteger(array[1])};
    }

    public final void mod(XBigInteger y) {
        BigInteger yy;
        BigInteger bigInteger = yy = y == null ? BigInteger.ZERO : y.getValue();
        if (yy.compareTo(BigInteger.ZERO) <= 0) {
            throw new ArithmeticException("Zero or negative divisor in XBigInteger.mod(y)");
        }
        this.setValue(this.getValue().mod(yy));
    }

    public static XBigInteger mod(XBigInteger x, XBigInteger y) {
        BigInteger yy;
        BigInteger xx = x == null ? BigInteger.ZERO : x.getValue();
        BigInteger bigInteger = yy = y == null ? BigInteger.ZERO : y.getValue();
        if (yy.compareTo(BigInteger.ZERO) <= 0) {
            throw new ArithmeticException("Zero or negative divisor in XBigInteger.mod(x,y)");
        }
        return new XBigInteger(xx.mod(yy));
    }

    public final void modInverse(XBigInteger y) {
        BigInteger yy;
        BigInteger bigInteger = yy = y == null ? BigInteger.ZERO : y.getValue();
        if (yy.compareTo(BigInteger.ZERO) <= 0) {
            throw new ArithmeticException("Zero or negative divisor in XBigInteger.modInverse(y)");
        }
        try {
            this.setValue(this.getValue().modInverse(yy));
        }
        catch (Exception ex) {
            throw new ArithmeticException("Value not relatively prime in XBigInteger.modInverse(y)");
        }
    }

    public static XBigInteger modInverse(XBigInteger x, XBigInteger y) {
        BigInteger yy;
        BigInteger xx = x == null ? BigInteger.ZERO : x.getValue();
        BigInteger bigInteger = yy = y == null ? BigInteger.ZERO : y.getValue();
        if (yy.compareTo(BigInteger.ZERO) <= 0) {
            throw new ArithmeticException("Zero or negative divisor in XBigInteger.modInverse(x,y)");
        }
        try {
            return new XBigInteger(xx.modInverse(yy));
        }
        catch (Exception ex) {
            throw new ArithmeticException("Value not relatively prime in XBigInteger.modInverse(x,y)");
        }
    }

    public final void pow(int e) {
        if (e < 0) {
            throw new ArithmeticException("Negative exponent in XBigInteger.pow(e)");
        }
        this.setValue(this.getValue().pow(e));
    }

    public static XBigInteger pow(XBigInteger x, int e) {
        if (e < 0) {
            throw new ArithmeticException("Negative exponent in XBigInteger.pow(x, e)");
        }
        BigInteger xx = x == null ? BigInteger.ZERO : x.getValue();
        return new XBigInteger(xx.pow(e));
    }

    public final void modPow(XBigInteger e, XBigInteger y) {
        BigInteger yy;
        BigInteger ee = e == null ? BigInteger.ZERO : e.getValue();
        BigInteger bigInteger = yy = y == null ? BigInteger.ZERO : y.getValue();
        if (yy.compareTo(BigInteger.ZERO) <= 0) {
            throw new ArithmeticException("Zero or negative modulus in XBigInteger.modPow(e,y)");
        }
        try {
            this.setValue(this.getValue().modPow(ee, yy));
        }
        catch (Exception ex) {
            throw new ArithmeticException("Value not relatively prime in XBigInteger.modPow(e,y)");
        }
    }

    public static XBigInteger modPow(XBigInteger x, XBigInteger e, XBigInteger y) {
        BigInteger yy;
        BigInteger xx = x == null ? BigInteger.ZERO : x.getValue();
        BigInteger ee = e == null ? BigInteger.ZERO : e.getValue();
        BigInteger bigInteger = yy = y == null ? BigInteger.ZERO : y.getValue();
        if (yy.compareTo(BigInteger.ZERO) <= 0) {
            throw new ArithmeticException("Zero or negative modulus in XBigInteger.modPow(x,e,y)");
        }
        try {
            return new XBigInteger(xx.modPow(ee, yy));
        }
        catch (Exception ex) {
            throw new ArithmeticException("Value not relatively prime in XBigInteger.modPow(x,e,y)");
        }
    }

    public final void gcd(XBigInteger y) {
        BigInteger yy = y == null ? BigInteger.ZERO : y.getValue();
        this.setValue(this.getValue().gcd(yy));
    }

    public static XBigInteger gcd(XBigInteger x, XBigInteger y) {
        BigInteger xx = x == null ? BigInteger.ZERO : x.getValue();
        BigInteger yy = y == null ? BigInteger.ZERO : y.getValue();
        return new XBigInteger(xx.gcd(yy));
    }

    public final void lcm(XBigInteger y) {
        BigInteger yy = y == null ? BigInteger.ZERO : y.getValue();
        this.setValue(XBigInteger.lcm(this, y));
    }

    public static XBigInteger lcm(XBigInteger x, XBigInteger y) {
        BigInteger yy;
        BigInteger xx = x == null ? BigInteger.ZERO : x.getValue();
        BigInteger bigInteger = yy = y == null ? BigInteger.ZERO : y.getValue();
        if (xx.equals(BigInteger.ZERO)) {
            return new XBigInteger(yy.abs());
        }
        if (yy.equals(BigInteger.ZERO)) {
            return new XBigInteger(xx.abs());
        }
        xx = xx.abs();
        yy = yy.abs();
        BigInteger gg = xx.gcd(yy);
        return new XBigInteger(xx.multiply(yy.divide(gg)));
    }

    public final void shiftLeft(int n) {
        this.setValue(this.getValue().shiftLeft(n));
    }

    public static XBigInteger shiftLeft(XBigInteger x, int n) {
        BigInteger xx = x == null ? BigInteger.ZERO : x.getValue();
        return new XBigInteger(xx.shiftLeft(n));
    }

    public final void shiftRight(int n) {
        this.setValue(this.getValue().shiftRight(n));
    }

    public static XBigInteger shiftRight(XBigInteger x, int n) {
        BigInteger xx = x == null ? BigInteger.ZERO : x.getValue();
        return new XBigInteger(xx.shiftRight(n));
    }

    public final void not() {
        this.setValue(this.getValue().not());
    }

    public static XBigInteger not(XBigInteger y) {
        BigInteger yy = y == null ? BigInteger.ZERO : y.getValue();
        return new XBigInteger(yy.not());
    }

    public final void and(XBigInteger y) {
        BigInteger yy = y == null ? BigInteger.ZERO : y.getValue();
        this.setValue(this.getValue().and(yy));
    }

    public static XBigInteger and(XBigInteger x, XBigInteger y) {
        BigInteger xx = x == null ? BigInteger.ZERO : x.getValue();
        BigInteger yy = y == null ? BigInteger.ZERO : y.getValue();
        return new XBigInteger(xx.and(yy));
    }

    public final void or(XBigInteger y) {
        BigInteger yy = y == null ? BigInteger.ZERO : y.getValue();
        this.setValue(this.getValue().or(yy));
    }

    public static XBigInteger or(XBigInteger x, XBigInteger y) {
        BigInteger xx = x == null ? BigInteger.ZERO : x.getValue();
        BigInteger yy = y == null ? BigInteger.ZERO : y.getValue();
        return new XBigInteger(xx.or(yy));
    }

    public final void xor(XBigInteger y) {
        BigInteger yy = y == null ? BigInteger.ZERO : y.getValue();
        this.setValue(this.getValue().xor(yy));
    }

    public static XBigInteger xor(XBigInteger x, XBigInteger y) {
        BigInteger xx = x == null ? BigInteger.ZERO : x.getValue();
        BigInteger yy = y == null ? BigInteger.ZERO : y.getValue();
        return new XBigInteger(xx.xor(yy));
    }

    public final void andNot(XBigInteger y) {
        BigInteger yy = y == null ? BigInteger.ZERO : y.getValue();
        this.setValue(this.getValue().andNot(yy));
    }

    public static XBigInteger andNot(XBigInteger x, XBigInteger y) {
        BigInteger xx = x == null ? BigInteger.ZERO : x.getValue();
        BigInteger yy = y == null ? BigInteger.ZERO : y.getValue();
        return new XBigInteger(xx.andNot(yy));
    }

    public final boolean testBit(int n) {
        return this.getValue().testBit(n);
    }

    public final void setBit(int n) {
        this.setValue(this.getValue().setBit(n));
    }

    public static XBigInteger setBit(XBigInteger x, int n) {
        BigInteger xx = x == null ? BigInteger.ZERO : x.getValue();
        return new XBigInteger(xx.setBit(n));
    }

    public final void clearBit(int n) {
        this.setValue(this.getValue().clearBit(n));
    }

    public static XBigInteger clearBit(XBigInteger x, int n) {
        BigInteger xx = x == null ? BigInteger.ZERO : x.getValue();
        return new XBigInteger(xx.clearBit(n));
    }

    public final void flipBit(int n) {
        this.setValue(this.getValue().flipBit(n));
    }

    public static XBigInteger flipBit(XBigInteger x, int n) {
        BigInteger xx = x == null ? BigInteger.ZERO : x.getValue();
        return new XBigInteger(xx.flipBit(n));
    }

    public final int getLowestSetBit() {
        return this.getValue().getLowestSetBit();
    }

    public final int bitLength() {
        return this.getValue().bitLength();
    }

    public final int bitCount() {
        return this.getValue().bitCount();
    }

    public final boolean isProbablePrime(int certainty) {
        return this.getValue().isProbablePrime(certainty);
    }

    public final int compareTo(XBigInteger y) {
        if (y == null) {
            throw new NullPointerException("Null object passed to XBigInteger.compareTo(XBigInteger)");
        }
        return this.getValue().compareTo(y.getValue());
    }

    public final int compareTo(Object o) {
        if (o == null) {
            throw new ClassCastException("Null object passed to XBigInteger.compareTo(Object)");
        }
        if (!(o instanceof XBigInteger)) {
            throw new ClassCastException("Invalid object passed to XBigInteger.compareTo(Object)");
        }
        return this.compareTo((XBigInteger)o);
    }

    public static XBigInteger factorial(int n) {
        if (n < 0) {
            return new XBigInteger();
        }
        if (n < 2) {
            return new XBigInteger(1L);
        }
        XBigInteger result = new XBigInteger(n--);
        while (n > 1) {
            result.multiply(new XBigInteger(n--));
        }
        return result;
    }

    public static XBigInteger binomial(int n, int k) {
        if (k < 0) {
            return new XBigInteger();
        }
        if (k == 0) {
            return new XBigInteger(1L);
        }
        if (n >= 0 && n < k) {
            return new XBigInteger();
        }
        if (n >= 0 && n == k) {
            return new XBigInteger(1L);
        }
        if (n >= 0 && n < 2 * k) {
            k = n - k;
        }
        XBigInteger result = new XBigInteger(n--);
        int d = 2;
        while (k > 1) {
            result.multiply(new XBigInteger(n--));
            result.divide(new XBigInteger(d++));
            --k;
        }
        return result;
    }

    public static BigInteger[] toPrimitiveArray(XBigInteger[] x) {
        if (x == null) {
            return null;
        }
        BigInteger[] temp = new BigInteger[x.length];
        int i = 0;
        while (i < temp.length) {
            if (x[i] != null) {
                temp[i] = x[i].getValue();
            }
            ++i;
        }
        return temp;
    }

    public static XBigInteger[] toXArray(BigInteger[] a) {
        if (a == null) {
            return null;
        }
        XBigInteger[] temp = new XBigInteger[a.length];
        int i = 0;
        while (i < temp.length) {
            if (a[i] != null) {
                temp[i] = new XBigInteger(a[i]);
            }
            ++i;
        }
        return temp;
    }
}

