/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.XBigInteger;
import edu.neu.ccs.XNumber;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;

public class XBigDecimal
extends XNumber {
    private static final BigDecimal ZERO = new BigDecimal("0");
    private BigDecimal value = ZERO;
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;

    public XBigDecimal() {
    }

    public XBigDecimal(BigDecimal b) {
        this.setValue(b);
    }

    public XBigDecimal(XBigDecimal b) {
        this.setValue(b);
    }

    public XBigDecimal(String s) throws ParseException {
        this.fromStringData(s);
    }

    public XBigDecimal(XBigInteger x) {
        this.setValue(x);
    }

    public XBigDecimal(XBigInteger x, int scale) {
        this.setValue(x, scale);
    }

    public XBigDecimal(long x) {
        this.setValue(x);
    }

    public XBigDecimal(long x, int scale) {
        this.setValue(x, scale);
    }

    public XBigDecimal(double x) {
        this.setValue(x);
    }

    public void fromStringData(String data) throws ParseException {
        if (data == null) {
            throw new ParseException("\nXBigDecimal fromStringData(String) Error: Data was null\n", -1);
        }
        try {
            this.setValue(new BigDecimal(data));
        }
        catch (Exception ex) {
            String message = "\nXBigDecimal fromStringData(String) Error:\n" + ex.getMessage() + "\n";
            throw new ParseException(message, data.length());
        }
    }

    public String toStringData() {
        return this.value.toString();
    }

    public String toString() {
        return this.value.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof XBigDecimal) {
            XBigDecimal object = (XBigDecimal)other;
            return this.getValue().equals(object.getValue());
        }
        return false;
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public void setValue(BigDecimal b) {
        BigDecimal oldValue = this.value;
        BigDecimal bigDecimal = this.value = b == null ? ZERO : b;
        if (!this.value.equals(oldValue)) {
            this.changeAdapter.firePropertyChange("value", oldValue, this.value);
        }
    }

    public final void setValue(XBigDecimal b) {
        this.setValue(b == null ? ZERO : b.getValue());
    }

    public final void setValue(String data) throws ParseException {
        if (data == null) {
            throw new ParseException("\nXBigDecimal setValue(String) Error: Data was null\n", -1);
        }
        this.fromStringData(data);
    }

    public void setValue(XBigInteger x) {
        BigInteger xx = x == null ? BigInteger.ZERO : x.getValue();
        this.setValue(new BigDecimal(xx));
    }

    public void setValue(XBigInteger x, int scale) {
        BigInteger xx = x == null ? BigInteger.ZERO : x.getValue();
        this.setValue(new BigDecimal(xx, scale));
    }

    public void setValue(long x) {
        this.setValue(BigDecimal.valueOf(x));
    }

    public void setValue(long x, int scale) {
        this.setValue(BigDecimal.valueOf(x, scale));
    }

    public void setValue(double x) {
        this.setValue(new BigDecimal(x));
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public byte byteValue() {
        BigDecimal max = new BigDecimal("127");
        BigDecimal min = new BigDecimal("-128");
        if (this.getValue().compareTo(max) > 0 || this.getValue().compareTo(min) < 0) {
            throw new NumberFormatException("Number beyond precision of a byte.");
        }
        return (byte)this.getValue().intValue();
    }

    public short shortValue() {
        BigDecimal max = new BigDecimal("32767");
        BigDecimal min = new BigDecimal("-32768");
        if (this.getValue().compareTo(max) > 0 || this.getValue().compareTo(min) < 0) {
            throw new NumberFormatException("Number beyond precision of a short.");
        }
        return (short)this.getValue().intValue();
    }

    public int intValue() {
        BigDecimal max = new BigDecimal("2147483647");
        BigDecimal min = new BigDecimal("-2147483648");
        if (this.getValue().compareTo(max) > 0 || this.getValue().compareTo(min) < 0) {
            throw new NumberFormatException("Number beyond precision of an int.");
        }
        return this.getValue().intValue();
    }

    public long longValue() {
        BigDecimal max = new BigDecimal("9223372036854775807");
        BigDecimal min = new BigDecimal("-9223372036854775808");
        if (this.getValue().compareTo(max) > 0 || this.getValue().compareTo(min) < 0) {
            throw new NumberFormatException("Number beyond precision of a long.");
        }
        return this.getValue().longValue();
    }

    public float floatValue() {
        return this.getValue().floatValue();
    }

    public double doubleValue() {
        return this.getValue().doubleValue();
    }

    public final int signum() {
        return this.getValue().signum();
    }

    public final int scale() {
        return this.getValue().scale();
    }

    public final void setScale(int scale) {
        this.setValue(this.getValue().setScale(scale));
    }

    public static XBigDecimal setScale(XBigDecimal y, int scale) {
        BigDecimal yy = y == null ? ZERO : y.getValue();
        return new XBigDecimal(yy.setScale(scale));
    }

    public final void setScale(int scale, int roundingMode) {
        this.setValue(this.getValue().setScale(scale, roundingMode));
    }

    public static XBigDecimal setScale(XBigDecimal y, int scale, int roundingMode) {
        BigDecimal yy = y == null ? ZERO : y.getValue();
        return new XBigDecimal(yy.setScale(scale, roundingMode));
    }

    public final void movePointLeft(int n) {
        this.setValue(this.getValue().movePointLeft(n));
    }

    public static XBigDecimal movePointLeft(XBigDecimal y, int n) {
        BigDecimal yy = y == null ? ZERO : y.getValue();
        return new XBigDecimal(yy.movePointLeft(n));
    }

    public final void movePointRight(int n) {
        this.setValue(this.getValue().movePointRight(n));
    }

    public static XBigDecimal movePointRight(XBigDecimal y, int n) {
        BigDecimal yy = y == null ? ZERO : y.getValue();
        return new XBigDecimal(yy.movePointRight(n));
    }

    public final XBigInteger toUnscaledXBigInteger() {
        return new XBigInteger(this.getValue().unscaledValue());
    }

    public final XBigInteger toXBigInteger() {
        return new XBigInteger(this.getValue().toBigInteger());
    }

    public final void abs() {
        this.setValue(this.getValue().abs());
    }

    public static XBigDecimal abs(XBigDecimal y) {
        BigDecimal yy = y == null ? ZERO : y.getValue();
        return new XBigDecimal(yy.abs());
    }

    public final void negate() {
        this.setValue(this.getValue().negate());
    }

    public static XBigDecimal negate(XBigDecimal y) {
        BigDecimal yy = y == null ? ZERO : y.getValue();
        return new XBigDecimal(yy.negate());
    }

    public final void max(XBigDecimal y) {
        BigDecimal yy = y == null ? ZERO : y.getValue();
        this.setValue(this.getValue().max(yy));
    }

    public static XBigDecimal max(XBigDecimal x, XBigDecimal y) {
        BigDecimal xx = x == null ? ZERO : x.getValue();
        BigDecimal yy = y == null ? ZERO : y.getValue();
        return new XBigDecimal(xx.max(yy));
    }

    public final void min(XBigDecimal y) {
        BigDecimal yy = y == null ? ZERO : y.getValue();
        this.setValue(this.getValue().min(yy));
    }

    public static XBigDecimal min(XBigDecimal x, XBigDecimal y) {
        BigDecimal xx = x == null ? ZERO : x.getValue();
        BigDecimal yy = y == null ? ZERO : y.getValue();
        return new XBigDecimal(xx.min(yy));
    }

    public final void add(XBigDecimal y) {
        BigDecimal yy = y == null ? ZERO : y.getValue();
        this.setValue(this.getValue().add(yy));
    }

    public static XBigDecimal add(XBigDecimal x, XBigDecimal y) {
        BigDecimal xx = x == null ? ZERO : x.getValue();
        BigDecimal yy = y == null ? ZERO : y.getValue();
        return new XBigDecimal(xx.add(yy));
    }

    public final void subtract(XBigDecimal y) {
        BigDecimal yy = y == null ? ZERO : y.getValue();
        this.setValue(this.getValue().subtract(yy));
    }

    public static XBigDecimal subtract(XBigDecimal x, XBigDecimal y) {
        BigDecimal xx = x == null ? ZERO : x.getValue();
        BigDecimal yy = y == null ? ZERO : y.getValue();
        return new XBigDecimal(xx.subtract(yy));
    }

    public final void multiply(XBigDecimal y) {
        BigDecimal yy = y == null ? ZERO : y.getValue();
        this.setValue(this.getValue().multiply(yy));
    }

    public static XBigDecimal multiply(XBigDecimal x, XBigDecimal y) {
        BigDecimal xx = x == null ? ZERO : x.getValue();
        BigDecimal yy = y == null ? ZERO : y.getValue();
        return new XBigDecimal(xx.multiply(yy));
    }

    public final void divide(XBigDecimal y, int roundingMode) {
        BigDecimal yy;
        BigDecimal bigDecimal = yy = y == null ? ZERO : y.getValue();
        if (yy.equals(ZERO)) {
            throw new ArithmeticException("Zero divisor in XBigDecimal.divide(y, roundingMode)");
        }
        if (!XBigDecimal.isRoundingMode(roundingMode)) {
            throw new IllegalArgumentException("Invalid rounding mode in XBigDecimal.divide(y, roundingMode)");
        }
        try {
            this.setValue(this.getValue().divide(yy, roundingMode));
        }
        catch (Exception ex) {
            throw new ArithmeticException("Invalid use of ROUND_UNNECESSARY in XBigDecimal.divide(y, roundingMode)");
        }
    }

    public static XBigDecimal divide(XBigDecimal x, XBigDecimal y, int roundingMode) {
        BigDecimal yy;
        BigDecimal xx = x == null ? ZERO : x.getValue();
        BigDecimal bigDecimal = yy = y == null ? ZERO : y.getValue();
        if (yy.equals(ZERO)) {
            throw new ArithmeticException("Zero divisor in XBigDecimal.divide(x, y, roundingMode)");
        }
        if (!XBigDecimal.isRoundingMode(roundingMode)) {
            throw new IllegalArgumentException("Invalid rounding mode in XBigDecimal.divide(x, y, roundingMode)");
        }
        try {
            return new XBigDecimal(xx.divide(yy, roundingMode));
        }
        catch (Exception ex) {
            throw new ArithmeticException("Invalid use of ROUND_UNNECESSARY in XBigDecimal.divide(x, y, roundingMode)");
        }
    }

    public final void divide(XBigDecimal y, int scale, int roundingMode) {
        BigDecimal yy;
        BigDecimal bigDecimal = yy = y == null ? ZERO : y.getValue();
        if (yy.equals(ZERO)) {
            throw new ArithmeticException("Zero divisor in XBigDecimal.divide(y, scale, roundingMode)");
        }
        if (scale < 0) {
            throw new ArithmeticException("Negative scale in XBigDecimal.divide(y, scale, roundingMode)");
        }
        if (!XBigDecimal.isRoundingMode(roundingMode)) {
            throw new IllegalArgumentException("Invalid rounding mode in XBigDecimal.divide(y, scale, roundingMode)");
        }
        try {
            this.setValue(this.getValue().divide(yy, scale, roundingMode));
        }
        catch (Exception ex) {
            throw new ArithmeticException("Invalid use of ROUND_UNNECESSARY in XBigDecimal.divide(y, scale, roundingMode)");
        }
    }

    public static XBigDecimal divide(XBigDecimal x, XBigDecimal y, int scale, int roundingMode) {
        BigDecimal yy;
        BigDecimal xx = x == null ? ZERO : x.getValue();
        BigDecimal bigDecimal = yy = y == null ? ZERO : y.getValue();
        if (yy.equals(ZERO)) {
            throw new ArithmeticException("Zero divisor in XBigDecimal.divide(x, y, scale, roundingMode)");
        }
        if (scale < 0) {
            throw new ArithmeticException("Negative scale in XBigDecimal.divide(x, y, scale, roundingMode)");
        }
        if (!XBigDecimal.isRoundingMode(roundingMode)) {
            throw new IllegalArgumentException("Invalid rounding mode in XBigDecimal.divide(x, y, scale, roundingMode)");
        }
        try {
            return new XBigDecimal(xx.divide(yy, scale, roundingMode));
        }
        catch (Exception ex) {
            throw new ArithmeticException("Invalid use of ROUND_UNNECESSARY in XBigDecimal.divide(x, y, scale, roundingMode)");
        }
    }

    public static boolean isRoundingMode(int roundingMode) {
        switch (roundingMode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public final int compareTo(XBigDecimal y) {
        if (y == null) {
            throw new NullPointerException("Null object passed to XBigDecimal.compareTo(XBigDecimal)");
        }
        return this.getValue().compareTo(y.getValue());
    }

    public final int compareTo(Object o) {
        if (o == null) {
            throw new ClassCastException("Null object passed to XBigDecimal.compareTo(Object)");
        }
        if (!(o instanceof XBigDecimal)) {
            throw new ClassCastException("Invalid object passed to XBigDecimal.compareTo(Object)");
        }
        return this.compareTo((XBigDecimal)o);
    }

    public static BigDecimal[] toPrimitiveArray(XBigDecimal[] x) {
        if (x == null) {
            return null;
        }
        BigDecimal[] temp = new BigDecimal[x.length];
        int i = 0;
        while (i < temp.length) {
            if (x[i] != null) {
                temp[i] = x[i].getValue();
            }
            ++i;
        }
        return temp;
    }

    public static XBigDecimal[] toXArray(BigDecimal[] a) {
        if (a == null) {
            return null;
        }
        XBigDecimal[] temp = new XBigDecimal[a.length];
        int i = 0;
        while (i < temp.length) {
            if (a[i] != null) {
                temp[i] = new XBigDecimal(a[i]);
            }
            ++i;
        }
        return temp;
    }
}

