/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.XComplex;
import edu.neu.ccs.XDouble;
import edu.neu.ccs.XLong;
import edu.neu.ccs.codec.CodecUtilities;
import java.text.ParseException;
import java.util.StringTokenizer;

public class Strings {
    public static final char BRACKETS = '[';
    public static final char PARENS = '(';
    public static final char BRACES = '{';
    public static final char BRACKETS_END = ']';
    public static final char PARENS_END = ')';
    public static final char BRACES_END = '}';
    public static final char BRACKETS_SEP = ';';
    public static final char PARENS_SEP = ',';
    public static final char BRACES_SEP = '|';
    private static final char EQUALS = '=';

    private Strings() {
    }

    public static String encode(String[] data) {
        return Strings.encodeStringGroup('[', data);
    }

    public static String encodeWithBrackets(String[] data) {
        return Strings.encodeStringGroup('[', data);
    }

    public static String encodeWithParens(String[] data) {
        return Strings.encodeStringGroup('(', data);
    }

    public static String encodeWithBraces(String[] data) {
        return Strings.encodeStringGroup('{', data);
    }

    public static String encodeStringGroup(char start, String[] data) {
        char sep;
        char end;
        if (data == null) {
            return null;
        }
        if (start == '[') {
            end = ']';
            sep = ';';
        } else if (start == '(') {
            end = ')';
            sep = ',';
        } else if (start == '{') {
            end = '}';
            sep = '|';
        } else {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(start);
        buffer.append(Strings.exactMakeSeparatorList(data, sep, false));
        buffer.append(end);
        return buffer.toString();
    }

    public static String[] decode(String string) {
        if (string == null) {
            return null;
        }
        String[] result = null;
        try {
            result = CodecUtilities.decode(string);
        }
        catch (Throwable ex) {
            result = null;
        }
        if (result != null) {
            return result;
        }
        String[] splits = null;
        splits = Strings.splitIn2(string);
        result = Strings.decodeStringGroup(splits[1]);
        if (result != null) {
            return result;
        }
        splits = Strings.splitIn3(string);
        result = Strings.decodeStringGroup(splits[1]);
        return result;
    }

    public static String[] decodeStringGroup(String string) {
        int sep;
        if (string == null) {
            return null;
        }
        int last = (string = string.trim()).length() - 1;
        if (last < 1) {
            return null;
        }
        if (string.charAt(0) == '[' && string.charAt(last) == ']') {
            sep = 59;
        } else if (string.charAt(0) == '(' && string.charAt(last) == ')') {
            sep = 44;
        } else if (string.charAt(0) == '{' && string.charAt(last) == '}') {
            sep = 124;
        } else {
            return null;
        }
        string = string.substring(1, last);
        return Strings.exactSplitList(string, (char)sep, false);
    }

    public static boolean isStartEnd(String string, char start, char end) {
        if (string == null) {
            return false;
        }
        int last = string.length() - 1;
        if (last < 1) {
            return false;
        }
        return string.charAt(0) == start && string.charAt(last) == end;
    }

    public static String[] splitIn2(String string) {
        if (string == null) {
            return null;
        }
        String prefix = "";
        String suffix = "";
        int length = string.length();
        if (length == 0) {
            return new String[]{prefix, suffix};
        }
        int first = length;
        int index = string.indexOf(91);
        if (index >= 0 && index < first) {
            first = index;
        }
        if ((index = string.indexOf(40)) >= 0 && index < first) {
            first = index;
        }
        if ((index = string.indexOf(123)) >= 0 && index < first) {
            first = index;
        }
        if (first == 0) {
            suffix = string;
            return new String[]{prefix, suffix};
        }
        if (first == length) {
            prefix = string;
            return new String[]{prefix, suffix};
        }
        prefix = string.substring(0, first);
        suffix = string.substring(first, length);
        return new String[]{prefix, suffix};
    }

    public static String[] splitIn3(String string) {
        if (string == null) {
            return null;
        }
        String prefix = "";
        String middle = "";
        String suffix = "";
        int length = string.length();
        if (length == 0) {
            return new String[]{prefix, middle, suffix};
        }
        int first = length;
        int end = 0;
        int index = string.indexOf(91);
        if (index >= 0 && index < first) {
            first = index;
            end = 93;
        }
        if ((index = string.indexOf(40)) >= 0 && index < first) {
            first = index;
            end = 41;
        }
        if ((index = string.indexOf(123)) >= 0 && index < first) {
            first = index;
            end = 125;
        }
        if (first == length) {
            prefix = string;
            return new String[]{prefix, middle, suffix};
        }
        prefix = string.substring(0, first);
        index = string.indexOf(end, first);
        if (index == -1) {
            suffix = string.substring(first, length);
            return new String[]{prefix, middle, suffix};
        }
        middle = string.substring(first, ++index);
        suffix = string.substring(index, length);
        return new String[]{prefix, middle, suffix};
    }

    public static String makeNameValuePair(String name, String value) {
        if (name == null || value == null) {
            return null;
        }
        return String.valueOf(name) + '=' + value;
    }

    public static String getName(String string) {
        if (string == null) {
            return null;
        }
        int index = string.indexOf(61);
        if (index == -1) {
            return "";
        }
        return string.substring(0, index);
    }

    public static String getValue(String string) {
        if (string == null) {
            return null;
        }
        int index = string.indexOf(61);
        if (index == -1) {
            return string;
        }
        return string.substring(index + 1, string.length());
    }

    public static String[] makeNameValuePairs(String[] names, String[] values) {
        if (names == null || values == null) {
            return null;
        }
        int length = names.length;
        if (values.length != length) {
            return null;
        }
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = Strings.makeNameValuePair(names[i], values[i]);
            if (result[i] == null) {
                return null;
            }
            ++i;
        }
        return result;
    }

    public static String[] getNames(String[] pairs) {
        if (pairs == null) {
            return null;
        }
        int length = pairs.length;
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = Strings.getName(pairs[i]);
            if (result[i] == null) {
                return null;
            }
            ++i;
        }
        return result;
    }

    public static String[] getValues(String[] pairs) {
        if (pairs == null) {
            return null;
        }
        int length = pairs.length;
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = Strings.getValue(pairs[i]);
            if (result[i] == null) {
                return null;
            }
            ++i;
        }
        return result;
    }

    public static String[] longsToStrings(long[] data) {
        if (data == null) {
            return null;
        }
        int length = data.length;
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = Long.toString(data[i]);
            ++i;
        }
        return result;
    }

    public static String[] doublesToStrings(double[] data) {
        if (data == null) {
            return null;
        }
        int length = data.length;
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = Double.toString(data[i]);
            ++i;
        }
        return result;
    }

    public static String[] XComplexValuesToStrings(XComplex[] data) {
        if (data == null) {
            return null;
        }
        int length = data.length;
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = XComplex.toStringData(data[i]);
            ++i;
        }
        return result;
    }

    public static long[] stringsToLongs(String[] data) throws ParseException {
        if (data == null) {
            return null;
        }
        data = Strings.trim(data);
        int length = data.length;
        XLong xlong = new XLong();
        long[] result = new long[length];
        int i = 0;
        while (i < length) {
            if (data[i] == null || data[i].length() == 0) {
                result[i] = 0L;
            } else {
                try {
                    xlong.fromStringData(data[i]);
                    result[i] = xlong.getValue();
                }
                catch (ParseException ex) {
                    String message = ex.getMessage();
                    int offset = ex.getErrorOffset();
                    message = String.valueOf(i) + ": " + data[i] + "\n" + message;
                    throw new ParseException(message, offset);
                }
            }
            ++i;
        }
        return result;
    }

    public static double[] stringsToDoubles(String[] data) throws ParseException {
        if (data == null) {
            return null;
        }
        data = Strings.trim(data);
        int length = data.length;
        XDouble xdouble = new XDouble();
        double[] result = new double[length];
        int i = 0;
        while (i < length) {
            if (data[i] == null || data[i].length() == 0) {
                result[i] = 0.0;
            } else {
                try {
                    xdouble.fromStringData(data[i]);
                    result[i] = xdouble.getValue();
                }
                catch (ParseException ex) {
                    String message = ex.getMessage();
                    int offset = ex.getErrorOffset();
                    message = String.valueOf(i) + ": " + data[i] + "\n" + message;
                    throw new ParseException(message, offset);
                }
            }
            ++i;
        }
        return result;
    }

    public static XComplex[] stringsToXComplexValues(String[] data) throws ParseException {
        if (data == null) {
            return null;
        }
        data = Strings.trim(data);
        int length = data.length;
        XComplex[] result = new XComplex[length];
        int i = 0;
        while (i < length) {
            if (data[i] == null || data[i].length() == 0) {
                result[i] = new XComplex();
            } else {
                try {
                    result[i] = new XComplex(data[i]);
                }
                catch (ParseException ex) {
                    String message = ex.getMessage();
                    int offset = ex.getErrorOffset();
                    message = String.valueOf(i) + ": " + data[i] + "\n" + message;
                    throw new ParseException(message, offset);
                }
            }
            ++i;
        }
        return result;
    }

    public static int getIndexValue(String message) {
        if (message == null) {
            return 0;
        }
        int length = message.length();
        int result = 0;
        int i = 0;
        while (i < length) {
            char c = message.charAt(i);
            if (!Character.isDigit(c)) break;
            int v = Character.digit(c, 10);
            result = 10 * result + v;
            ++i;
        }
        return result;
    }

    public static String removeIndexValue(String message) {
        if (message == null) {
            return null;
        }
        int length = message.length();
        int i = 0;
        i = 0;
        while (i < length) {
            char c = message.charAt(i);
            if (!Character.isDigit(c)) break;
            ++i;
        }
        return message.substring(i);
    }

    public static ParseException makeAdjustedParseException(ParseException ex, String type, String[] names) {
        String message = ex.getMessage();
        int offset = ex.getErrorOffset();
        int index = Strings.getIndexValue(message);
        String replace = Strings.removeIndexValue(message);
        message = "\n" + type + " Error in\n" + names[index] + " field" + replace + "\nat offset " + offset + "\n";
        return new ParseException(message, -1);
    }

    public static String[] trim(String[] data) {
        if (data == null) {
            return null;
        }
        int length = data.length;
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = data[i] == null ? null : data[i].trim();
            ++i;
        }
        return result;
    }

    public static boolean isNonTrivialWhitespace(char c) {
        if (c == ' ') {
            return false;
        }
        return Character.isWhitespace(c);
    }

    public static String flatten(String data) {
        if (data == null) {
            return null;
        }
        int length = data.length();
        boolean ok = true;
        int i = 0;
        while (i < length) {
            if (Strings.isNonTrivialWhitespace(data.charAt(i))) {
                ok = false;
                break;
            }
            ++i;
        }
        if (ok) {
            return data;
        }
        StringBuffer buffer = new StringBuffer(data);
        int i2 = 0;
        while (i2 < length) {
            if (Strings.isNonTrivialWhitespace(data.charAt(i2))) {
                buffer.setCharAt(i2, ' ');
            }
            ++i2;
        }
        return buffer.toString();
    }

    public static String[] flatten(String[] data) {
        if (data == null) {
            return null;
        }
        int length = data.length;
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = data[i] == null ? null : Strings.flatten(data[i]);
            ++i;
        }
        return result;
    }

    public static String[] tokenize(String string, String delimiters, boolean trim) {
        String[] result = null;
        if (string == null) {
            return result;
        }
        if (delimiters == null || delimiters.length() == 0) {
            result = new String[]{string};
        } else {
            StringTokenizer tokenizer = new StringTokenizer(string, delimiters);
            int length = tokenizer.countTokens();
            result = new String[length];
            int i = 0;
            while (i < length) {
                result[i] = tokenizer.nextToken();
                ++i;
            }
        }
        if (trim) {
            result = Strings.trim(result);
        }
        return result;
    }

    public static String[] splitCommaList(String commalist) {
        if (commalist == null) {
            return new String[0];
        }
        if ((commalist = commalist.trim()).length() == 0) {
            return new String[0];
        }
        return Strings.tokenize(commalist, ",", true);
    }

    public static String makeSeparatorList(String[] arrayList, char separator) {
        if (arrayList == null) {
            return "";
        }
        int N = arrayList.length;
        arrayList = Strings.trim(arrayList);
        int M = 0;
        int i = 0;
        while (i < N) {
            if (arrayList[i] != null && arrayList[i].length() != 0) {
                arrayList[M] = arrayList[i];
                ++M;
            }
            ++i;
        }
        StringBuffer buffer = new StringBuffer();
        int L = M - 1;
        int i2 = 0;
        while (i2 <= L) {
            buffer.append(arrayList[i2]);
            if (i2 < L) {
                buffer.append(separator);
            }
            ++i2;
        }
        return buffer.toString();
    }

    public static String makeCommaList(String[] arrayList) {
        return Strings.makeSeparatorList(arrayList, ',');
    }

    /*
     * Unable to fully structure code
     */
    public static String[] exactSplitList(String string, char delimiter, boolean trim) {
        if (string == null) {
            return null;
        }
        L = string.length();
        N = 0;
        i = 0;
        while (i < L) {
            if (string.charAt(i) == delimiter) {
                ++N;
            }
            ++i;
        }
        result = new String[N + 1];
        M = 0;
        s = 0;
        t = 0;
        ** GOTO lbl22
        {
            ++t;
            do {
                if (string.charAt(t) != delimiter) continue block1;
                result[M] = string.substring(s, t);
                ++M;
                s = ++t;
lbl22:
                // 2 sources

            } while (M < N);
        }
        t = L;
        result[N] = string.substring(s, t);
        if (trim) {
            result = Strings.trim(result);
        }
        return result;
    }

    public static String[] exactSplitList(String string, char delimiter) {
        return Strings.exactSplitList(string, delimiter, true);
    }

    public static String[] exactSplitCommaList(String string) {
        return Strings.exactSplitList(string, ',', true);
    }

    public static String[] exactSplitNewlineList(String string) {
        return Strings.exactSplitList(string, '\n', true);
    }

    /*
     * Unable to fully structure code
     */
    public static String exactMakeSeparatorList(String[] data, char delimiter, boolean trim) {
        if (data == null) {
            return null;
        }
        if (trim) {
            data = Strings.trim(data);
        }
        buffer = new StringBuffer();
        L = data.length;
        N = 0;
        i = 0;
        while (i < L) {
            if (data[i] != null) {
                ++N;
            }
            ++i;
        }
        M = 0;
        k = 0;
        ** GOTO lbl27
        {
            ++k;
            do {
                if (data[k] == null) continue block1;
                buffer.append(data[k]);
                if (M != N - 1) {
                    buffer.append(delimiter);
                }
                ++M;
                ++k;
lbl27:
                // 2 sources

            } while (M < N);
        }
        return buffer.toString();
    }

    public static String exactMakeSeparatorList(String[] data, char delimiter) {
        return Strings.exactMakeSeparatorList(data, delimiter, true);
    }

    public static String exactMakeCommaList(String[] data) {
        return Strings.exactMakeSeparatorList(data, ',', true);
    }

    public static String exactMakeNewlineList(String[] data) {
        return Strings.exactMakeSeparatorList(data, '\n', true);
    }

    public static String pad(String s) {
        if (s == null || s.length() == 0) {
            return " ";
        }
        return s;
    }

    public static String[] pad(String[] data) {
        if (data == null) {
            return null;
        }
        int length = data.length;
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = Strings.pad(data[i]);
            ++i;
        }
        return result;
    }

    public static String prefixRepeatChar(String string, char c, int count) {
        if (string == null) {
            string = "";
        }
        if (count < 0) {
            count = 0;
        }
        StringBuffer buffer = new StringBuffer(count + string.length());
        int i = 0;
        while (i < count) {
            buffer.append(c);
            ++i;
        }
        buffer.append(string);
        return buffer.toString();
    }

    public static String suffixRepeatChar(String string, char c, int count) {
        if (string == null) {
            string = "";
        }
        if (count < 0) {
            count = 0;
        }
        StringBuffer buffer = new StringBuffer(count + string.length());
        buffer.append(string);
        int i = 0;
        while (i < count) {
            buffer.append(c);
            ++i;
        }
        return buffer.toString();
    }

    public static String padOnLeft(String s, int width) {
        int n;
        if (s == null) {
            s = "";
        }
        if ((n = s.length()) >= width) {
            return s;
        }
        return Strings.prefixRepeatChar(s, ' ', width - n);
    }

    public static String[] padOnLeft(String[] data, int width) {
        if (data == null) {
            return null;
        }
        int length = data.length;
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = Strings.padOnLeft(data[i], width);
            ++i;
        }
        return result;
    }

    public static String padOnRight(String s, int width) {
        int n;
        if (s == null) {
            s = "";
        }
        if ((n = s.length()) >= width) {
            return s;
        }
        return Strings.suffixRepeatChar(s, ' ', width - n);
    }

    public static String[] padOnRight(String[] data, int width) {
        if (data == null) {
            return null;
        }
        int length = data.length;
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = Strings.padOnRight(data[i], width);
            ++i;
        }
        return result;
    }

    public static String joinWithSpace(String s, String t) {
        if (s == null) {
            return t;
        }
        if (t == null) {
            return s;
        }
        int width = s.length() + 1 + t.length();
        StringBuffer buffer = new StringBuffer(width);
        buffer.append(s);
        buffer.append(' ');
        buffer.append(t);
        return buffer.toString();
    }

    public static String textToSafeHTML(String text) {
        return Strings.textToSafeHTML(text, 4);
    }

    public static String textToSafeHTML(String text, int tabsize) {
        if (text == null) {
            return null;
        }
        int length = text.length();
        if (length == 0) {
            return text;
        }
        StringBuffer buffer = new StringBuffer(1024);
        int position = 0;
        if (tabsize <= 0) {
            tabsize = 4;
        }
        int i = 0;
        while (i < length) {
            char c = text.charAt(i);
            if (c == '\n') {
                buffer.append(c);
                position = 0;
            } else if (c == '\t') {
                int spaces = tabsize - position % tabsize;
                int k = 0;
                while (k < spaces) {
                    buffer.append(' ');
                    ++k;
                }
                position += spaces;
            } else {
                if (c == '&') {
                    buffer.append("&amp;");
                } else if (c == '<') {
                    buffer.append("&lt;");
                } else if (c == '>') {
                    buffer.append("&gt;");
                } else if (c == '\"') {
                    buffer.append("&quot;");
                } else {
                    buffer.append(c);
                }
                ++position;
            }
            ++i;
        }
        return buffer.toString();
    }
}

