/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.Strings;
import edu.neu.ccs.XInt;

public class SmallSet
implements Comparable,
Stringable {
    public static final int MIN = 0;
    public static final int MAX = 31;
    public static final int MAXSIZE = 32;
    public static final int MASK = -1;
    private static int[] BITS = new int[32];
    private static int[] COBITS = new int[32];
    private static int[] LOBITS = new int[32];
    private static int[] HIBITS = new int[32];
    private int hash = 0;
    private int size = 0;
    private boolean bitsValid = false;
    private int[] bits = null;
    private int[] lobits = null;
    private int[] hibits = null;
    private int minimum = 0;
    private int maximum = 31;
    private int mask = -1;
    private int masksize = 32;

    static {
        SmallSet.BITS[0] = 1;
        int i = 1;
        while (i <= 31) {
            SmallSet.BITS[i] = BITS[i - 1] << 1;
            ++i;
        }
        i = 0;
        while (i <= 31) {
            SmallSet.COBITS[i] = -1 - BITS[i];
            ++i;
        }
        SmallSet.LOBITS[0] = BITS[0];
        i = 1;
        while (i <= 31) {
            SmallSet.LOBITS[i] = LOBITS[i - 1] | BITS[i];
            ++i;
        }
        SmallSet.HIBITS[31] = BITS[31];
        i = 30;
        while (i >= 0) {
            SmallSet.HIBITS[i] = HIBITS[i + 1] | BITS[i];
            --i;
        }
    }

    public SmallSet() {
    }

    public SmallSet(String data) {
        this.fromStringData(data);
    }

    public SmallSet(int minimum, int maximum) {
        int n = minimum <= 0 ? 0 : (minimum = minimum >= 31 ? 31 : minimum);
        int n2 = maximum <= 0 ? 0 : (maximum = maximum >= 31 ? 31 : maximum);
        if (maximum < minimum) {
            int t = minimum;
            minimum = maximum;
            maximum = t;
        }
        this.minimum = minimum;
        this.maximum = maximum;
        this.mask = HIBITS[minimum] & LOBITS[maximum];
        this.masksize = maximum - minimum + 1;
    }

    public SmallSet(int minimum, int maximum, String data) {
        this(minimum, maximum);
        this.fromStringData(data);
    }

    public SmallSet(SmallSet set) {
        if (set == null) {
            return;
        }
        this.size = set.size;
        this.hash = set.hash;
        this.minimum = set.minimum;
        this.maximum = set.maximum;
        this.mask = set.mask;
        this.masksize = set.masksize;
    }

    public final int size() {
        return this.size;
    }

    public final int getMinimum() {
        return this.minimum;
    }

    public final int getMaximum() {
        return this.maximum;
    }

    public final boolean isEmpty() {
        return this.hash == 0;
    }

    public final boolean isFull() {
        return this.hash == this.mask;
    }

    public final void makeEmpty() {
        this.setState(0);
    }

    public final void makeFull() {
        this.setState(this.mask);
    }

    public final boolean setState(int state) {
        int oldhash = this.hash;
        this.hash = state & this.mask;
        if (this.hash == oldhash) {
            return false;
        }
        this.resetCount();
        this.bitsValid = false;
        return true;
    }

    public final int getState() {
        return this.hash;
    }

    public final boolean hasElement(int element) {
        if (element < this.minimum || element > this.maximum) {
            return false;
        }
        return (this.hash & BITS[element]) != 0;
    }

    public final boolean addElement(int element) {
        boolean hasElement;
        if (element < this.minimum || element > this.maximum) {
            return false;
        }
        boolean bl = hasElement = (this.hash & BITS[element]) != 0;
        if (hasElement) {
            return false;
        }
        this.hash |= BITS[element];
        ++this.size;
        this.bitsValid = false;
        return true;
    }

    public final boolean pruneElement(int element) {
        boolean hasElement;
        if (element < this.minimum || element > this.maximum) {
            return false;
        }
        boolean bl = hasElement = (this.hash & BITS[element]) != 0;
        if (!hasElement) {
            return false;
        }
        this.hash &= COBITS[element];
        --this.size;
        this.bitsValid = false;
        return true;
    }

    public final boolean toggleElement(int element) {
        boolean hasElement;
        if (element < this.minimum || element > this.maximum) {
            return false;
        }
        boolean bl = hasElement = (this.hash & BITS[element]) != 0;
        if (hasElement) {
            this.hash &= COBITS[element];
            --this.size;
        } else {
            this.hash |= BITS[element];
            ++this.size;
        }
        this.bitsValid = false;
        return true;
    }

    public final boolean setToElement(int element) {
        if (element < this.minimum || element > this.maximum) {
            return false;
        }
        int oldhash = this.hash;
        this.hash = BITS[element];
        if (this.hash == oldhash) {
            return false;
        }
        this.size = 1;
        this.bitsValid = false;
        return true;
    }

    public final boolean addElements(int[] elements) {
        if (elements == null) {
            return false;
        }
        int oldhash = this.hash;
        int length = elements.length;
        int i = 0;
        while (i < length) {
            int element = elements[i];
            if (element >= this.minimum && element <= this.maximum) {
                this.hash |= BITS[element];
            }
            ++i;
        }
        if (this.hash == oldhash) {
            return false;
        }
        this.resetCount();
        this.bitsValid = false;
        return true;
    }

    public final boolean pruneElements(int[] elements) {
        if (elements == null) {
            return false;
        }
        int oldhash = this.hash;
        int length = elements.length;
        int i = 0;
        while (i < length) {
            int element = elements[i];
            if (element >= this.minimum && element <= this.maximum) {
                this.hash &= COBITS[element];
            }
            ++i;
        }
        if (this.hash == oldhash) {
            return false;
        }
        this.resetCount();
        this.bitsValid = false;
        return true;
    }

    public final boolean setToElements(int[] elements) {
        if (elements == null) {
            return false;
        }
        int oldhash = this.hash;
        this.hash = 0;
        int length = elements.length;
        int i = 0;
        while (i < length) {
            int element = elements[i];
            if (element >= this.minimum && element <= this.maximum) {
                this.hash |= BITS[element];
            }
            ++i;
        }
        if (this.hash == oldhash) {
            return false;
        }
        this.resetCount();
        this.bitsValid = false;
        return true;
    }

    public final boolean addRange(int min, int max) {
        int oldhash = this.hash;
        int n = min <= this.minimum ? this.minimum : (min = min >= this.maximum ? this.maximum : min);
        int n2 = max <= this.minimum ? this.minimum : (max = max >= this.maximum ? this.maximum : max);
        if (max < min) {
            int t = min;
            min = max;
            max = t;
        }
        this.hash |= HIBITS[min] & LOBITS[max];
        if (this.hash == oldhash) {
            return false;
        }
        this.resetCount();
        this.bitsValid = false;
        return true;
    }

    public final boolean pruneRange(int min, int max) {
        int oldhash = this.hash;
        int n = min <= this.minimum ? this.minimum : (min = min >= this.maximum ? this.maximum : min);
        int n2 = max <= this.minimum ? this.minimum : (max = max >= this.maximum ? this.maximum : max);
        if (max < min) {
            int tem = min;
            min = max;
            max = tem;
        }
        this.hash &= this.mask - (HIBITS[min] & LOBITS[max]);
        if (this.hash == oldhash) {
            return false;
        }
        this.resetCount();
        this.bitsValid = false;
        return true;
    }

    public final boolean setToRange(int min, int max) {
        int oldhash = this.hash;
        int n = min <= this.minimum ? this.minimum : (min = min >= this.maximum ? this.maximum : min);
        int n2 = max <= this.minimum ? this.minimum : (max = max >= this.maximum ? this.maximum : max);
        if (max < min) {
            int tem = min;
            min = max;
            max = tem;
        }
        this.hash = HIBITS[min] & LOBITS[max];
        if (this.hash == oldhash) {
            return false;
        }
        this.size = max - min + 1;
        this.bitsValid = false;
        return true;
    }

    public final boolean unionSet(SmallSet set) {
        if (set == null) {
            return false;
        }
        int state = this.hash | set.hash;
        return this.setState(state);
    }

    public final boolean intersectSet(SmallSet set) {
        if (set == null) {
            return false;
        }
        int state = this.hash & set.hash;
        return this.setState(state);
    }

    public final boolean pruneSet(SmallSet set) {
        if (set == null) {
            return false;
        }
        int state = this.hash - (this.hash & set.hash);
        return this.setState(state);
    }

    public final void complement() {
        this.hash = this.mask - this.hash;
        this.size = this.masksize - this.size;
        this.bitsValid = false;
    }

    public final boolean contains(SmallSet set) {
        if (set == null) {
            return false;
        }
        return set.hash == (this.hash & set.hash);
    }

    public final boolean isSubset(SmallSet set) {
        if (set == null) {
            return false;
        }
        return this.hash == (this.hash & set.hash);
    }

    public final int hashCode() {
        return this.hash;
    }

    public final boolean equals(Object object) {
        if (object instanceof SmallSet) {
            SmallSet set = (SmallSet)object;
            return this.hash == set.hash;
        }
        return false;
    }

    public final int compareTo(Object object) {
        String message = "";
        if (object instanceof SmallSet) {
            SmallSet set = (SmallSet)object;
            int delta_hash = this.hash - set.hash;
            if (delta_hash == 0) {
                return 0;
            }
            int delta_size = this.size - set.size;
            if (delta_size < 0) {
                return -1;
            }
            if (delta_size > 0) {
                return 1;
            }
            if (this.hash >= 0 && set.hash < 0) {
                return -1;
            }
            if (this.hash < 0 && set.hash >= 0) {
                return 1;
            }
            if (delta_hash < 0) {
                return -1;
            }
            return 1;
        }
        message = object == null ? "Null argument to compareTo in class SmallSet" : "Illegal argument to compareTo in class SmallSet: " + object.getClass().getName();
        throw new ClassCastException(message);
    }

    public final boolean makeNextSubset(SmallSet subset) {
        if (subset == null) {
            return false;
        }
        if (subset.hash == this.hash) {
            return false;
        }
        if (subset.hash != (this.hash & subset.hash)) {
            return false;
        }
        if (subset.minimum != this.minimum) {
            return false;
        }
        if (subset.maximum != this.maximum) {
            return false;
        }
        this.fillBits();
        subset.bitsValid = false;
        if (subset.hash == 0) {
            subset.hash = this.bits[0];
            subset.size = 1;
            return true;
        }
        int z = subset.size;
        int a = 0;
        while ((subset.hash & this.bits[a]) == 0) {
            ++a;
        }
        if (a + z >= this.size) {
            subset.hash = this.lobits[z];
            subset.size = z + 1;
            return true;
        }
        int b = a;
        while ((subset.hash & this.bits[b]) != 0) {
            ++b;
        }
        subset.hash &= this.hibits[b];
        subset.hash |= this.bits[b];
        int c = b - a - 2;
        if (c >= 0) {
            subset.hash |= this.lobits[c];
        }
        return true;
    }

    protected final void resetCount() {
        this.size = 0;
        int i = this.minimum;
        while (i <= this.maximum) {
            if ((this.hash & BITS[i]) != 0) {
                ++this.size;
            }
            ++i;
        }
    }

    protected final void fillBits() {
        if (this.bitsValid) {
            return;
        }
        this.bitsValid = true;
        if (this.bits == null) {
            this.bits = new int[this.masksize];
        }
        if (this.lobits == null) {
            this.lobits = new int[this.masksize];
        }
        if (this.hibits == null) {
            this.hibits = new int[this.masksize];
        }
        if (this.size == 0) {
            return;
        }
        int k = 0;
        int i = this.minimum;
        while (i <= this.maximum) {
            if ((this.hash & BITS[i]) != 0) {
                this.bits[k] = BITS[i];
                ++k;
            }
            ++i;
        }
        this.lobits[0] = this.bits[0];
        i = 1;
        while (i < this.size) {
            this.lobits[i] = this.lobits[i - 1] | this.bits[i];
            ++i;
        }
        k = this.size - 1;
        this.hibits[k] = this.bits[k];
        i = k - 1;
        while (i >= 0) {
            this.hibits[i] = this.hibits[i + 1] | this.bits[i];
            --i;
        }
    }

    public final int[] toArray() {
        int[] result = new int[this.size];
        if (this.size == 0) {
            return result;
        }
        int k = 0;
        int i = this.minimum;
        while (i <= this.maximum) {
            if ((this.hash & BITS[i]) != 0) {
                result[k] = i;
                ++k;
            }
            ++i;
        }
        return result;
    }

    public final String toString() {
        if (this.size == 0) {
            return "{ }";
        }
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("{ ");
        int element = this.minimum;
        while (element <= this.maximum) {
            if ((this.hash & BITS[element]) != 0) {
                buffer.append(element);
                buffer.append(" ");
            }
            ++element;
        }
        buffer.append("}");
        return buffer.toString();
    }

    public final String toStringData() {
        return this.toString();
    }

    public final void fromStringData(String data) {
        int oldhash = this.hash;
        this.hash = 0;
        data = data.trim();
        String[] list = Strings.tokenize(data, ", ", true);
        int length = list.length;
        int i = 0;
        while (i < length) {
            String s = list[i];
            int hyphen = s.indexOf(45);
            if (hyphen >= 0) {
                try {
                    String t = s.substring(0, hyphen);
                    String u = s.substring(hyphen + 1, s.length());
                    XInt x = new XInt(t);
                    int a = x.getValue();
                    XInt y = new XInt(u);
                    int b = y.getValue();
                    this.addRange(a, b);
                }
                catch (Throwable t) {}
            } else {
                try {
                    XInt x = new XInt(s);
                    int a = x.getValue();
                    this.addElement(a);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (oldhash != this.hash) {
            this.resetCount();
            this.bitsValid = false;
        }
    }

    public static int getBitMask(int i) {
        if (i < 0 || i > 31) {
            return 0;
        }
        return BITS[i];
    }

    public static int getCoBitMask(int i) {
        if (i < 0 || i > 31) {
            return 0;
        }
        return COBITS[i];
    }

    public static int getLoBitMask(int i) {
        if (i < 0 || i > 31) {
            return 0;
        }
        return LOBITS[i];
    }

    public static int getHiBitMask(int i) {
        if (i < 0 || i > 31) {
            return 0;
        }
        return HIBITS[i];
    }
}

