/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.FunctionComplex;
import edu.neu.ccs.XComplex;

public class FC {
    public static final FunctionComplex.OneArg identity = new FunctionComplex.OneArg(){

        public XComplex evaluate(XComplex x) {
            return x;
        }
    };
    public static final FunctionComplex.OneArg exp = new FunctionComplex.OneArg(){

        public XComplex evaluate(XComplex x) {
            return XComplex.exp(x);
        }
    };
    public static final FunctionComplex.OneArg log = new FunctionComplex.OneArg(){

        public XComplex evaluate(XComplex x) {
            return XComplex.log(x);
        }
    };
    public static final FunctionComplex.OneArg sqrt = new FunctionComplex.OneArg(){

        public XComplex evaluate(XComplex x) {
            return XComplex.sqrt(x);
        }
    };

    private FC() {
    }

    public static FunctionComplex.OneArg constant(XComplex c) {
        final XComplex cc = new XComplex(c);
        return new FunctionComplex.OneArg(){

            public XComplex evaluate(XComplex x) {
                return cc;
            }
        };
    }

    public static FunctionComplex.OneArg scale(XComplex a) {
        final XComplex aa = new XComplex(a);
        return new FunctionComplex.OneArg(){

            public XComplex evaluate(XComplex x) {
                return XComplex.multiply(aa, x);
            }
        };
    }

    public static FunctionComplex.OneArg translate(XComplex b) {
        final XComplex bb = new XComplex(b);
        return new FunctionComplex.OneArg(){

            public XComplex evaluate(XComplex x) {
                return XComplex.add(x, bb);
            }
        };
    }

    public static FunctionComplex.OneArg linear(XComplex a, XComplex b) {
        final XComplex aa = new XComplex(a);
        final XComplex bb = new XComplex(b);
        return new FunctionComplex.OneArg(){

            public XComplex evaluate(XComplex x) {
                return XComplex.add(XComplex.multiply(aa, x), bb);
            }
        };
    }

    public static FunctionComplex.OneArg xToPowerN(final int n) {
        return new FunctionComplex.OneArg(){

            public XComplex evaluate(XComplex x) {
                return XComplex.power(x, n);
            }
        };
    }

    public static FunctionComplex.OneArg xToPowerA(XComplex a) {
        final XComplex aa = new XComplex(a);
        return new FunctionComplex.OneArg(){

            public XComplex evaluate(XComplex x) {
                return XComplex.generalPower(x, aa);
            }
        };
    }

    public static FunctionComplex.OneArg aToPowerX(XComplex a) {
        final XComplex aa = new XComplex(a);
        return new FunctionComplex.OneArg(){

            public XComplex evaluate(XComplex x) {
                return XComplex.generalPower(aa, x);
            }
        };
    }

    public static FunctionComplex.OneArg add(final FunctionComplex.OneArg f, final FunctionComplex.OneArg g) {
        FC.checkNull("add", f, g);
        return new FunctionComplex.OneArg(){

            public XComplex evaluate(XComplex x) {
                return XComplex.add(f.evaluate(x), g.evaluate(x));
            }
        };
    }

    public static FunctionComplex.OneArg subtract(final FunctionComplex.OneArg f, final FunctionComplex.OneArg g) {
        FC.checkNull("subtract", f, g);
        return new FunctionComplex.OneArg(){

            public XComplex evaluate(XComplex x) {
                return XComplex.subtract(f.evaluate(x), g.evaluate(x));
            }
        };
    }

    public static FunctionComplex.OneArg multiply(final FunctionComplex.OneArg f, final FunctionComplex.OneArg g) {
        FC.checkNull("multiply", f, g);
        return new FunctionComplex.OneArg(){

            public XComplex evaluate(XComplex x) {
                return XComplex.multiply(f.evaluate(x), g.evaluate(x));
            }
        };
    }

    public static FunctionComplex.OneArg divide(final FunctionComplex.OneArg f, final FunctionComplex.OneArg g) {
        FC.checkNull("divide", f, g);
        return new FunctionComplex.OneArg(){

            public XComplex evaluate(XComplex x) {
                return XComplex.divide(f.evaluate(x), g.evaluate(x));
            }
        };
    }

    public static FunctionComplex.OneArg compose(final FunctionComplex.OneArg f, final FunctionComplex.OneArg g) {
        FC.checkNull("compose", f, g);
        return new FunctionComplex.OneArg(){

            public XComplex evaluate(XComplex x) {
                return f.evaluate(g.evaluate(x));
            }
        };
    }

    public static FunctionComplex.OneArg power(final FunctionComplex.OneArg f, final int n) {
        FC.checkNull("power", f);
        return new FunctionComplex.OneArg(){

            public XComplex evaluate(XComplex x) {
                return XComplex.power(f.evaluate(x), n);
            }
        };
    }

    public static FunctionComplex.OneArg generalPower(final FunctionComplex.OneArg f, final double d) {
        FC.checkNull("generalPower", f);
        return new FunctionComplex.OneArg(){

            public XComplex evaluate(XComplex x) {
                return XComplex.generalPower(f.evaluate(x), d);
            }
        };
    }

    public static FunctionComplex.OneArg generalPower(final FunctionComplex.OneArg f, XComplex z) {
        FC.checkNull("generalPower", f);
        final XComplex zz = new XComplex(z);
        return new FunctionComplex.OneArg(){

            public XComplex evaluate(XComplex x) {
                return XComplex.generalPower(f.evaluate(x), zz);
            }
        };
    }

    public static FunctionComplex.OneArg generalPower(XComplex z, final FunctionComplex.OneArg f) {
        FC.checkNull("generalPower", f);
        final XComplex zz = new XComplex(z);
        return new FunctionComplex.OneArg(){

            public XComplex evaluate(XComplex x) {
                return XComplex.generalPower(zz, f.evaluate(x));
            }
        };
    }

    public static FunctionComplex.OneArg generalPower(final FunctionComplex.OneArg f, final FunctionComplex.OneArg g) {
        FC.checkNull("generalPower", f, g);
        return new FunctionComplex.OneArg(){

            public XComplex evaluate(XComplex x) {
                return XComplex.generalPower(f.evaluate(x), g.evaluate(x));
            }
        };
    }

    private static void checkNull(String method, FunctionComplex.OneArg f) {
        if (f == null) {
            throw new NullPointerException("Null function f in FC." + method);
        }
    }

    private static void checkNull(String method, FunctionComplex.OneArg f, FunctionComplex.OneArg g) {
        if (f == null) {
            throw new NullPointerException("Null function f in FC." + method);
        }
        if (g == null) {
            throw new NullPointerException("Null function g in FC." + method);
        }
    }
}

