/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.Function;
import edu.neu.ccs.util.MathUtilities;

public class F {
    private static final double logOf2 = Math.log(2.0);
    private static final double logOf10 = Math.log(10.0);
    public static final Function.OneArg identity = new Function.OneArg(){

        public double evaluate(double x) {
            return x;
        }
    };
    public static final Function.OneArg abs = new Function.OneArg(){

        public double evaluate(double x) {
            return Math.abs(x);
        }
    };
    public static final Function.OneArg ceil = new Function.OneArg(){

        public double evaluate(double x) {
            return Math.ceil(x);
        }
    };
    public static final Function.OneArg floor = new Function.OneArg(){

        public double evaluate(double x) {
            return Math.floor(x);
        }
    };
    public static final Function.OneArg rint = new Function.OneArg(){

        public double evaluate(double x) {
            return Math.rint(x);
        }
    };
    public static final Function.OneArg sin = new Function.OneArg(){

        public double evaluate(double x) {
            return Math.sin(x);
        }
    };
    public static final Function.OneArg cos = new Function.OneArg(){

        public double evaluate(double x) {
            return Math.cos(x);
        }
    };
    public static final Function.OneArg tan = new Function.OneArg(){

        public double evaluate(double x) {
            return Math.tan(x);
        }
    };
    public static final Function.OneArg asin = new Function.OneArg(){

        public double evaluate(double x) {
            return Math.asin(x);
        }
    };
    public static final Function.OneArg acos = new Function.OneArg(){

        public double evaluate(double x) {
            return Math.acos(x);
        }
    };
    public static final Function.OneArg atan = new Function.OneArg(){

        public double evaluate(double x) {
            return Math.atan(x);
        }
    };
    public static final Function.OneArg sindeg = new Function.OneArg(){

        public double evaluate(double x) {
            return MathUtilities.sindeg(x);
        }
    };
    public static final Function.OneArg cosdeg = new Function.OneArg(){

        public double evaluate(double x) {
            return MathUtilities.cosdeg(x);
        }
    };
    public static final Function.OneArg tandeg = new Function.OneArg(){

        public double evaluate(double x) {
            return MathUtilities.tandeg(x);
        }
    };
    public static final Function.OneArg asindeg = new Function.OneArg(){

        public double evaluate(double x) {
            return MathUtilities.asindeg(x);
        }
    };
    public static final Function.OneArg acosdeg = new Function.OneArg(){

        public double evaluate(double x) {
            return MathUtilities.acosdeg(x);
        }
    };
    public static final Function.OneArg atandeg = new Function.OneArg(){

        public double evaluate(double x) {
            return MathUtilities.atandeg(x);
        }
    };
    public static final Function.OneArg toDegrees = new Function.OneArg(){

        public double evaluate(double x) {
            return Math.toDegrees(x);
        }
    };
    public static final Function.OneArg toRadians = new Function.OneArg(){

        public double evaluate(double x) {
            return Math.toRadians(x);
        }
    };
    public static final Function.OneArg exp = new Function.OneArg(){

        public double evaluate(double x) {
            return Math.exp(x);
        }
    };
    public static final Function.OneArg log = new Function.OneArg(){

        public double evaluate(double x) {
            return Math.log(x);
        }
    };
    public static final Function.OneArg exp2 = new Function.OneArg(){

        public double evaluate(double x) {
            return Math.exp(x * logOf2);
        }
    };
    public static final Function.OneArg log2 = new Function.OneArg(){

        public double evaluate(double x) {
            return Math.log(x) / logOf2;
        }
    };
    public static final Function.OneArg exp10 = new Function.OneArg(){

        public double evaluate(double x) {
            return Math.exp(x * logOf10);
        }
    };
    public static final Function.OneArg log10 = new Function.OneArg(){

        public double evaluate(double x) {
            return Math.log(x) / logOf10;
        }
    };
    public static final Function.OneArg sqrt = new Function.OneArg(){

        public double evaluate(double x) {
            return Math.sqrt(x);
        }
    };
    public static final Function.OneArg random = new Function.OneArg(){

        public double evaluate(double x) {
            return Math.random() * x;
        }
    };

    private F() {
    }

    public static Function.OneArg constant(final double c) {
        return new Function.OneArg(){

            public double evaluate(double x) {
                return c;
            }
        };
    }

    public static Function.OneArg scale(final double a) {
        return new Function.OneArg(){

            public double evaluate(double x) {
                return a * x;
            }
        };
    }

    public static Function.OneArg translate(final double b) {
        return new Function.OneArg(){

            public double evaluate(double x) {
                return x + b;
            }
        };
    }

    public static Function.OneArg linear(final double a, final double b) {
        return new Function.OneArg(){

            public double evaluate(double x) {
                return a * x + b;
            }
        };
    }

    public static Function.OneArg xToPowerN(final int n) {
        return new Function.OneArg(){

            public double evaluate(double x) {
                return MathUtilities.power(x, n);
            }
        };
    }

    public static Function.OneArg xToPowerA(final double a) {
        return new Function.OneArg(){

            public double evaluate(double x) {
                return Math.pow(x, a);
            }
        };
    }

    public static Function.OneArg aToPowerX(final double a) {
        return new Function.OneArg(){

            public double evaluate(double x) {
                return Math.pow(a, x);
            }
        };
    }

    public static Function.OneArg add(final Function.OneArg f, final Function.OneArg g) {
        F.checkNull("add", f, g);
        return new Function.OneArg(){

            public double evaluate(double x) {
                return f.evaluate(x) + g.evaluate(x);
            }
        };
    }

    public static Function.OneArg subtract(final Function.OneArg f, final Function.OneArg g) {
        F.checkNull("subtract", f, g);
        return new Function.OneArg(){

            public double evaluate(double x) {
                return f.evaluate(x) - g.evaluate(x);
            }
        };
    }

    public static Function.OneArg multiply(final Function.OneArg f, final Function.OneArg g) {
        F.checkNull("multiply", f, g);
        return new Function.OneArg(){

            public double evaluate(double x) {
                return f.evaluate(x) * g.evaluate(x);
            }
        };
    }

    public static Function.OneArg divide(final Function.OneArg f, final Function.OneArg g) {
        F.checkNull("divide", f, g);
        return new Function.OneArg(){

            public double evaluate(double x) {
                return f.evaluate(x) / g.evaluate(x);
            }
        };
    }

    public static Function.OneArg compose(final Function.OneArg f, final Function.OneArg g) {
        F.checkNull("compose", f, g);
        return new Function.OneArg(){

            public double evaluate(double x) {
                return f.evaluate(g.evaluate(x));
            }
        };
    }

    public static Function.OneArg min(final Function.OneArg f, final Function.OneArg g) {
        F.checkNull("min", f, g);
        return new Function.OneArg(){

            public double evaluate(double x) {
                return Math.min(f.evaluate(x), g.evaluate(x));
            }
        };
    }

    public static Function.OneArg max(final Function.OneArg f, final Function.OneArg g) {
        F.checkNull("max", f, g);
        return new Function.OneArg(){

            public double evaluate(double x) {
                return Math.max(f.evaluate(x), g.evaluate(x));
            }
        };
    }

    public static Function.OneArg power(final Function.OneArg f, final int n) {
        F.checkNull("power", f);
        return new Function.OneArg(){

            public double evaluate(double x) {
                return MathUtilities.power(f.evaluate(x), n);
            }
        };
    }

    public static Function.OneArg pow(final Function.OneArg f, final double a) {
        F.checkNull("pow", f);
        return new Function.OneArg(){

            public double evaluate(double x) {
                return Math.pow(f.evaluate(x), a);
            }
        };
    }

    public static Function.OneArg pow(final double a, final Function.OneArg f) {
        F.checkNull("pow", f);
        return new Function.OneArg(){

            public double evaluate(double x) {
                return Math.pow(a, f.evaluate(x));
            }
        };
    }

    public static Function.OneArg pow(final Function.OneArg f, final Function.OneArg g) {
        F.checkNull("pow", f, g);
        return new Function.OneArg(){

            public double evaluate(double x) {
                return Math.pow(f.evaluate(x), g.evaluate(x));
            }
        };
    }

    public static Function.OneArg atan2(final Function.OneArg f, final Function.OneArg g) {
        F.checkNull("atan2", f, g);
        return new Function.OneArg(){

            public double evaluate(double x) {
                return Math.atan2(f.evaluate(x), g.evaluate(x));
            }
        };
    }

    public static Function.OneArg atan2deg(final Function.OneArg f, final Function.OneArg g) {
        F.checkNull("atan2deg", f, g);
        return new Function.OneArg(){

            public double evaluate(double x) {
                return MathUtilities.atan2deg(f.evaluate(x), g.evaluate(x));
            }
        };
    }

    private static void checkNull(String method, Function.OneArg f) {
        if (f == null) {
            throw new NullPointerException("Null function f in F." + method);
        }
    }

    private static void checkNull(String method, Function.OneArg f, Function.OneArg g) {
        if (f == null) {
            throw new NullPointerException("Null function f in F." + method);
        }
        if (g == null) {
            throw new NullPointerException("Null function g in F." + method);
        }
    }
}

