/*
 * Decompiled with CFR 0.152.
 */
package sorting;

import edu.neu.ccs.console.ConsoleAware;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import sorting.Algorithms;
import sorting.ByLongitude;
import sorting.ByName;
import sorting.ByZipCode;
import sorting.City;
import sorting.GUITimerInput;
import sorting.ILo;
import sorting.SortAlgorithm;
import sorting.SortingBST;
import sorting.SortingIns;
import sorting.SortingInsList;
import sorting.SortingQuicksort;
import sorting.SortingQuicksortList;
import sorting.SortingSelection;
import student.Heapsort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TimerTests
implements ConsoleAware {
    Algorithms base = new Algorithms();
    SortAlgorithm<City> bst = new SortingBST<City>();
    SortAlgorithm<City> insertlist = new SortingInsList<City>();
    SortAlgorithm<City> selectarray = new SortingSelection<City>();
    SortAlgorithm<City> quicklist = new SortingQuicksortList<City>();
    SortAlgorithm<City> insertarray = new SortingIns<City>();
    SortAlgorithm<City> quickarray = new SortingQuicksort<City>();
    SortAlgorithm<City> heapsort = new Heapsort();
    ArrayList<SortAlgorithm<City>> sortAlgosAll = new ArrayList();
    ArrayList<SortAlgorithm<City>> sortAlgos = new ArrayList();
    ArrayList<Integer> sortAlgosIndex = new ArrayList();
    Comparator<City> byName = new ByName();
    Comparator<City> byZip = new ByZipCode();
    Comparator<City> byLongitude = new ByLongitude();
    ArrayList<Comparator<City>> comparatorsAll = new ArrayList();
    ArrayList<Comparator<City>> comparators = new ArrayList();
    ArrayList<Integer> comparatorsIndex = new ArrayList();
    ArrayList<Integer> sizesAll = new ArrayList();
    ArrayList<Integer> dataSizes = new ArrayList();
    ArrayList<Integer> datasizesIndex = new ArrayList();
    ArrayList<City> alldata;
    ArrayList<City> randomdata;
    ILo<City> alldataList;
    long startTime;
    long endTime;

    void initAlgos() {
        this.sortAlgosAll.add(this.bst);
        this.sortAlgosAll.add(this.insertlist);
        this.sortAlgosAll.add(this.selectarray);
        this.sortAlgosAll.add(this.quicklist);
        this.sortAlgosAll.add(this.insertarray);
        this.sortAlgosAll.add(this.quickarray);
        this.sortAlgosAll.add(this.heapsort);
    }

    void initComparators() {
        this.comparatorsAll.add(this.byName);
        this.comparatorsAll.add(this.byZip);
        this.comparatorsAll.add(this.byLongitude);
    }

    void initSizes() {
        this.sizesAll.add(2000);
        this.sizesAll.add(4000);
        this.sizesAll.add(8000);
        this.sizesAll.add(16000);
        this.sizesAll.add(29000);
    }

    TimerTests() {
        this.base = new Algorithms();
        this.base.initCities(30000);
        this.alldata = this.base.cities;
        this.randomdata = this.base.randomData();
        this.alldataList = this.base.citylist;
    }

    public void initAll() {
        this.initAlgos();
        this.initComparators();
        this.initSizes();
        GUITimerInput choices = new GUITimerInput();
        boolean[][] timerParams = choices.demandTimerInputs();
        this.initAlgos(timerParams[0]);
        this.initComparators(timerParams[1]);
        this.initSizes(timerParams[2]);
    }

    public void initAlgos(boolean[] picks) {
        this.sortAlgos.clear();
        this.sortAlgosIndex.clear();
        int i = 0;
        while (i < 7) {
            if (picks[i]) {
                this.sortAlgos.add(this.sortAlgosAll.get(i));
                this.sortAlgosIndex.add(i);
            }
            ++i;
        }
    }

    public void initComparators(boolean[] picks) {
        this.comparators.clear();
        this.comparatorsIndex.clear();
        int i = 0;
        while (i < 3) {
            if (picks[i]) {
                this.comparators.add(this.comparatorsAll.get(i));
                this.comparatorsIndex.add(i);
            }
            ++i;
        }
    }

    public void initSizes(boolean[] picks) {
        this.dataSizes.clear();
        this.datasizesIndex.clear();
        int i = 0;
        while (i < 5) {
            if (picks[i]) {
                this.dataSizes.add(this.sizesAll.get(i));
                this.datasizesIndex.add(i);
            }
            ++i;
        }
    }

    public void runAllTests() {
        for (Integer i : this.sortAlgosIndex) {
            System.out.println("Algorithm " + i);
        }
        TimerTests.console.out.println("\nAlgorithm, \tNo., \tComparator, \tSize, \tRunning time");
        int i = 0;
        while (i < this.sortAlgos.size()) {
            int j = 0;
            while (j < this.comparators.size()) {
                int k = 0;
                while (k < this.dataSizes.size()) {
                    long runtime = this.runOneTest(this.sortAlgos.get(i), this.comparators.get(j), this.dataSizes.get(k));
                    TimerTests.console.out.println("Algorithm, \t" + this.sortAlgosIndex.get(i) + ", \t" + this.comparators.get(j).getClass().getName().substring(8) + ", \t" + this.dataSizes.get(k) + ", \t" + runtime);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        long runtime = this.runOneTest(new SortingBST<City>(), this.byName, 10000);
    }

    public long runOneTest(SortAlgorithm<City> algo, Comparator<City> comp, int size) {
        ArrayList<City> source = new ArrayList<City>();
        int i = 0;
        while (i < size) {
            source.add(this.randomdata.get(i));
            ++i;
        }
        algo.init(source);
        this.startTime = new Date().getTime();
        ArrayList<City> result = algo.sort(comp);
        this.endTime = new Date().getTime();
        if (result.size() == source.size()) {
            return this.endTime - this.startTime;
        }
        return -1L;
    }

    public void sampleTests() {
        long runtime = this.runOneTest(new SortingBST<City>(), this.byName, 10000);
        TimerTests.console.out.println("Algorithm 0 time: " + runtime + "\n");
        runtime = this.runOneTest(new SortingInsList<City>(), this.byName, 100);
        TimerTests.console.out.println("Algorithm 1 time: " + runtime + "\n");
        runtime = this.runOneTest(new SortingSelection<City>(), this.byName, 10000);
        TimerTests.console.out.println("Algorithm 2 time: " + runtime + "\n");
        runtime = this.runOneTest(new SortingQuicksortList<City>(), this.byName, 100);
        TimerTests.console.out.println("Algorithm 3 time: " + runtime + "\n");
        runtime = this.runOneTest(new SortingIns<City>(), this.byName, 10000);
        TimerTests.console.out.println("Algorithm 4 time: " + runtime + "\n");
        runtime = this.runOneTest(new SortingQuicksortList<City>(), new Comparator<City>(){

            @Override
            public int compare(City city1, City city2) {
                return city1.name.compareTo(city2.name);
            }
        }, 10000);
        TimerTests.console.out.println("Algorithm 5 time: " + runtime + "\n");
    }

    public static void main(String[] argv) {
        TimerTests tt = new TimerTests();
        tt.sampleTests();
    }
}

