/*
 * Decompiled with CFR 0.152.
 */
package sorting;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Random;
import sorting.SortAlgorithm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SortingQuicksort<T>
implements SortAlgorithm<T> {
    public ArrayList<T> alist;

    SortingQuicksort() {
    }

    @Override
    public void init(ArrayList<T> alistin) {
        this.alist = new ArrayList();
        for (T t : alistin) {
            this.alist.add(t);
        }
    }

    @Override
    public ArrayList<T> sort(Comparator<T> comp) {
        this.quicksort(this.alist, comp);
        return this.alist;
    }

    public Integer randInt(int low, int high) {
        return new Random().nextInt(high - low) + low;
    }

    void swap(ArrayList<T> list, int i, int j) {
        list.set(i, list.set(j, list.get(i)));
    }

    public void quicksort(ArrayList<T> list, Comparator<T> comp) {
        this.quicksortHelper(list, comp, 0, list.size() - 1);
    }

    void quicksortHelper(ArrayList<T> list, Comparator<T> comp, int start, int end) {
        if (end > start) {
            int pivot = this.partition(list, comp, start, end);
            this.quicksortHelper(list, comp, start, pivot - 1);
            this.quicksortHelper(list, comp, pivot + 1, end);
        }
    }

    T pickPivot(ArrayList<T> list, Comparator<T> comp, int start, int end) {
        int pivot = this.randInt(start, end + 1);
        T pivotVal = list.get(pivot);
        this.swap(list, start, pivot);
        return pivotVal;
    }

    /*
     * Unable to fully structure code
     */
    int partition(ArrayList<T> list, Comparator<T> comp, int start, int end) {
        pivotVal = this.pickPivot(list, comp, start, end);
        left_swap_index = start + 1;
        right_swap_index = end;
        ** GOTO lbl12
        {
            ++left_swap_index;
            do {
                if (comp.compare(list.get(left_swap_index), pivotVal) <= 0 && left_swap_index < right_swap_index) continue block0;
                while (comp.compare(list.get(right_swap_index), pivotVal) > 0 && right_swap_index > left_swap_index) {
                    --right_swap_index;
                }
                this.swap(list, left_swap_index, right_swap_index);
lbl12:
                // 2 sources

            } while (left_swap_index < right_swap_index);
        }
        mid = left_swap_index;
        if (comp.compare(list.get(mid), pivotVal) > 0) {
            --mid;
        }
        this.swap(list, start, mid);
        return mid;
    }
}

