/*
 * Decompiled with CFR 0.152.
 */
package sorting;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.text.ParseException;
import javax.swing.JFileChooser;
import sorting.City;
import sorting.CityConverter;
import sorting.TextFileFilter;
import tester.Traversal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InFileCityTraversal
implements Traversal<City> {
    protected BufferedReader buffer;
    protected String line;
    protected City c;
    protected boolean closed = true;
    protected boolean submitted = false;
    protected CityConverter cc = new CityConverter();

    public InFileCityTraversal() {
        JFileChooser chooser = new JFileChooser(".");
        chooser.setFileFilter(new TextFileFilter());
        this.closed = false;
        if (chooser.showOpenDialog(null) != 0) {
            this.closed = true;
            return;
        }
        try {
            this.buffer = new BufferedReader(new FileReader(chooser.getSelectedFile()));
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found exception: " + e);
            this.closed = true;
        }
        this.getnext();
    }

    public void getnext() {
        if (!this.closed) {
            try {
                if (this.buffer.ready()) {
                    this.line = new String(this.buffer.readLine());
                    if (this.line == null || this.line == "") {
                        this.buffer.close();
                        this.closed = true;
                    } else {
                        this.read(this.line);
                    }
                } else {
                    this.buffer.close();
                    this.closed = true;
                }
            }
            catch (Exception e) {
                System.out.println("Error in reading line exception: " + e);
                this.closed = true;
            }
        }
    }

    public Traversal<City> getRest() {
        this.getnext();
        return this;
    }

    public City getFirst() {
        if (!this.closed) {
            return this.c;
        }
        this.closed = true;
        return null;
    }

    public boolean isEmpty() {
        return this.closed;
    }

    public void read(String str) {
        try {
            this.c = this.cc.fromStringData(str);
        }
        catch (ParseException e) {
            System.out.println(String.valueOf(e.getMessage()) + " parse exception in line\n" + this.line);
            this.c = null;
            this.closed = true;
        }
    }
}

