/*
 * Decompiled with CFR 0.152.
 */
package sorting;

import java.util.ArrayList;
import java.util.Comparator;
import sorting.Algorithms;
import sorting.City;
import sorting.CityConverter;
import sorting.ConsLo;
import sorting.Examples;
import sorting.ILo;
import sorting.InFileCityTraversal;
import sorting.MtLo;
import sorting.SortAlgorithm;
import sorting.SortingBST;
import sorting.SortingIns;
import sorting.SortingInsList;
import sorting.SortingQuicksort;
import sorting.SortingQuicksortList;
import sorting.SortingSelection;
import student.Heapsort;
import tester.IllegalUseOfTraversalException;
import tester.Tester;

public class ExamplesSorting {
    ArrayList<City> NEcities = new ArrayList();
    ArrayList<City> NEcitiesSorted = new ArrayList();
    City concord = new City("03301", "Concord", "NH", 71.527734, 43.218525);
    City montpellier = new City("05602", "Montpelier", "VT", 72.576992, 44.264082);
    City augusta = new City("04330", "Augusta", "ME", 69.766548, 44.323228);
    City boston = new City("02115", "Boston", "MA", 71.092215, 42.342706);
    City hartford = new City("06120", "Hartford", "CT", 72.675807, 41.78596);
    City providence = new City("02908", "Providence", "RI", 71.437684, 41.838294);
    ILo<City> NEcitiesList = new ConsLo<City>(this.concord, new ConsLo<City>(this.montpellier, new ConsLo<City>(this.augusta, new ConsLo<City>(this.boston, new ConsLo<City>(this.hartford, new ConsLo<City>(this.providence, new MtLo()))))));
    ILo<City> NEcitiesListSortedNames = new ConsLo<City>(this.augusta, new ConsLo<City>(this.boston, new ConsLo<City>(this.concord, new ConsLo<City>(this.hartford, new ConsLo<City>(this.montpellier, new ConsLo<City>(this.providence, new MtLo()))))));
    ArrayList<City> NEcitiesArrList = new ArrayList();
    ArrayList<City> NEcitiesArrListSortedNames = new ArrayList();
    Comparator<City> nameComp = new Comparator<City>(){

        @Override
        public int compare(City c1, City c2) {
            if (c1.name.compareTo(c2.name) == 0) {
                return c1.state.compareTo(c2.state);
            }
            return c1.name.compareTo(c2.name);
        }
    };
    Comparator<City> zipComp = new Comparator<City>(){

        @Override
        public int compare(City c1, City c2) {
            return c1.zip - c2.zip;
        }
    };
    Algorithms algo = new Algorithms();
    ArrayList<City> cities = new ArrayList();
    ILo<City> citylist = new MtLo<City>();
    CityConverter cityConvert = new CityConverter();
    SortAlgorithm<City> bst = new SortingBST<City>();
    SortAlgorithm<City> insertlist = new SortingInsList<City>();
    SortAlgorithm<City> selectarray = new SortingSelection<City>();
    SortAlgorithm<City> quicklist = new SortingQuicksortList<City>();
    SortAlgorithm<City> insertarray = new SortingIns<City>();
    SortAlgorithm<City> quickarray = new SortingQuicksort<City>();
    SortAlgorithm<City> heapsort = new Heapsort();

    ExamplesSorting() {
    }

    void initNE() {
        this.NEcitiesArrList.clear();
        this.NEcitiesArrList.add(this.concord);
        this.NEcitiesArrList.add(this.montpellier);
        this.NEcitiesArrList.add(this.augusta);
        this.NEcitiesArrList.add(this.boston);
        this.NEcitiesArrList.add(this.hartford);
        this.NEcitiesArrList.add(this.providence);
        this.NEcitiesArrListSortedNames.clear();
        this.NEcitiesArrListSortedNames.add(this.augusta);
        this.NEcitiesArrListSortedNames.add(this.boston);
        this.NEcitiesArrListSortedNames.add(this.concord);
        this.NEcitiesArrListSortedNames.add(this.hartford);
        this.NEcitiesArrListSortedNames.add(this.montpellier);
        this.NEcitiesArrListSortedNames.add(this.providence);
    }

    public void makeNewEngland() {
        this.NEcities.add(this.concord);
        this.NEcities.add(this.montpellier);
        this.NEcities.add(this.augusta);
        this.NEcities.add(this.boston);
        this.NEcities.add(this.hartford);
    }

    public void makeSortedNewEngland() {
        this.NEcitiesSorted.add(this.augusta);
        this.NEcitiesSorted.add(this.boston);
        this.NEcitiesSorted.add(this.concord);
        this.NEcitiesSorted.add(this.hartford);
        this.NEcitiesSorted.add(this.montpellier);
    }

    public void initCities(int limit) {
        InFileCityTraversal tr = new InFileCityTraversal();
        System.out.println("Reading " + limit + " items of city data");
        int i = 0;
        try {
            while (!tr.isEmpty() && i < limit) {
                City c = (City)tr.getFirst();
                this.cities.add(c);
                this.citylist = new ConsLo<City>(c, this.citylist);
                tr = tr.getRest();
                if (this.cities.get((int)i).name.contains("9")) {
                    System.out.println(this.cities.get(i).toString());
                }
                ++i;
            }
        }
        catch (IllegalUseOfTraversalException e) {
            System.out.println("IllegalUseOfTraversalException: cannot happen" + e.getMessage());
        }
    }

    public void testInitData(Tester t) {
        this.makeNewEngland();
        for (City c : this.NEcities) {
            System.out.println(c.toString());
        }
        this.cityConvert.testScanner();
        this.cities.clear();
    }

    public void testQuickSort(Tester t) {
        t.checkExpect(this.NEcitiesList.quicksort(this.nameComp), this.NEcitiesListSortedNames);
        this.NEcities.clear();
        this.makeNewEngland();
        this.makeSortedNewEngland();
        this.algo.selectionsort(this.NEcities, this.nameComp);
        t.checkExpect(this.NEcities, this.NEcitiesSorted);
    }

    public void testSelectionSort(Tester t) {
        Examples e = new Examples();
        ArrayList<City> source = new ArrayList<City>();
        source.add(e.duluth1);
        source.add(e.northville);
        source.add(e.plymouth);
        ArrayList<City> unsorted = new ArrayList<City>();
        unsorted.add(e.northville);
        unsorted.add(e.plymouth);
        unsorted.add(e.duluth1);
        ArrayList<City> sorted = new ArrayList<City>();
        sorted.add(e.duluth1);
        sorted.add(e.northville);
        sorted.add(e.plymouth);
        this.algo.selectionsort(unsorted, this.nameComp);
        t.checkExpect(sorted, unsorted, "selectionSort");
    }

    void testAlgos(Tester t) {
        this.quicklist.init(this.NEcitiesArrList);
        t.checkExpect(this.quicklist.sort(this.nameComp), this.NEcitiesArrListSortedNames);
    }
}

