/*
 * Decompiled with CFR 0.152.
 */
package sorting;

import java.util.Comparator;
import sorting.ILo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConsLo<T>
implements ILo<T> {
    T first;
    ILo<T> rest;

    ConsLo(T first, ILo<T> rest) {
        this.first = first;
        this.rest = rest;
    }

    @Override
    public ILo<T> quicksort(Comparator<T> comp) {
        return this.rest.lower(this.first, comp).quicksort(comp).append(new ConsLo<T>(this.first, this.upper(this.first, comp).quicksort(comp)));
    }

    @Override
    public ILo<T> lower(T pivot, Comparator<T> comp) {
        if (comp.compare(this.first, pivot) <= 0) {
            return new ConsLo<T>(this.first, this.rest.lower(pivot, comp));
        }
        return this.rest.lower(pivot, comp);
    }

    @Override
    public ILo<T> upper(T pivot, Comparator<T> comp) {
        if (comp.compare(this.first, pivot) > 0) {
            return new ConsLo<T>(this.first, this.rest.upper(pivot, comp));
        }
        return this.rest.upper(pivot, comp);
    }

    @Override
    public ILo<T> append(ILo<T> that) {
        return new ConsLo<T>(this.first, this.rest.append(that));
    }

    @Override
    public ILo<T> insertionsort(Comparator<T> comp) {
        return this.rest.insertionsort(comp).insert(this.first, comp);
    }

    @Override
    public ILo<T> insert(T item, Comparator<T> comp) {
        if (comp.compare(item, this.first) <= 0) {
            return new ConsLo<T>(item, this);
        }
        return new ConsLo<T>(this.first, this.rest.insert(item, comp));
    }

    @Override
    public void printlist() {
        System.out.print(this.first.toString());
        this.rest.printlist();
    }

    @Override
    public boolean isSorted(Comparator<T> comp) {
        return this.rest.isSortedAfter(this.first, comp);
    }

    @Override
    public boolean isSortedAfter(T item, Comparator<T> comp) {
        return comp.compare(item, this.first) <= 0 && this.rest.isSortedAfter(this.first, comp);
    }
}

