/*
 * Decompiled with CFR 0.152.
 */
package sorting;

import java.text.ParseException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import sorting.City;

class CityConverter {
    CityConverter() {
    }

    public String toStringData(City that) {
        String s = City.zipFormat.format(that.zip) + ", " + that.name + ", " + that.state + ", " + that.longitude + ", " + that.latitude + "\n";
        return s;
    }

    public City fromStringData(String s) throws ParseException {
        City city = new City();
        try {
            StringTokenizer st = new StringTokenizer(s, ",");
            city.zip = Integer.valueOf(st.nextToken());
            city.name = st.nextToken();
            city.state = st.nextToken();
            city.longitude = Double.valueOf(st.nextToken());
            city.latitude = Double.valueOf(st.nextToken());
            return city;
        }
        catch (NoSuchElementException e) {
            System.out.println(e.getMessage());
            throw new ParseException("Tokenizer Error", 0);
        }
    }

    public void testScanner() {
        City boston = new City("02115", "Boston", "MA", 71.092215, 42.342706);
        String str = this.toStringData(boston);
        System.out.println("Encoded string: " + str);
        City temp = new City();
        try {
            temp = this.fromStringData(str);
        }
        catch (ParseException e) {
            System.out.println("Parse error: " + str + "\n" + e.getMessage());
        }
        System.out.println(temp);
    }
}

