/*
 * Decompiled with CFR 0.152.
 */
package sorting;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XDouble;
import edu.neu.ccs.XInt;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

class City
implements Stringable {
    public int zip;
    public String name;
    public String state;
    public double longitude;
    public double latitude;
    public static DecimalFormat zipFormat = new DecimalFormat("00000");

    public City(int zip, String name, String state, double longitude, double latitude) {
        this.zip = zip;
        this.name = name;
        this.state = state;
        this.longitude = longitude;
        this.latitude = latitude;
    }

    public City(City aCity) {
        this(aCity.zip, aCity.name, aCity.state, aCity.longitude, aCity.latitude);
    }

    public City(String zip, String name, String state, double longitude, double latitude) {
        this.zip = this.decimal(zip);
        this.name = name;
        this.state = state;
        this.longitude = longitude;
        this.latitude = latitude;
    }

    public City() {
        this.zip = 48170;
        this.name = "Plymouth";
        this.state = "MI";
        this.longitude = 83.479946;
        this.latitude = 42.36882;
    }

    public String toStringData() {
        String s = zipFormat.format(this.zip) + ", " + this.name + ", " + this.state + ", " + this.longitude + ", " + this.latitude + "\n";
        return s;
    }

    public void fromStringData(String s) throws ParseException {
        try {
            StringTokenizer st = new StringTokenizer(s, ",");
            this.zip = this.decimal(st.nextToken());
            this.name = st.nextToken();
            this.state = st.nextToken();
            this.longitude = this.doubleValue(st.nextToken());
            this.latitude = this.doubleValue(st.nextToken());
        }
        catch (NoSuchElementException e) {
            System.out.println(e.getMessage());
            throw new ParseException("Tokenizer Error", 0);
        }
    }

    protected int intValue(String s) throws ParseException {
        return new XInt(s).intValue();
    }

    protected double doubleValue(String s) throws ParseException {
        return new XDouble(s).doubleValue();
    }

    public String toString() {
        return "new " + this.getClass().getName() + "(" + zipFormat.format(this.zip) + ", " + this.name + ", " + this.state + ", " + this.longitude + ", " + this.latitude + ")\n";
    }

    public int decimal(String s) {
        char[] c = s.toCharArray();
        int n = 0;
        try {
            int i = 0;
            while (i < 5) {
                n = 10 * n + this.intValue("" + c[i]);
                ++i;
            }
        }
        catch (ParseException e) {
            System.out.println("Converting zip to int " + e);
        }
        return n;
    }
}

