/*
 * Decompiled with CFR 0.152.
 */
package sorting;

import edu.neu.ccs.console.ConsoleAware;
import edu.neu.ccs.util.MathUtilities;
import java.util.ArrayList;
import java.util.Comparator;
import sorting.City;
import sorting.ConsLo;
import sorting.ILo;
import sorting.InFileCityTraversal;
import sorting.MtLo;
import tester.IllegalUseOfTraversalException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Algorithms
implements ConsoleAware {
    ArrayList<City> cities = new ArrayList();
    ILo<City> citylist = new MtLo<City>();

    public void initCities(int limit) {
        InFileCityTraversal tr = new InFileCityTraversal();
        System.out.println("Reading " + limit + " items of city data");
        int i = 0;
        try {
            while (!tr.isEmpty() && i < limit) {
                City c = (City)tr.getFirst();
                this.cities.add(c);
                this.citylist = new ConsLo<City>(c, this.citylist);
                tr = tr.getRest();
                if (this.cities.get((int)i).name.contains("9")) {
                    System.out.println(this.cities.get(i).toString());
                }
                ++i;
            }
        }
        catch (IllegalUseOfTraversalException e) {
            System.out.println("IllegalUseOfTraversalException: cannot happen" + e.getMessage());
        }
    }

    ArrayList<City> reverse() {
        ArrayList<City> result = new ArrayList<City>();
        int i = this.cities.size() - 1;
        while (i >= 0) {
            result.add(this.cities.get(i));
            --i;
        }
        return result;
    }

    ArrayList<City> copy() {
        ArrayList<City> result = new ArrayList<City>();
        for (City c : this.cities) {
            result.add(c);
        }
        return result;
    }

    public ArrayList<City> randomData() {
        ArrayList<City> temp = this.copy();
        ArrayList<City> result = new ArrayList<City>();
        int index = 0;
        int i = temp.size() - 1;
        while (i >= 0) {
            index = MathUtilities.randomInt((int)0, (int)i);
            result.add(temp.remove(index));
            --i;
        }
        Algorithms.console.out.println("Data set of size " + result.size() + " initialized.");
        return result;
    }

    public <T> void selectionsort(ArrayList<T> alist, Comparator<T> comp) {
        int i = 0;
        while (i < alist.size() - 1) {
            this.swap(alist, i, this.findFirstLoc(alist, comp, i));
            ++i;
        }
    }

    public <T> void swap(ArrayList<T> a, int i, int j) {
        T temp = a.get(i);
        temp = a.set(j, temp);
        a.set(i, temp);
    }

    public <T> int findFirstLoc(ArrayList<T> alist, Comparator<T> comp, int curr) {
        int loc = curr;
        T minObj = alist.get(loc);
        int index = curr + 1;
        while (index < alist.size()) {
            if (comp.compare(minObj, alist.get(index)) > 0) {
                loc = index;
                minObj = alist.get(index);
            }
            ++index;
        }
        return loc;
    }
}

