import java.util.*;

import tester.*;

/**
 * The test suite for the Sorting Algorithms exploration
 * 
 * @author Viera K. Proulx
 *
 */
public class ExamplesSorting{
  ExamplesSorting(){}
  
  /** data for the methods and tests */
  ArrayList<City> NEcities = new ArrayList<City>();
  ArrayList<City> NEcitiesSorted = new ArrayList<City>();
  
  City concord = new City("03301", "Concord", "NH", 71.527734, 43.218525);
  City montpellier = new City("05602", "Montpelier", "VT", 72.576992, 44.264082);
  City augusta = new City("04330", "Augusta", "ME", 69.766548, 44.323228);
  City boston = new City("02115", "Boston", "MA", 71.092215, 42.342706);
  City hartford = new City("06120", "Hartford", "CT", 72.675807, 41.78596);
  City providence = new City("02908", "Providence", "RI", 71.437684, 41.838294);

  ILo<City> NEcitiesList = 
    new ConsLo<City>(this.concord,
        new ConsLo<City>(this.montpellier,
            new ConsLo<City>(this.augusta,
                new ConsLo<City>(this.boston,
                    new ConsLo<City>(this.hartford,
                        new ConsLo<City>(this.providence,
                            new MtLo<City>()))))));

  ILo<City> NEcitiesListSortedNames = 
    new ConsLo<City>(this.augusta,
        new ConsLo<City>(this.boston,
            new ConsLo<City>(this.concord,
                new ConsLo<City>(this.hartford,
                    new ConsLo<City>(this.montpellier,
                        new ConsLo<City>(this.providence,
                            new MtLo<City>()))))));
  
  Comparator<City> nameComp = new Comparator<City>(){
    public int compare(City c1, City c2){
      return c1.name.compareTo(c2.name);
    }
  };
  
  Algorithms algo = new Algorithms();
  
  /** generate lists of neighboring states */
  public void makeNewEngland(){
    this.NEcities.add(this.concord);
    this.NEcities.add(this.montpellier);
    this.NEcities.add(this.augusta);
    this.NEcities.add(this.boston);
    this.NEcities.add(this.hartford);
  }  
  
  /** generate lists of neighboring states */
  public void makeSortedNewEngland(){
    this.NEcitiesSorted.add(this.augusta);
    this.NEcitiesSorted.add(this.boston);
    this.NEcitiesSorted.add(this.concord);
    this.NEcitiesSorted.add(this.hartford);
    this.NEcitiesSorted.add(this.montpellier);
  }

  ArrayList<City> cities = new ArrayList<City>();
  ILo<City> citylist = new MtLo<City>();

  /** i
   * Initialize cities with the data from a file 
   *  @param limit the maximum number of item to read
   *  */
  public void initCities(int limit){
    Traversal<City> tr = new InFileCityTraversal();

    System.out.println("Reading " + limit + " items of city data");
    int i = 0;
    try{
      while (!tr.isEmpty() && i < limit){
        // get the next city
        City c = tr.getFirst();
        
        // add it to the cities list
        this.cities.add(c);
        
        // add it to the citylist
        this.citylist = new ConsLo<City>(c, this.citylist);
        
        // advance to get the next city
        tr = tr.getRest();
        
        // update the counter of cities read in so far
        i++;
      }
    }
    catch(IllegalUseOfTraversalException e){
      System.out.println(
          "IllegalUseOfTraversalException: cannot happen" +
          e.getMessage());
    } 
  }
  
  CityConverter cityConvert = new CityConverter();
 
  /**
   * Visual 'tests' for the reading and printing of City data
   */
  public void testInitData(Tester t){
    this.makeNewEngland();
    
    // see that the toString method produces Strings as expected
    // Note: this should be converted to an actual test case
    for (City c: this.NEcities){
      System.out.println(c.toString());
    }
    
    // see that the fromStringData method initializes the City object
    // as expected
    // Note: this should be converted to an actual test case
    this.cityConvert.testScanner();
    
    this.cities.clear();
  }
  
  /**
   * test the quicksort for cities
   */
  public void testInsertionSort(Tester t){
    
    this.NEcities.clear();
    makeNewEngland();
    makeSortedNewEngland();
    this.algo.insertionSort(this.NEcities, this.nameComp);
    t.checkExpect(this.NEcities, this.NEcitiesSorted);
    
    // run the algorithm for 2000 data items
    initCities(2000);
 
    // run the timed test and print the measured time
    long startTime = (new Date()).getTime();
    this.algo.insertionSort(this.cities, this.nameComp);
    long endTime = (new Date()).getTime();
    System.out.println("Time for insertion sort " + (endTime - startTime));
    
    System.out.println("We have sorted " + this.cities.size() + " cities");  
    for (int i = 0; i < 50; i++){
      System.out.print(this.cities.get(i).toString());
    }
  }
  
}