import java.util.*;

public class Algorithms{

  // Return random Integer between: [low, high)
  public Integer randInt(int low, int high){ 
    return new Random().nextInt( high - low ) + low; 
  }
  
  // The swap we've seen many times in previous labs/hws
  <T> void swap(ArrayList<T> list, int i, int j){
     list.set( i, list.set( j, list.get( i ) ) );
  }
  
  // Basic insertion sort algorithm
  // Starting from the back, insert the current element into the 
  //   sorted 'rest' of the list. The last element is trivially sorted  
  public <T> void insertionSort(ArrayList<T> list, 
                                Comparator<T> comp){
    for( int i = list.size() - 2; i >= 0; i-- )
      insert( list, i, comp );
  }
    
  // "inserts" an element at i into the sorted part of the arraylist
  <T> void insert(ArrayList<T> list, int i, 
                  Comparator<T> comp){
    while( i < list.size() - 1 
        && comp.compare(list.get(i + 1), list.get(i)) < 0 ){
      swap( list, i, i + 1 );
      i++;
    }
  }

}

interface ILo<T>{
  // produce a sorted list from this list
  // sorted in the order given by the Comparator
  public ILo<T> quicksort(Comparator<T> comp);
  
  // print this list
  public void printlist();
  
  // is this list sorted
  public boolean isSorted(Comparator<T> comp);
  
  // is this list sorted after the given item?
  public boolean isSortedAfter(T item, Comparator<T> comp);
}

class MtLo<T> implements ILo<T>{
  MtLo(){}
  
  // produce a sorted list from this list
  public ILo<T> quicksort(Comparator<T> comp){
    return this;
  }
  
  // print this list
  public void printlist(){
    System.out.println("THE END");
  }
  
  // is this list sorted
  public boolean isSorted(Comparator<T> comp){
    return true;
  }
  
  // is this list sorted after the given item?
  public boolean isSortedAfter(T item, Comparator<T> comp){
    return true;
  }
}

class ConsLo<T> implements ILo<T>{
  T first;
  ILo<T> rest;
  
  ConsLo(T first, ILo<T> rest){
    this.first = first;
    this.rest = rest;
  }
  
  // produce a sorted list from this list
  public ILo<T> quicksort(Comparator<T> comp){
    //------------  WRITE YOUR CODE HERE -----------------//
    //--------  AND EVERYWHERE ELSE WHERE NEEDED ---------//
    return this;
  }
    
  // print this list
  public void printlist(){
    System.out.print(this.first.toString());
    this.rest.printlist();
  }
  
  // is this list sorted?
  public boolean isSorted(Comparator<T> comp){
    return this.rest.isSortedAfter(this.first, comp);
  }
  
  // is this list sorted after the given item?
  public boolean isSortedAfter(T item, Comparator<T> comp){
    return (comp.compare(item, this.first) <= 0) &&
           this.rest.isSortedAfter(this.first, comp);
  }
}