// to represent a node in a list os Strings
class Node{
  String data;
  Node next;
  
  Node(String data, Node next){
    this.data = data;
    this.next = next;
  }

  /* TEMPLATE:
  FIELDS:
  ... this.data ...       -- String
  ... this.next ...       -- Node
  
  METHODS:
  ... this.lastNode() ...            -- void
  ... this.insertAfter(Node) ...     -- void
  
  METODS FOR FIELDS:
  ... this.next.lastNode() ...            -- void
  ... this.next.insertAfter(Node) ...     -- void
  
   */
  
  // is this the sentinel node?
  boolean lastNode(){
    return false;
  }
  
  // EFFECT: 
  // insert in a sorted order after the given node
  // Node prev is the node in the list before the current one
  void insertAfter(Node prev, String string){
    if (string.compareTo(this.data) <= 0){
      prev.next = new Node(string, this);
    }
    else{
      this.next.insertAfter(this, string);
    }
  }
}

// to represent the last node in a linked list of Strings
class Sentinel extends Node{
  // only we can construct a new Sentinel object
  private Sentinel(){
    super("", null);
  }
  
  // one and only instance of Sentinel
  public static Sentinel tail = new Sentinel();
  

  // is this the sentinel node?
  boolean lastNode(){
    return true;
  }  
  
  // EFFECT: 
  // insert is a sorted order after the given node
  // Node prev is the node in the list before the current one
  void insertAfter(Node prev, String string){
    Node tmp = new Node(string, this);
    prev.next = tmp;
  }
  
}