// to represent a list of Strings
public class LoS{
  Node node;
  
  LoS(){
    this.node = Sentinel.tail;
  }
  /* TEMPLATE:
  FIELDS:
  ... this.node ...       -- Node
  
  METHODS:
  ... this.clear() ...               -- void
  ... this.add(String) ...           -- void
  ... this.removeFirst() ...         -- void
  ... this.insertSorted(String) ...  -- void
  ... this.isEmpty() ...             -- void
  ... this.getFirst() ...            -- void
  ... this.getRest() ...             -- void
  
  METODS FOR FIELDS:
  ... this.node.lastNode() ...            -- void
  ... this.node.insertAfter(Node) ...     -- void
  
   */
  
  // EFFECT: 
  // remove all items from this list
  void clear(){
    this.node = Sentinel.tail;
  }
  
  //EFFECT: 
  // add a new node with the given String to the front of this list
  void add(String s){
    this.node = new Node(s, this.node);
  }
  
  //EFFECT: 
  // remove the first node from this list
  // produce the removed item 
  String removeFirst(){
    if (this.node.lastNode()){
      throw new RuntimeException("cannot remove item from an empty list");
    }
    else {
      String s = this.node.data;
      this.node = this.node.next;
      return s;
    }
  }
  
  //EFFECT:
  // insert a new node with the given String as data
  // into this list in a sorted order
  void insertSorted(String s){
    if (this.node.lastNode()){
      this.node = new Node(s, this.node);
    }
    else {
      this.node.next.insertAfter(this.node, s);
    }
  }

  // is this an empty list
  boolean isEmpty(){
    return this.node.lastNode();
  }
  
  // get the first item in this list represents
  String getFirst(){
    if (this.node.lastNode()){
      throw new RuntimeException("no first item in an empty list");
    }
    else {
      return this.node.data;
    }
  }
  
  // produce a list with the first item removed
  LoS getRest(){
    if (this.node.lastNode()){
      throw new RuntimeException("cannot advance beyond last item");
    }
    else {
      this.node = this.node.next;
      return this;
    }
  }
}