import tester.*;

// linked list examples
class ExamplesLoS{
  ExamplesLoS(){}
  
  LoS alist = new LoS();
  Node node;
  
  void resetLoS(){
    this.alist.clear();
  }
  
  void setupLoS(){
    this.node = 
      new Node("abc", 
          new Node("def", 
              new Node("ghi", Sentinel.tail)));
  }
  
  // test the effects for the methods invoked on the empty list
  void testSentinel(Tester t){
    // setup
    resetLoS();
    
    // test isEmpty method:
    t.checkExpect(this.alist.isEmpty(), true);
    
    // test the exception thrown by removeFirst:
    t.checkException(
        new RuntimeException("cannot remove item from an empty list"), 
        this.alist, "removeFirst");

    // test the exception thrown by getFirst:
    t.checkException(
        new RuntimeException("no first item in an empty list"), 
        this.alist, "getFirst");

    // test the exception thrown by getRest:
    t.checkException(
        new RuntimeException("cannot advance beyond last item"), 
        this.alist, "getRest");
    
    // test the insertSorted method:
    this.alist.insertSorted("hello");
    
    t.checkExpect(this.alist.node, new Node("hello", Sentinel.tail));
    
    // tear-down
    resetLoS();
  }
  
  void testAdd(Tester t){
    // testing the add method:
    setupLoS();
    resetLoS();
    this.alist.add("ghi");
    this.alist.add("def");
    this.alist.add("abc");
    t.checkExpect(this.alist.node, this.node);
  }
  
  // test the method insertSorted for the LoS class:
  void testInsertSorted(Tester t){

    // testing the insertSorted method and its helpers:
    setupLoS();
    resetLoS();

    // test insertSorted for empty list:
    this.alist.insertSorted("abc");
    t.checkExpect(this.alist.node, 
        new Node("abc", Sentinel.tail));  

    // test insertSorted for nonempty list:
    this.alist.insertSorted("ghi");
    this.alist.insertSorted("def");
    t.checkExpect(this.alist.node, this.node);    
  }

}