/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.Color;
import java.awt.Graphics2D;
import javalib.colors.IColor;
import javalib.worldimages.OverlayImages;
import javalib.worldimages.Posn;

public abstract class WorldImage {
    public Posn pinhole;
    public Color color;

    public WorldImage(Posn pinhole, Color color) {
        this.pinhole = new Posn(pinhole.x, pinhole.y);
        this.color = color;
    }

    public WorldImage(Posn pinhole, IColor color) {
        this.pinhole = pinhole;
        this.color = color.thisColor();
    }

    public abstract void draw(Graphics2D var1);

    public abstract WorldImage getMovedImage(int var1, int var2);

    public abstract WorldImage getMovedTo(Posn var1);

    public void movePinhole(int dx, int dy) {
        this.pinhole.x += dx;
        this.pinhole.y += dy;
    }

    public void moveTo(Posn p) {
        this.pinhole.x = p.x;
        this.pinhole.y = p.y;
    }

    protected Posn movePosn(Posn p, int dx, int dy) {
        return new Posn(p.x + dx, p.y + dy);
    }

    public WorldImage overlayImages(WorldImage ... args) {
        WorldImage image = this;
        int xTotal = this.pinhole.x;
        int yTotal = this.pinhole.y;
        int length = args != null ? args.length : 0;
        for (int i = 0; i < length; ++i) {
            image = new OverlayImages(image, args[i]);
            xTotal += args[i].pinhole.x;
            yTotal += args[i].pinhole.y;
        }
        image.pinhole.x = xTotal / (length + 1);
        image.pinhole.y = yTotal / (length + 1);
        return image;
    }

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract String toIndentedString(String var1);

    protected static String colorString(String indent, Color color) {
        String result = color.toString();
        int start = result.indexOf(91);
        result = result.substring(start, result.length());
        return "\n" + indent + "this.color = " + result + ",";
    }

    protected static String classNameString(String indent, String className) {
        return "\n" + indent + "new " + className + "(";
    }

    protected static String pinholeString(String indent, Posn pin) {
        return "\n" + indent + "this.pinhole = (" + pin.x + ", " + pin.y + "),";
    }

    public static void main(String[] argv) {
        System.out.println(WorldImage.colorString("  ", new Color(255, 255, 0, 50)));
    }
}

