/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import javalib.colors.IColor;
import javalib.worldimages.Posn;
import javalib.worldimages.WorldImage;

public class TriangleImage
extends WorldImage {
    public Posn p1;
    public Posn p2;
    public Posn p3;
    private Polygon poly;

    public TriangleImage(Posn p1, Posn p2, Posn p3, Color color) {
        super(p1, color);
        this.p1 = p1;
        this.p2 = p2;
        this.p3 = p3;
        int[] xCoord = new int[]{p1.x, p2.x, p3.x};
        int[] yCoord = new int[]{p1.y, p2.y, p3.y};
        this.poly = new Polygon(xCoord, yCoord, 3);
        this.pinhole.x = (this.p1.x + this.p2.x + this.p3.x) / 3;
        this.pinhole.y = (this.p1.y + this.p2.y + this.p3.y) / 3;
    }

    public TriangleImage(Posn p1, Posn p2, Posn p3, IColor color) {
        this(p1, p2, p3, color.thisColor());
    }

    public void draw(Graphics2D g) {
        if (this.color == null) {
            this.color = new Color(0, 0, 0);
        }
        Paint oldPaint = g.getPaint();
        g.setPaint(this.color);
        g.fill(this.poly);
        g.setPaint(oldPaint);
    }

    public WorldImage getMovedImage(int dx, int dy) {
        return new TriangleImage(this.movePosn(this.p1, dx, dy), this.movePosn(this.p2, dx, dy), this.movePosn(this.p3, dx, dy), this.color);
    }

    public WorldImage getMovedTo(Posn p) {
        int dx = p.x - this.pinhole.x;
        int dy = p.y - this.pinhole.y;
        return this.getMovedImage(dx, dy);
    }

    public void movePinhole(int dx, int dy) {
        this.pinhole.x += dx;
        this.pinhole.y += dy;
        this.p1.x += dx;
        this.p1.y += dy;
        this.p2.x += dx;
        this.p2.y += dy;
        this.p3.x += dx;
        this.p3.y += dy;
    }

    public void moveTo(Posn p) {
        int dx = p.x - this.pinhole.x;
        int dy = p.y - this.pinhole.y;
        this.movePinhole(dx, dy);
    }

    public int getWidth() {
        return Math.max(this.p1.x, Math.max(this.p2.x, this.p3.x)) - Math.min(this.p1.x, Math.min(this.p2.x, this.p3.x));
    }

    public int getHeight() {
        return Math.max(this.p1.y, Math.max(this.p2.y, this.p3.y)) - Math.min(this.p1.y, Math.min(this.p2.y, this.p3.y));
    }

    public String toString() {
        return "new TriangleImage(this.pinhole = (" + this.pinhole.x + ", " + this.pinhole.y + "), \nthis.color = " + this.color.toString() + "\nthis.p1 = (" + this.p1.x + ", " + this.p1.y + "), \nthis.p2 = (" + this.p2.x + ", " + this.p2.y + "), \nthis.p3 = (" + this.p3.x + ", " + this.p3.y + "))\n";
    }

    public String toIndentedString(String indent) {
        indent = indent + " ";
        return TriangleImage.classNameString(indent, "TriangleImage") + TriangleImage.pinholeString(indent, this.pinhole) + TriangleImage.colorString(indent, this.color) + "\n" + indent + "this.p1 = (" + this.p1.x + ", " + this.p1.y + "), \n" + indent + "this.p2 = (" + this.p2.x + ", " + this.p2.y + "), \n" + indent + "this.p3 = (" + this.p3.x + ", " + this.p3.y + "))\n";
    }

    public boolean equals(Object o) {
        if (o instanceof TriangleImage) {
            TriangleImage that = (TriangleImage)o;
            return this.pinhole.x == that.pinhole.x && this.pinhole.y == that.pinhole.y && this.p1.x == that.p1.x && this.p1.y == that.p1.y && this.p2.x == that.p2.x && this.p2.y == that.p2.y && this.p3.x == that.p3.x && this.p3.y == that.p3.y && this.color.equals(that.color);
        }
        return false;
    }

    public int hashCode() {
        return this.pinhole.x + this.pinhole.y + this.color.hashCode() + this.p1.x * this.p1.y + this.p2.x * this.p2.y + this.p3.x * this.p3.y;
    }
}

