/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javalib.colors.IColor;
import javalib.worldcanvas.CanvasPanel;
import javalib.worldimages.Posn;
import javalib.worldimages.WorldImage;

public class TextImage
extends WorldImage {
    public String text;
    public float size;
    public int style = 0;
    public int width = 0;
    public int height = 0;
    public int alignment = 1;
    public static CanvasPanel c = new CanvasPanel(600, 600);
    protected static Graphics2D g = c.getBufferGraphics();
    protected static Font font = g.getFont();

    public TextImage(Posn pinhole, String text, float size, int style, Color color) {
        super(pinhole, color);
        if (text == null || text.equals("")) {
            text = " ";
        }
        this.text = text;
        this.size = size;
        this.style = style;
        this.setWidthHeight();
    }

    public TextImage(Posn pinhole, String text, int size, int style, Color color) {
        super(pinhole, color);
        if (text == null || text.equals("")) {
            text = " ";
        }
        this.text = text;
        this.size = size;
        this.style = style;
        this.setWidthHeight();
    }

    public TextImage(Posn pinhole, String text, float size, Color color) {
        this(pinhole, text, size, 0, color);
    }

    public TextImage(Posn pinhole, String text, int size, Color color) {
        this(pinhole, text, size, 0, color);
    }

    public TextImage(Posn pinhole, String text, Color color) {
        this(pinhole, text, 13, 0, color);
    }

    public TextImage(Posn pinhole, String text, float size, int style, IColor color) {
        this(pinhole, text, size, style, color.thisColor());
    }

    public TextImage(Posn pinhole, String text, int size, int style, IColor color) {
        this(pinhole, text, size, style, color.thisColor());
    }

    public TextImage(Posn pinhole, String text, float size, IColor color) {
        this(pinhole, text, size, 0, color);
    }

    public TextImage(Posn pinhole, String text, int size, IColor color) {
        this(pinhole, text, size, 0, color);
    }

    public TextImage(Posn pinhole, String text, IColor color) {
        this(pinhole, text, 13, 0, color);
    }

    public void draw(Graphics2D g) {
        if (this.text == null) {
            this.text = "";
        }
        if (this.color == null) {
            this.color = new Color(0, 0, 0);
        }
        Paint oldPaint = g.getPaint();
        Font oldFont = g.getFont();
        g.setFont(oldFont.deriveFont(this.style, this.size));
        g.setPaint(this.color);
        if (this.alignment == 1) {
            g.drawString(this.text, this.pinhole.x - this.width / 2, this.pinhole.y + this.height / 4);
        }
        g.setPaint(oldPaint);
        g.setFont(oldFont);
    }

    public WorldImage getMovedImage(int dx, int dy) {
        return new TextImage(this.movePosn(this.pinhole, dx, dy), this.text, this.size, this.style, this.color);
    }

    public WorldImage getMovedTo(Posn p) {
        return new TextImage(p, this.text, this.size, this.style, this.color);
    }

    protected void setWidthHeight() {
        g.setFont(font.deriveFont(this.style, this.size));
        Font newFont = g.getFont();
        FontRenderContext frc = g.getFontRenderContext();
        Point2D.Double loc = new Point2D.Double(300.0, 300.0);
        TextLayout layout = new TextLayout(this.text, newFont, frc);
        layout.draw(g, (float)((Point2D)loc).getX(), (float)((Point2D)loc).getY());
        g.setFont(font);
        Rectangle2D bounds = layout.getBounds();
        this.width = (int)bounds.getWidth();
        this.height = (int)bounds.getHeight();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String toString() {
        char c = '\"';
        return "new TextImage(this.pinhole = (" + this.pinhole.x + ", " + this.pinhole.y + "), \nthis.color = " + this.color.toString() + "\nthis.size = " + this.size + ", this.style = " + this.style + ", this.alignment = " + this.alignment + "\n" + c + this.text + c + ")\n";
    }

    public String toIndentedString(String indent) {
        char c = '\"';
        indent = indent + "  ";
        return TextImage.classNameString(indent, "TextImage") + TextImage.pinholeString(indent, this.pinhole) + TextImage.colorString(indent, this.color) + "\n" + indent + "this.size = " + this.size + "\n" + indent + "this.style = " + this.style + "\n" + indent + "this.alignment = " + this.alignment + "\n" + indent + c + this.text + c + ")\n";
    }

    public boolean equals(Object o) {
        if (o instanceof TextImage) {
            TextImage that = (TextImage)o;
            return this.pinhole.x == that.pinhole.x && this.pinhole.y == that.pinhole.y && this.size == that.size && this.style == that.style && this.alignment == that.alignment && this.text.equals(that.text) && this.color.equals(that.color);
        }
        return false;
    }

    public int hashCode() {
        return this.pinhole.x + this.pinhole.y + this.color.hashCode() + (int)this.size + this.style + this.alignment + this.text.hashCode();
    }
}

