/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import javalib.worldimages.Posn;
import javalib.worldimages.WorldImage;

public class OverlayImagesXY
extends WorldImage {
    public WorldImage bot;
    public WorldImage top;
    public int dx;
    public int dy;

    public OverlayImagesXY(WorldImage bot, WorldImage top, int dx, int dy) {
        super(bot.pinhole, Color.white);
        this.bot = bot;
        this.top = top;
        this.dx = dx;
        this.dy = dy;
        this.pinhole.x = (this.bot.pinhole.x + this.top.pinhole.x) / 2;
        this.pinhole.y = (this.bot.pinhole.y + this.top.pinhole.y) / 2;
    }

    public void draw(Graphics2D g) {
        if (this.color == null) {
            this.color = new Color(0, 0, 0);
        }
        Paint oldPaint = g.getPaint();
        g.setPaint(this.color);
        this.bot.draw(g);
        this.top.getMovedImage(this.dx, this.dy);
        this.top.draw(g);
        this.top.getMovedImage(-this.dx, -this.dy);
        g.setPaint(oldPaint);
    }

    public WorldImage getMovedImage(int ddx, int ddy) {
        return new OverlayImagesXY(this.bot.getMovedImage(ddx, ddy), this.top.getMovedImage(ddx, ddy), this.dx, this.dy);
    }

    public WorldImage getMovedTo(Posn p) {
        int dx = p.x - this.pinhole.x;
        int dy = p.y - this.pinhole.y;
        return this.getMovedImage(dx, dy);
    }

    public void movePinhole(int dx, int dy) {
        this.bot.movePinhole(dx, dy);
        this.top.movePinhole(dx, dy);
    }

    public void moveTo(Posn p) {
        int dx = p.x - this.pinhole.x;
        int dy = p.y - this.pinhole.y;
        this.movePinhole(dx, dy);
    }

    public int getWidth() {
        int leftBot = this.bot.pinhole.x - this.bot.getWidth() / 2;
        int leftTop = this.top.pinhole.x - this.top.getWidth() / 2;
        int rightBot = this.bot.pinhole.x + this.bot.getWidth() / 2;
        int rightTop = this.top.pinhole.x + this.top.getWidth() / 2;
        return Math.max(rightBot, rightTop) - Math.min(leftBot, leftTop);
    }

    public int getHeight() {
        int upperBot = this.bot.pinhole.y - this.bot.getHeight() / 2;
        int upperTop = this.top.pinhole.y - this.top.getHeight() / 2;
        int lowerBot = this.bot.pinhole.y + this.bot.getHeight() / 2;
        int lowerTop = this.top.pinhole.y + this.top.getHeight() / 2;
        return Math.max(lowerBot, lowerTop) - Math.min(upperBot, upperTop);
    }

    public String toString() {
        return "new OverlayImagesXY(this.pinhole = (" + this.pinhole.x + ", " + this.pinhole.y + "), \nthis.color = " + this.color.toString() + "\nthis.dx = " + this.dx + ", this.dy = " + this.dy + "," + "\nthis.bot = " + this.bot.toString() + "\nthis.top = " + this.top.toString() + ")\n";
    }

    public String toIndentedString(String indent) {
        indent = indent + "  ";
        return OverlayImagesXY.classNameString(indent, "OverlayImagesXY") + OverlayImagesXY.pinholeString(indent, this.pinhole) + "\n" + indent + "this.dx = " + this.dx + ", this.dy = " + this.dy + "\n" + indent + "this.bot = " + this.bot.toString() + "\n" + indent + "this.top = " + this.top.toString() + ")\n";
    }

    public boolean equals(Object o) {
        if (o instanceof OverlayImagesXY) {
            OverlayImagesXY that = (OverlayImagesXY)o;
            return this.pinhole.x == that.pinhole.x && this.pinhole.y == that.pinhole.y && this.bot.equals(that.bot) && this.top.equals(that.top) && this.dx == that.dx && this.dy == that.dy;
        }
        return false;
    }

    public int hashCode() {
        return this.pinhole.x + this.pinhole.y + this.color.hashCode() + this.dx + this.dy + this.bot.hashCode() + this.top.hashCode();
    }
}

