/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Ellipse2D;
import javalib.colors.IColor;
import javalib.worldimages.Posn;
import javalib.worldimages.WorldImage;

public class OvalImage
extends WorldImage {
    public int width;
    public int height;

    public OvalImage(Posn pinhole, int width, int height, Color color) {
        super(pinhole, color);
        this.width = width;
        this.height = height;
    }

    public OvalImage(Posn pinhole, int width, int height, IColor color) {
        super(pinhole, color);
        this.width = width;
        this.height = height;
    }

    public void draw(Graphics2D g) {
        if (this.width <= 0) {
            return;
        }
        if (this.height <= 0) {
            return;
        }
        if (this.color == null) {
            this.color = new Color(0, 0, 0);
        }
        Paint oldPaint = g.getPaint();
        g.setPaint(this.color);
        g.fill(new Ellipse2D.Double(this.pinhole.x - this.width / 2, this.pinhole.y - this.height / 2, this.width, this.height));
        g.setPaint(oldPaint);
    }

    public WorldImage getMovedImage(int dx, int dy) {
        return new OvalImage(new Posn(this.pinhole.x + dx, this.pinhole.y + dy), this.width, this.height, this.color);
    }

    public WorldImage getMovedTo(Posn p) {
        return new OvalImage(p, this.width, this.height, this.color);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String toString() {
        return "new OvalImage(this.pinhole = (" + this.pinhole.x + ", " + this.pinhole.y + "), \nthis.color = " + this.color.toString() + "\nthis.width = " + this.width + ", this.height = " + this.height + ")\n";
    }

    public String toIndentedString(String indent) {
        indent = indent + "  ";
        return OvalImage.classNameString(indent, "OvalImage") + OvalImage.pinholeString(indent, this.pinhole) + OvalImage.colorString(indent, this.color) + "\n" + indent + "this.width = " + this.width + ", this.height = " + this.height + ")\n";
    }

    public boolean equals(Object o) {
        if (o instanceof OvalImage) {
            OvalImage that = (OvalImage)o;
            return this.pinhole.x == that.pinhole.x && this.pinhole.y == that.pinhole.y && this.width == that.width && this.height == that.height && this.color.equals(that.color);
        }
        return false;
    }

    public int hashCode() {
        return this.pinhole.x + this.pinhole.y + this.color.hashCode() + this.width + this.height;
    }
}

