/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Line2D;
import javalib.colors.IColor;
import javalib.worldimages.Posn;
import javalib.worldimages.WorldImage;

public class LineImage
extends WorldImage {
    public Posn startPoint;
    public Posn endPoint;

    public LineImage(Posn startPoint, Posn endPoint, Color color) {
        super(startPoint, color);
        this.startPoint = new Posn(startPoint.x, startPoint.y);
        this.endPoint = new Posn(endPoint.x, endPoint.y);
        this.pinhole.x = (this.startPoint.x + this.endPoint.x) / 2;
        this.pinhole.y = (this.startPoint.y + this.endPoint.y) / 2;
    }

    public LineImage(Posn startPoint, Posn endPoint, IColor color) {
        this(startPoint, endPoint, color.thisColor());
    }

    public void draw(Graphics2D g) {
        if (this.color == null) {
            this.color = new Color(0, 0, 0);
        }
        Paint oldPaint = g.getPaint();
        g.setPaint(this.color);
        g.draw(new Line2D.Double(this.startPoint.x, this.startPoint.y, this.endPoint.x, this.endPoint.y));
        g.setPaint(oldPaint);
    }

    public WorldImage getMovedImage(int dx, int dy) {
        return new LineImage(this.movePosn(this.startPoint, dx, dy), this.movePosn(this.endPoint, dx, dy), this.color);
    }

    public WorldImage getMovedTo(Posn p) {
        int dx = p.x - this.pinhole.x;
        int dy = p.y - this.pinhole.y;
        return this.getMovedImage(dx, dy);
    }

    public void movePinhole(int dx, int dy) {
        this.pinhole.x += dx;
        this.pinhole.y += dy;
        this.startPoint.x += dx;
        this.startPoint.y += dy;
        this.endPoint.x += dx;
        this.endPoint.y += dy;
    }

    public void moveTo(Posn p) {
        int dx = p.x - this.pinhole.x;
        int dy = p.y - this.pinhole.y;
        this.movePinhole(dx, dy);
    }

    public int getWidth() {
        return Math.abs(this.startPoint.x - this.endPoint.x);
    }

    public int getHeight() {
        return Math.abs(this.startPoint.y - this.endPoint.y);
    }

    public String toString() {
        return "new LineImage(this.pinhole = (" + this.pinhole.x + ", " + this.pinhole.y + "), \nthis.color = " + this.color.toString() + "\nthis.startPoint = (" + this.startPoint.x + ", " + this.startPoint.y + "), \nthis.endPoint = (" + this.endPoint.x + ", " + this.endPoint.y + "))\n";
    }

    public String toIndentedString(String indent) {
        indent = indent + "  ";
        return LineImage.classNameString(indent, "LineImage") + LineImage.pinholeString(indent, this.pinhole) + LineImage.colorString(indent, this.color) + "\n" + indent + "this.startPoint = (" + this.startPoint.x + ", " + this.startPoint.y + "), \n" + indent + "this.endPoint = (" + this.endPoint.x + ", " + this.endPoint.y + "))\n";
    }

    public boolean equals(Object o) {
        if (o instanceof LineImage) {
            LineImage that = (LineImage)o;
            return this.pinhole.x == that.pinhole.x && this.pinhole.y == that.pinhole.y && this.startPoint.x == that.startPoint.x && this.startPoint.y == that.startPoint.y && this.endPoint.x == that.endPoint.x && this.endPoint.y == that.endPoint.y && this.color.equals(that.color);
        }
        return false;
    }

    public int hashCode() {
        return this.pinhole.x + this.pinhole.y + this.color.hashCode() + this.startPoint.x + this.startPoint.y + this.endPoint.x + this.endPoint.y;
    }
}

