/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.io.IOException;
import java.net.URL;
import javalib.worldimages.ImageMaker;
import javax.imageio.ImageIO;

public class ImageMakerApplet
extends ImageMaker {
    public ImageMakerApplet(String filename) {
        URL url = this.getClass().getResource("/" + filename);
        try {
            if (url == null) {
                throw new IOException("file /" + filename + " not found");
            }
            String abs = url.getFile();
            if (loadedImages.containsKey(abs)) {
                this.image = (BufferedImage)loadedImages.get(abs);
                this.width = this.image.getWidth();
                this.height = this.image.getHeight();
            } else {
                this.imageSource = ImageIO.read(url);
                this.width = this.imageSource.getWidth();
                this.height = this.imageSource.getHeight();
                this.cmodel = this.imageSource.getColorModel();
                this.image = new BufferedImage(this.width, this.height, 2);
                this.colorOp = new ColorConvertOp(this.cmodel.getColorSpace(), this.image.getColorModel().getColorSpace(), null);
                this.colorOp.filter(this.imageSource, this.image);
                loadedImages.put(abs, this.image);
            }
        }
        catch (IOException e) {
            System.out.println("Could not open the file");
        }
    }
}

