/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import javalib.worldimages.ImageMaker;
import javalib.worldimages.ImageMakerApplet;
import javalib.worldimages.Posn;
import javalib.worldimages.WorldImage;

public class FromFileImage
extends WorldImage {
    public static boolean isApplet = false;
    public String fileName;
    protected volatile ImageMaker imread;
    protected transient AffineTransform at;

    public FromFileImage(Posn pinhole, String fileName) {
        super(pinhole, Color.white);
        this.imread = isApplet ? new ImageMakerApplet(fileName) : new ImageMaker(fileName);
        this.fileName = fileName;
        this.at = AffineTransform.getTranslateInstance(this.pinhole.x - this.imread.width / 2, this.pinhole.y - this.imread.height / 2);
    }

    public void draw(Graphics2D g) {
        this.at = AffineTransform.getTranslateInstance(this.pinhole.x - this.imread.width / 2, this.pinhole.y - this.imread.height / 2);
        Paint oldPaint = g.getPaint();
        g.drawRenderedImage(this.imread.image, this.at);
        g.setPaint(oldPaint);
    }

    public boolean same(FromFileImage that) {
        return this.fileName.equals(that.fileName) && this.pinhole.x == that.pinhole.x && this.pinhole.y == that.pinhole.y;
    }

    public WorldImage getMovedImage(int dx, int dy) {
        return new FromFileImage(this.movePosn(this.pinhole, dx, dy), this.fileName);
    }

    public WorldImage getMovedTo(Posn p) {
        int dx = p.x - this.pinhole.x;
        int dy = p.y - this.pinhole.y;
        return this.getMovedImage(dx, dy);
    }

    public int getWidth() {
        return this.imread.width;
    }

    public int getHeight() {
        return this.imread.height;
    }

    public String toString() {
        return "new FromFileImage(this.pinhole = (" + this.pinhole.x + ", " + this.pinhole.y + ")\nthis.fileName = " + this.fileName + ")\n";
    }

    public String toIndentedString(String indent) {
        indent = indent + "  ";
        return FromFileImage.classNameString(indent, "FromFileImage") + FromFileImage.pinholeString(indent, this.pinhole) + ")\n" + indent + "this.fileName = " + this.fileName + ")\n";
    }

    public boolean equals(Object o) {
        if (o instanceof FromFileImage) {
            FromFileImage that = (FromFileImage)o;
            return this.same(that);
        }
        return false;
    }

    public int hashCode() {
        return this.pinhole.x + this.pinhole.y + this.color.hashCode() + this.fileName.hashCode();
    }
}

