/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Ellipse2D;
import javalib.colors.IColor;
import javalib.worldimages.Posn;
import javalib.worldimages.WorldImage;

public class CircleImage
extends WorldImage {
    public int radius;

    public CircleImage(Posn pinhole, int radius, Color color) {
        super(pinhole, color);
        this.radius = radius;
    }

    public CircleImage(Posn pinhole, int radius, IColor color) {
        super(pinhole, color);
        this.radius = radius;
    }

    public void draw(Graphics2D g) {
        if (this.radius <= 0) {
            return;
        }
        if (this.color == null) {
            this.color = new Color(0, 0, 0);
        }
        Paint oldPaint = g.getPaint();
        g.setPaint(this.color);
        g.draw(new Ellipse2D.Double(this.pinhole.x - this.radius, this.pinhole.y - this.radius, 2 * this.radius, 2 * this.radius));
        g.setPaint(oldPaint);
    }

    public WorldImage getMovedImage(int dx, int dy) {
        return new CircleImage(new Posn(this.pinhole.x + dx, this.pinhole.y + dy), this.radius, this.color);
    }

    public WorldImage getMovedTo(Posn p) {
        return new CircleImage(p, this.radius, this.color);
    }

    public int getWidth() {
        return 2 * this.radius;
    }

    public int getHeight() {
        return 2 * this.radius;
    }

    public String toString() {
        return "new CircleImage(this.pinhole = (" + this.pinhole.x + ", " + this.pinhole.y + "), \nthis.color = " + this.color.toString() + "\nthis.radius = " + this.radius + ")\n";
    }

    public String toIndentedString(String indent) {
        indent = indent + "  ";
        return CircleImage.classNameString(indent, "CircleImage") + CircleImage.pinholeString(indent, this.pinhole) + CircleImage.colorString(indent, this.color) + "\n" + indent + "this.radius = " + this.radius + ")\n";
    }

    public boolean equals(Object o) {
        if (o instanceof CircleImage) {
            CircleImage that = (CircleImage)o;
            return this.pinhole.x == that.pinhole.x && this.pinhole.y == that.pinhole.y && this.radius == that.radius && this.color.equals(that.color);
        }
        return false;
    }

    public int hashCode() {
        return this.pinhole.x + this.pinhole.y + this.color.hashCode() + this.radius;
    }
}

