/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldcanvas;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javalib.colors.Black;
import javalib.colors.Blue;
import javalib.colors.Green;
import javalib.colors.Red;
import javalib.worldcanvas.CanvasPanel;
import javalib.worldimages.CircleImage;
import javalib.worldimages.ImageMaker;
import javalib.worldimages.Posn;
import javalib.worldimages.WorldImage;
import javax.swing.JFrame;

public class WorldCanvas {
    protected static int WINDOWS_OPEN = 0;
    public transient JFrame f;
    public transient CanvasPanel panel;
    protected int width;
    protected int height;
    protected transient WindowAdapter winapt = new WindowAdapter(){

        public void windowClosing(WindowEvent e) {
            WorldCanvas.this.panel.clearPanel();
            if (--WINDOWS_OPEN == 0) {
                System.exit(0);
            }
        }
    };

    public WorldCanvas(int width, int height, String title) {
        this.width = width;
        this.height = height;
        this.f = new JFrame(title);
        this.f.setLayout(new BorderLayout());
        this.f.addWindowListener(this.winapt);
        this.f.setDefaultCloseOperation(1);
        this.panel = new CanvasPanel(width, height);
        this.panel.addNotify();
        this.f.getContentPane().add((Component)this.panel, "Center");
        this.f.pack();
        Graphics g = this.panel.getGraphics();
        this.f.update(g);
        this.f.setVisible(false);
    }

    public WorldCanvas(int width, int height) {
        this(width, height, "Canvas");
    }

    public final Graphics2D getBufferGraphics() {
        return this.panel.getBufferGraphics();
    }

    public boolean drawImage(String fileName, Posn nw) {
        this.panel.drawImage(fileName, nw.x, nw.y);
        return true;
    }

    public boolean drawImage(ImageMaker image, Posn nw) {
        this.panel.drawImagePixels(image, nw.x, nw.y);
        return true;
    }

    public boolean drawImage(WorldImage image) {
        this.panel.drawImage(image);
        return true;
    }

    public void printCurrentFont() {
        this.panel.getFont();
    }

    public boolean show() {
        if (!this.f.isVisible()) {
            ++WINDOWS_OPEN;
            this.f.setVisible(true);
            return true;
        }
        return true;
    }

    public boolean close() {
        if (this.f.isVisible()) {
            --WINDOWS_OPEN;
            this.f.setVisible(false);
            this.panel.clearPanel();
        }
        return true;
    }

    public void clear() {
        this.panel.clearPanel();
    }

    private static void nextStep(String message) {
        try {
            System.out.println(message);
            System.out.println("Press RETURN");
            int n = System.in.read();
        }
        catch (IOException e) {
            System.out.println("Next step");
        }
    }

    public String toString() {
        return "new Canvas(" + this.width + ", " + this.height + ")";
    }

    public String toIndentedString(String indent) {
        return "new Canvas(" + this.width + ", " + this.height + ")";
    }

    public static void main(String[] argv) {
        WorldCanvas.nextStep("Canvas with default name is constructed");
        WorldCanvas sm1 = new WorldCanvas(200, 200);
        WorldCanvas.nextStep("To show the canvas ... ");
        sm1.show();
        WorldCanvas.nextStep("Canvas shown - should be blank - add red and blue disk");
        sm1.drawImage(new CircleImage(new Posn(50, 50), 20, new Red()));
        sm1.drawImage(new CircleImage(new Posn(150, 50), 50, new Blue()));
        WorldCanvas.nextStep("Show the canvas again - it should not do anything");
        sm1.show();
        WorldCanvas.nextStep("Draw a green disk");
        sm1.drawImage(new CircleImage(new Posn(50, 150), 50, new Green()));
        WorldCanvas.nextStep("Close the Canvas");
        sm1.close();
        WorldCanvas.nextStep("Show the canvas again - it should be cleared");
        sm1.show();
        WorldCanvas.nextStep("Paint one disks on the canvas");
        sm1.drawImage(new CircleImage(new Posn(50, 150), 25, new Black()));
        WorldCanvas.nextStep("Construct a second canvas with the name Smiley");
        WorldCanvas sm2 = new WorldCanvas(200, 200, "Smiley");
        WorldCanvas.nextStep("Show the second canvas");
        sm2.show();
        WorldCanvas.nextStep("Paint two disks on the Smiley canvas");
        sm2.drawImage(new CircleImage(new Posn(50, 50), 20, new Red()));
        sm2.drawImage(new CircleImage(new Posn(150, 150), 50, new Blue()));
        WorldCanvas.nextStep("Manually close the 'Canvas' windowand see if we can bring it back to life");
        sm1.show();
        WorldCanvas.nextStep("The first canvas should be shown - cleared");
        sm1.drawImage(new CircleImage(new Posn(50, 50), 30, new Red()));
        sm1.drawImage(new CircleImage(new Posn(150, 50), 30, new Blue()));
        sm1.drawImage(new CircleImage(new Posn(50, 150), 30, new Green()));
        WorldCanvas.nextStep("The first canvas has three disks drawn");
        System.out.println("Close both canvas windows to end the program");
    }
}

