/*
 * Decompiled with CFR 0.152.
 */
package javalib.tunes;

import java.util.ArrayList;
import javalib.tunes.Chord;
import javalib.tunes.MusicBox;
import javalib.tunes.Note;
import javalib.tunes.SoundConstants;
import javalib.tunes.Tune;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TuneBucket
implements SoundConstants {
    public ArrayList<Tune> tunes;
    protected volatile MusicBox musicBox;
    protected volatile int[] channels = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public TuneBucket(MusicBox musicBox, int[] channels) {
        this.tunes = new ArrayList();
        this.musicBox = musicBox;
        this.musicBox.initChannels(channels);
        this.recordProgramChange(channels);
        this.initTunes();
    }

    public TuneBucket(MusicBox musicBox) {
        this.tunes = new ArrayList();
        this.musicBox = musicBox;
        this.initTunes();
        this.initChannels();
    }

    public TuneBucket(int[] channels) {
        this.tunes = new ArrayList();
        this.musicBox = null;
        this.initTunes();
        this.recordProgramChange(channels);
    }

    public TuneBucket() {
        this.tunes = new ArrayList();
        this.musicBox = null;
        this.initTunes();
        this.initChannels();
    }

    public void recordProgramChange(int[] channels) {
        for (int i = 0; i < 16; ++i) {
            channels[i] = channels[i];
        }
    }

    public void initTunes() {
        for (int i = 0; i < 16; ++i) {
            this.tunes.add(new Tune(i));
        }
    }

    public void initChannels() {
        for (int i = 0; i < 16; ++i) {
            this.channels[i] = instruments[i];
        }
    }

    public void add(TuneBucket tb) {
        for (int i = 0; i < 16; ++i) {
            this.tunes.get(i).addChord(tb.tunes.get((int)i).chord.copyChord());
        }
    }

    public void addNote(int channel, int pitch) {
        this.tunes.get(channel).addNote(new Note(pitch));
    }

    public void addNote(int channel, Note note) {
        this.tunes.get(channel).addNote(new Note(note.snote));
    }

    public void addNote(int channel, String snote) {
        this.tunes.get(channel).addNote(new Note(snote));
    }

    public void addChord(int channel, Chord chord) {
        this.tunes.get(channel).addChord(chord.copy());
    }

    public void addTunes(Iterable<Tune> tunes) {
        for (Tune tune : tunes) {
            this.tunes.get(tune.channel).addChord(tune.chord);
        }
    }

    public void addTune(Tune tune) {
        this.tunes.get(tune.channel).addChord(tune.chord);
    }

    public void clearBucket() {
        if (this.musicBox != null) {
            this.musicBox.playOff(this.tunes);
        }
        this.clearTunes();
    }

    public void clearTunes() {
        for (Tune tune : this.tunes) {
            tune.clearChord();
        }
    }

    public void removeSilent() {
        for (Tune tune : this.tunes) {
            tune.removeSilent();
        }
    }

    public void nextBeat() {
        for (Tune tune : this.tunes) {
            Chord stopPlay = tune.chord.nextBeat();
            if (this.musicBox == null) continue;
            this.musicBox.stopTune(new Tune(tune.channel, stopPlay));
        }
    }

    public void skipBeat() {
        for (Tune tune : this.tunes) {
            tune.chord.skipBeat();
        }
    }

    public void playTunes() {
        if (this.musicBox != null) {
            for (Tune tune : this.tunes) {
                this.musicBox.playTune(tune);
                tune.removeSilent();
            }
        } else {
            for (Tune tune : this.tunes) {
                tune.chord.nextBeat();
            }
        }
    }

    public TuneBucket copy() {
        TuneBucket newCopy = new TuneBucket(this.musicBox);
        for (Tune t : this.tunes) {
            newCopy.addChord(t.channel, t.chord.copy());
        }
        return newCopy;
    }

    public int bucketSize() {
        int count = 0;
        for (Tune t : this.tunes) {
            count += t.size();
        }
        return count;
    }

    public boolean contains(int channel, Note note) {
        for (Tune t : this.tunes) {
            if (t.channel != channel || !t.chord.containsNote(note)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(int channel, int pitch) {
        for (Tune t : this.tunes) {
            if (t.channel != channel || !t.chord.containsNote(pitch)) continue;
            return true;
        }
        return false;
    }

    public String toXString() {
        String result = "Tune bucket: size = " + this.bucketSize() + "\n";
        for (int i = 0; i < 16; ++i) {
            Tune t = this.tunes.get(i);
            String instrument = this.musicBox != null ? instrumentNames[this.musicBox.program[t.channel]] : instrumentNames[this.channels[i]];
            result = result + "[" + i + "]: " + t.toString(instrument) + "\n";
        }
        return result + "\n";
    }

    public String toString() {
        return this.toIndentedString("");
    }

    public String toIndentedString(String indent) {
        String result = "Tune bucket: \n" + indent + "size = " + this.bucketSize() + "\n";
        for (int i = 0; i < 16; ++i) {
            Tune t = this.tunes.get(i);
            String instrument = this.musicBox != null ? instrumentNames[this.musicBox.program[t.channel]] : instrumentNames[this.channels[i]];
            result = result + indent + "  [" + i + "]: " + t.toString(instrument) + "\n";
        }
        return result + "\n";
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof TuneBucket)) {
            return false;
        }
        TuneBucket that = (TuneBucket)o;
        if (this.tunes.size() != that.tunes.size()) {
            return false;
        }
        if (this.musicBox != null && that.musicBox != null && !this.musicBox.equals(that.musicBox)) {
            return false;
        }
        for (int i = 0; i < 16; ++i) {
            if (this.channels[i] != that.channels[i]) {
                return false;
            }
            if (this.tunes.get(i).equals(that.tunes.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.channels.hashCode() + this.tunes.hashCode();
    }
}

