/*
 * Decompiled with CFR 0.152.
 */
package javalib.tunes;

import javalib.tunes.Chord;
import javalib.tunes.Note;
import javalib.tunes.SoundConstants;

public class Tune
implements SoundConstants {
    protected int channel;
    protected Chord chord;

    public Tune(int channel, Chord chord) {
        if (channel < 0) {
            channel = 0;
        } else if (channel > 15) {
            channel = 15;
        }
        this.channel = channel;
        this.chord = chord;
    }

    public int getChannel() {
        return this.channel;
    }

    public Chord getChord() {
        return this.chord;
    }

    public Tune(int channel) {
        this(channel, new Chord());
    }

    public Tune(int channel, Note note) {
        this(channel);
        this.chord.addNote(note);
    }

    public void addNote(Note note) {
        this.chord.addNote(new Note(note.snote));
    }

    public void addChord(Chord myChord) {
        for (Note note : myChord.notes) {
            this.chord.addNote(note);
        }
    }

    public String toString() {
        return this.toIndentedString("");
    }

    public String toIndentedString(String indent) {
        if (!this.chord.notes.isEmpty()) {
            String header = "Channel: " + this.channel + "\n";
            String notes = "";
            for (Note n : this.chord.notes) {
                notes = notes + indent + "  note: " + n.snote + " pitch: " + n.pitch + ", duration: " + n.duration + "\n";
            }
            return header + notes;
        }
        return "Channel: " + this.channel + "\n";
    }

    public String toString(String instrument) {
        String tuneString = instrument + "(";
        for (Note n : this.chord.notes) {
            tuneString = tuneString + n.snote + ", ";
        }
        if (this.chord.notes.size() == 0) {
            return tuneString + ")";
        }
        return tuneString.substring(0, tuneString.length() - 2) + ")";
    }

    public boolean isSilent() {
        return this.chord.isSilent();
    }

    public void removeSilent() {
        this.chord.removeSilent();
    }

    public void clearChord() {
        this.chord = new Chord();
    }

    public int size() {
        return this.chord.size();
    }

    public boolean containsNote(Note n) {
        return this.chord.containsNote(n);
    }

    public boolean equals(Object o) {
        if (o instanceof Tune) {
            Tune that = (Tune)o;
            if (this.channel == that.channel) {
                return this.chord.equals(that.chord);
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.channel + this.chord.hashCode();
    }
}

