/*
 * Decompiled with CFR 0.152.
 */
package javalib.tunes;

import java.util.ArrayList;
import javalib.tunes.Chord;
import javalib.tunes.Note;
import javalib.tunes.SoundConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Melody
implements SoundConstants {
    ArrayList<Chord> chords;
    int current;
    int size;

    Melody() {
        this.chords = new ArrayList();
        this.current = 0;
        this.size = this.chords.size();
    }

    Melody(ArrayList<Chord> chords) {
        this.chords = chords;
        this.current = 0;
        this.size = this.chords.size();
    }

    public void initMelody(ArrayList<Note> notes) {
        this.chords = new ArrayList();
        this.current = 0;
        for (Note note : notes) {
            this.chords.add(new Chord(note));
        }
        this.size = this.chords.size();
    }

    Chord next() {
        if (this.size == 0) {
            throw new RuntimeException("No notes to play");
        }
        Chord tmp = this.chords.get(this.current);
        this.current = (this.current + 1) % this.size;
        return tmp;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Melody)) {
            return false;
        }
        Melody that = (Melody)o;
        if (this.size != that.size) {
            return false;
        }
        if (this.current != that.current) {
            return false;
        }
        for (int i = 0; i < 16; ++i) {
            if (this.chords.get(i).equals(that.chords.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.size * this.current;
        for (Chord c : this.chords) {
            hash += c.hashCode();
        }
        return hash;
    }
}

