/*
 * Decompiled with CFR 0.152.
 */
package javalib.soundworld;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javalib.soundworld.World;

class MyKeyAdapter
extends KeyAdapter {
    protected World currentWorld;

    protected MyKeyAdapter(World currentWorld) {
        this.currentWorld = currentWorld;
    }

    protected void keyEventCallback(String keyString) {
        this.currentWorld.processKeyEvent(keyString);
    }

    protected void keyReleasedEventCallback(String keyString) {
        this.currentWorld.processKeyReleasedEvent(keyString);
    }

    public void keyTyped(KeyEvent e) {
        this.displayInfo(e, "KEY TYPED: ");
    }

    public void keyPressed(KeyEvent e) {
        this.displayInfo(e, "KEY PRESSED: ");
    }

    public void keyReleased(KeyEvent e) {
        this.displayInfo(e, "KEY RELEASED: ");
    }

    protected void displayInfo(KeyEvent e, String s) {
        String keyString = "";
        int id = e.getID();
        if (id == 401 || id == 402) {
            int keyCode = e.getKeyCode();
            if (keyCode == 37) {
                keyString = "left";
            } else if (keyCode == 38) {
                keyString = "up";
            } else if (keyCode == 39) {
                keyString = "right";
            } else if (keyCode == 40) {
                keyString = "down";
            } else {
                char c = e.getKeyChar();
                keyString = "" + c;
            }
        }
        if (keyString.length() != 0) {
            if (id == 401) {
                this.keyEventCallback(keyString);
            } else if (id == 402) {
                this.keyReleasedEventCallback(keyString);
            }
        }
    }
}

