/*
 * Decompiled with CFR 0.152.
 */
package javalib.impworld;

import java.awt.Color;
import java.awt.event.WindowListener;
import javalib.impworld.MyKeyAdapter;
import javalib.impworld.MyMouseAdapter;
import javalib.impworld.MyTimer;
import javalib.impworld.MyWindowClosingListener;
import javalib.worldcanvas.WorldCanvas;
import javalib.worldimages.CircleImage;
import javalib.worldimages.Posn;
import javalib.worldimages.WorldEnd;
import javalib.worldimages.WorldImage;

public abstract class World {
    public WorldCanvas theCanvas;
    private transient boolean worldExists = false;
    protected transient MyTimer mytime;
    protected transient boolean stopTimer = false;
    private transient MyKeyAdapter ka;
    private transient MyMouseAdapter ma;
    private transient WindowListener windowClosing;
    private transient WorldImage blankImage = new CircleImage(new Posn(0, 0), 1, Color.white);
    public WorldEnd lastWorld = new WorldEnd(false, this.blankImage);

    public void bigBang(int w, int h, double speed) {
        if (this.worldExists) {
            System.out.println("Only one world can run at a time");
            return;
        }
        this.theCanvas = new WorldCanvas(w, h);
        this.theCanvas.f.setDefaultCloseOperation(2);
        this.windowClosing = new MyWindowClosingListener(this);
        this.theCanvas.f.addWindowListener(this.windowClosing);
        long start = System.currentTimeMillis();
        long tmp = System.currentTimeMillis();
        while (tmp - start < 1000L) {
            tmp = System.currentTimeMillis();
        }
        this.ka = new MyKeyAdapter(this);
        this.theCanvas.f.addKeyListener(this.ka);
        this.ma = new MyMouseAdapter(this);
        this.theCanvas.f.addMouseListener(this.ma);
        this.theCanvas.f.setFocusable(true);
        this.theCanvas.show();
        this.drawWorld("");
        start = System.currentTimeMillis();
        tmp = System.currentTimeMillis();
        while (tmp - start < 1000L) {
            tmp = System.currentTimeMillis();
        }
        this.mytime = new MyTimer(this, speed);
        if (speed > 0.0) {
            this.mytime.timer.start();
        }
        this.worldExists = true;
        this.drawWorld("");
        System.out.println("impworld version 1.0 --- 26 June  2012\n-----------------------------------------\n");
    }

    public void bigBang(int w, int h) {
        this.bigBang(w, h, 0.0);
    }

    protected void stopWorld() {
        if (this.worldExists) {
            this.mytime.timer.stop();
            this.worldExists = false;
            this.mytime.stopTimer();
            this.theCanvas.f.removeKeyListener(this.ka);
            this.theCanvas.f.removeMouseListener(this.ma);
            System.out.println("The world stopped.");
            this.theCanvas.clear();
            this.theCanvas.drawImage(this.lastWorld.lastImage);
        }
    }

    public WorldEnd worldEnds() {
        return new WorldEnd(false, this.makeImage());
    }

    public void endOfWorld(String s) {
        this.lastWorld = new WorldEnd(true, this.lastImage(s));
        this.stopWorld();
    }

    public void testOnTick() {
        this.lastWorld = this.worldEnds();
        if (this.lastWorld.worldEnds) {
            this.stopWorld();
        }
        this.processTick();
    }

    protected synchronized void processTick() {
        try {
            if (this.worldExists && !this.stopTimer) {
                this.lastWorld = this.worldEnds();
                if (this.lastWorld.worldEnds) {
                    this.stopWorld();
                } else {
                    this.onTick();
                    this.drawWorld("");
                }
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.drawWorld("");
            Runtime.getRuntime().halt(1);
        }
    }

    public void onTick() {
    }

    protected synchronized void processKeyEvent(String ke) {
        try {
            if (this.worldExists) {
                this.onKeyEvent(ke);
                if (!this.lastWorld.worldEnds) {
                    this.drawWorld("");
                } else {
                    this.theCanvas.drawImage(this.lastWorld.lastImage);
                }
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.drawWorld("");
            Runtime.getRuntime().halt(1);
        }
    }

    public void onKeyEvent(String s) {
    }

    protected void processMouseClicked(Posn mouse) {
        try {
            if (this.worldExists) {
                this.onMouseClicked(mouse);
                if (!this.lastWorld.worldEnds) {
                    this.drawWorld("");
                } else {
                    this.theCanvas.drawImage(this.lastWorld.lastImage);
                }
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.drawWorld("");
            Runtime.getRuntime().halt(1);
        }
    }

    public void onMouseClicked(Posn mouse) {
    }

    protected void processMouseEntered(Posn mouse) {
        try {
            if (this.worldExists) {
                this.onMouseEntered(mouse);
                if (!this.lastWorld.worldEnds) {
                    this.drawWorld("");
                } else {
                    this.theCanvas.drawImage(this.lastWorld.lastImage);
                }
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.drawWorld("");
            Runtime.getRuntime().halt(1);
        }
    }

    public void onMouseEntered(Posn mouse) {
    }

    protected void processMouseExited(Posn mouse) {
        try {
            if (this.worldExists) {
                this.onMouseExited(mouse);
                if (!this.lastWorld.worldEnds) {
                    this.drawWorld("");
                } else {
                    this.theCanvas.drawImage(this.lastWorld.lastImage);
                }
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.drawWorld("");
            Runtime.getRuntime().halt(1);
        }
    }

    public void onMouseExited(Posn mouse) {
    }

    protected void processMousePressed(Posn mouse) {
        try {
            if (this.worldExists) {
                this.onMousePressed(mouse);
                if (!this.lastWorld.worldEnds) {
                    this.drawWorld("");
                } else {
                    this.theCanvas.drawImage(this.lastWorld.lastImage);
                }
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.drawWorld("");
            Runtime.getRuntime().halt(1);
        }
    }

    public void onMousePressed(Posn mouse) {
    }

    protected void processMouseReleased(Posn mouse) {
        try {
            if (this.worldExists) {
                this.onMouseReleased(mouse);
                if (!this.lastWorld.worldEnds) {
                    this.drawWorld("");
                } else {
                    this.theCanvas.drawImage(this.lastWorld.lastImage);
                }
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.drawWorld("");
            Runtime.getRuntime().halt(1);
        }
    }

    public void onMouseReleased(Posn mouse) {
    }

    protected synchronized void drawWorld(String s) {
        if (this.worldExists) {
            this.theCanvas.clear();
            this.theCanvas.drawImage(this.makeImage());
        } else {
            this.theCanvas.clear();
            this.theCanvas.drawImage(this.lastImage(s));
        }
    }

    public abstract WorldImage makeImage();

    public WorldImage lastImage(String s) {
        return this.makeImage();
    }
}

