/*
 * Decompiled with CFR 0.152.
 */
package javalib.appletworld;

import java.awt.Color;
import javalib.appletworld.MyKeyAdapter;
import javalib.appletworld.MyMouseAdapter;
import javalib.appletworld.MyTimer;
import javalib.worldcanvas.AppletCanvas;
import javalib.worldimages.CircleImage;
import javalib.worldimages.FromFileImage;
import javalib.worldimages.Posn;
import javalib.worldimages.WorldEnd;
import javalib.worldimages.WorldImage;
import javax.swing.JButton;

public abstract class World {
    protected transient AppletCanvas theCanvas;
    protected boolean worldExists = false;
    protected transient MyTimer mytime;
    protected transient boolean stopTimer = false;
    protected transient MyKeyAdapter ka;
    private transient MyMouseAdapter ma;
    protected transient JButton bigButton;
    private transient WorldImage blankImage = new CircleImage(new Posn(0, 0), 1, Color.white);
    public WorldEnd lastWorld = new WorldEnd(false, this.blankImage);

    public World() {
        FromFileImage.isApplet = true;
    }

    protected void initWorld(AppletCanvas theCanvas, JButton bigButton) {
        this.theCanvas = theCanvas;
        this.bigButton = bigButton;
    }

    public void bigBang(int w, int h, double speed) {
        if (this.worldExists) {
            System.out.println("Only one world can run at a time");
            return;
        }
        this.worldExists = true;
        long start = System.currentTimeMillis();
        long tmp = System.currentTimeMillis();
        while (tmp - start < 1000L) {
            tmp = System.currentTimeMillis();
        }
        this.theCanvas.painter.setSize(w, h);
        this.ka = new MyKeyAdapter(this);
        this.theCanvas.painter.addKeyListener(this.ka);
        this.ma = new MyMouseAdapter(this);
        this.theCanvas.painter.addMouseListener(this.ma);
        this.theCanvas.setFocusable(true);
        this.theCanvas.setVisible(true);
        this.drawWorld("");
        start = System.currentTimeMillis();
        tmp = System.currentTimeMillis();
        while (tmp - start < 1000L) {
            tmp = System.currentTimeMillis();
        }
        this.mytime = new MyTimer(this, speed);
        if (speed > 0.0) {
            this.mytime.timer.start();
        }
        this.worldExists = true;
        this.drawWorld("");
        System.out.println("appletworld version 1.0 --- 26 June 2012\n-----------------------------------------\n");
    }

    public void bigBang(int w, int h) {
        this.bigBang(w, h, 0.0);
    }

    protected void stopWorld() {
        if (this.worldExists) {
            this.mytime.timer.stop();
            this.worldExists = false;
            this.mytime.stopTimer();
            this.theCanvas.painter.removeKeyListener(this.ka);
            this.theCanvas.painter.removeMouseListener(this.ma);
            this.theCanvas.clear();
            this.theCanvas.drawImage(this.lastWorld.lastImage);
        }
    }

    public WorldEnd worldEnds() {
        return new WorldEnd(false, this.makeImage());
    }

    public void endOfWorld(String s) {
        this.lastWorld = new WorldEnd(true, this.lastImage(s));
        this.stopWorld();
    }

    public void testOnTick() {
        this.lastWorld = this.worldEnds();
        if (this.lastWorld.worldEnds) {
            this.stopWorld();
        }
        this.processTick();
    }

    protected synchronized void processTick() {
        try {
            if (this.worldExists && !this.stopTimer) {
                this.lastWorld = this.worldEnds();
                if (this.lastWorld.worldEnds) {
                    this.stopWorld();
                } else {
                    this.onTick();
                    this.drawWorld("");
                }
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.drawWorld("");
            Runtime.getRuntime().halt(1);
        }
    }

    public void onTick() {
    }

    protected synchronized void processKeyEvent(String ke) {
        try {
            if (this.worldExists) {
                this.onKeyEvent(ke);
                if (!this.lastWorld.worldEnds) {
                    this.drawWorld("");
                } else {
                    this.theCanvas.drawImage(this.lastWorld.lastImage);
                }
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.drawWorld("");
            Runtime.getRuntime().halt(1);
        }
    }

    public void onKeyEvent(String s) {
    }

    protected void processMouseClicked(Posn mouse) {
        try {
            if (this.worldExists) {
                this.onMouseClicked(mouse);
                if (!this.lastWorld.worldEnds) {
                    this.drawWorld("");
                } else {
                    this.theCanvas.drawImage(this.lastWorld.lastImage);
                }
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.drawWorld("");
            Runtime.getRuntime().halt(1);
        }
    }

    public void onMouseClicked(Posn mouse) {
    }

    protected void processMouseEntered(Posn mouse) {
        try {
            if (this.worldExists) {
                this.onMouseEntered(mouse);
                if (!this.lastWorld.worldEnds) {
                    this.drawWorld("");
                } else {
                    this.theCanvas.drawImage(this.lastWorld.lastImage);
                }
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.drawWorld("");
            Runtime.getRuntime().halt(1);
        }
    }

    public void onMouseEntered(Posn mouse) {
    }

    protected void processMouseExited(Posn mouse) {
        try {
            if (this.worldExists) {
                this.onMouseExited(mouse);
                if (!this.lastWorld.worldEnds) {
                    this.drawWorld("");
                } else {
                    this.theCanvas.drawImage(this.lastWorld.lastImage);
                }
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.drawWorld("");
            Runtime.getRuntime().halt(1);
        }
    }

    public void onMouseExited(Posn mouse) {
    }

    protected void processMousePressed(Posn mouse) {
        try {
            if (this.worldExists) {
                this.onMousePressed(mouse);
                if (!this.lastWorld.worldEnds) {
                    this.drawWorld("");
                } else {
                    this.theCanvas.drawImage(this.lastWorld.lastImage);
                }
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.drawWorld("");
            Runtime.getRuntime().halt(1);
        }
    }

    public void onMousePressed(Posn mouse) {
    }

    protected void processMouseReleased(Posn mouse) {
        try {
            if (this.worldExists) {
                this.onMouseReleased(mouse);
                if (!this.lastWorld.worldEnds) {
                    this.drawWorld("");
                } else {
                    this.theCanvas.drawImage(this.lastWorld.lastImage);
                }
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.drawWorld("");
            Runtime.getRuntime().halt(1);
        }
    }

    public void onMouseReleased(Posn mouse) {
    }

    protected synchronized void drawWorld(String s) {
        if (this.worldExists) {
            this.theCanvas.clear();
            this.theCanvas.drawImage(this.makeImage());
        } else {
            this.theCanvas.clear();
            this.theCanvas.drawImage(this.lastImage(s));
        }
    }

    public abstract WorldImage makeImage();

    public WorldImage lastImage(String s) {
        return this.makeImage();
    }
}

