/*
 * Decompiled with CFR 0.152.
 */
package javalib.appletsoundworld;

import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javalib.appletsoundworld.World;
import javalib.worldimages.Posn;

class MyMouseAdapter
extends MouseAdapter {
    protected World currentWorld;
    protected Posn mousePosn;

    protected MyMouseAdapter(World currentWorld) {
        this.currentWorld = currentWorld;
    }

    Posn adjustMousePosn(Posn mousePosn) {
        Insets ins = this.currentWorld.theCanvas.painter.getInsets();
        mousePosn.y -= ins.top;
        return mousePosn;
    }

    public void mouseClicked(MouseEvent e) {
        this.currentWorld.stopTimer = true;
        this.mousePosn = new Posn(e.getX(), e.getY());
        this.currentWorld.processMouseClicked(this.adjustMousePosn(this.mousePosn));
        this.currentWorld.stopTimer = false;
    }

    public void mouseEntered(MouseEvent e) {
        this.currentWorld.stopTimer = true;
        this.mousePosn = new Posn(e.getX(), e.getY());
        this.currentWorld.processMouseEntered(this.adjustMousePosn(this.mousePosn));
        this.currentWorld.stopTimer = false;
    }

    public void mouseExited(MouseEvent e) {
        this.currentWorld.stopTimer = true;
        this.mousePosn = new Posn(e.getX(), e.getY());
        this.currentWorld.processMouseExited(this.adjustMousePosn(this.mousePosn));
        this.currentWorld.stopTimer = false;
    }

    public void mousePressed(MouseEvent e) {
        this.currentWorld.stopTimer = true;
        this.mousePosn = new Posn(e.getX(), e.getY());
        this.currentWorld.processMousePressed(this.adjustMousePosn(this.mousePosn));
        this.currentWorld.stopTimer = false;
    }

    public void mouseReleased(MouseEvent e) {
        this.currentWorld.stopTimer = true;
        this.mousePosn = new Posn(e.getX(), e.getY());
        this.currentWorld.processMouseReleased(this.adjustMousePosn(this.mousePosn));
        this.currentWorld.stopTimer = false;
    }
}

