
// Represents a list of items of type T
interface ILo<T>{
  
    // Is there an even number of items in this list?
    public boolean evenCount();
}                                

// Represents an empty list of items of type T
class MtLo<T> implements ILo<T>{
    MtLo(){}
  
    // Is there an even number of items in this list?
    public boolean evenCount(){
        return true;
    }
}                                              

// Represents a nonempty list of items of type T
class ConsLo<T> implements ILo<T>{
    T first;
    ILo<T> rest;
  
    ConsLo(T first, ILo<T> rest){
        this.first = first;
        this.rest = rest;
    }
  
    /* Template:
     *   Fields:
     *     ... this.first ...    -- T
     *     ... this.rest ...     -- ILo<T>
     *
     *   Methods:
     *     ... this.evenCount(T) ...       -- boolean
     *
     *   Methods for Fields:
     *     ... this.rest.evenCount() ...  -- boolean
     */
    
    // Is there an even number of items in this list?
    public boolean evenCount(){
        return !this.rest.evenCount();
    }
}                                                    
