import java.awt.Color;

import javalib.worldimages.Posn;
import javalib.worldimages.TextImage;
import javalib.worldimages.WorldEnd;
import tester.Tester;

// Examples of data and tests for the AppleOrchard game
class ExamplesAppleOrchard{
  
  // CONSTANTS:
  int WIDTH = 400;
  int HEIGHT = 400;
  
  // two sample apples
  Apple redApple = new Apple(new CartPt(20, 30), "red-apple.png");
  Apple yellowApple = new Apple(new CartPt(40, 70), "yellow-apple.png");
  
  // test the method fall for the class Apple
  boolean testFallApple(Tester t){
    return
    t.checkExpect(this.redApple.fall(), 
        new Apple(new CartPt(20, 33), "red-apple.png")) &&
    t.checkExpect(this.yellowApple.fall(), 
        new Apple(new CartPt(40, 73), "yellow-apple.png"));
  }  
  
  // test the method hitGround for the class Apple
  boolean testHitGroundApple(Tester t){
    return
    t.checkExpect(this.redApple.hitGround(400), false) &&
    t.checkExpect(this.yellowApple.hitGround(70), true);
  }
  
  // a sample basket
  Basket b = new Basket(new CartPt(200, 380));
  
  // test the methods moveLeft and moveRight for the class Basket
  boolean testMoveLeftRightBasket(Tester t){
    return
    t.checkExpect(this.b.moveLeft(), new Basket(new CartPt(197, 380))) &&
    t.checkExpect(this.b.moveRight(), new Basket(new CartPt(203, 380)));
  }  
  
  // test the method caughtApple for the class Basket
  boolean testCaughtAppleBasket(Tester t){
    return
    t.checkExpect(this.b.caughtApple(this.redApple), false) &&
    t.checkExpect(this.b.caughtApple(
        new Apple(new CartPt(200, 380), "red-apple.png")), true);
  }


  // an apple orchard world
  AppleOrchard myWorld = 
      new AppleOrchard(
          new Apple(new CartPt(WIDTH / 2, 0), "red-apple.png"), 
          new Basket(new CartPt(WIDTH / 2, HEIGHT - 20)));
  
  // test the method onTick for the class AppleOrchard
  boolean testOnTickAppleOrchard(Tester t){
    return
    t.checkExpect(this.myWorld.onTick(), 
        new AppleOrchard(
            new Apple(new CartPt(WIDTH / 2, 3), "red-apple.png"), 
            new Basket(new CartPt(WIDTH / 2, HEIGHT - 20))));
  }  
  
  // test the method onKeyEvent for the class AppleOrchard
  boolean testOnKeyEventAppleOrchard(Tester t){
    return
    t.checkExpect(this.myWorld.onKeyEvent("x"), this.myWorld) &&
    t.checkExpect(this.myWorld.onKeyEvent("left"), 
        new AppleOrchard(
            new Apple(new CartPt(WIDTH / 2, 0), "red-apple.png"), 
            new Basket(new CartPt(WIDTH / 2 - 3, HEIGHT - 20)))) &&
    t.checkExpect(this.myWorld.onKeyEvent("right"), 
        new AppleOrchard(
            new Apple(new CartPt(WIDTH / 2, 0), "red-apple.png"), 
            new Basket(new CartPt(WIDTH / 2 + 3, HEIGHT - 20))));
  }  
  
  AppleOrchard appleDownWorld =
      new AppleOrchard(
          new Apple(new CartPt(WIDTH / 2, HEIGHT), "red-apple.png"), 
          new Basket(new CartPt(WIDTH / 2 + 3, HEIGHT - 20)));
  
  // test the method worldEnds for the class AppleOrchard
  boolean testWorldEndsAppleOrchard(Tester t){
    return
    t.checkExpect(this.myWorld.worldEnds(), 
        new WorldEnd(false, this.myWorld.makeImage())) &&
    t.checkExpect(this.appleDownWorld.worldEnds(), 
        new WorldEnd(true, this.appleDownWorld.makeImage().overlayImages(
            new TextImage(new Posn(WIDTH / 2, HEIGHT / 2),  
                "The apple hit the ground", Color.red))));
  }

}