import tester.*;
import javalib.funworld.*;
import javalib.worldcanvas.*;
import javalib.worldimages.*;
import javalib.colors.*;
import java.awt.Color;

class AppleOrchard extends World{
  // apple falling from a tree
  Apple apple;
  
  // basket that catches the falling apples
  Basket basket;
  
  // CONSTANTS:
  Color SKYBLUE = new Color(50, 150, 255);
  int WIDTH = 400;
  int HEIGHT = 400;
  WorldImage BACKGROUND = 
      new RectangleImage(new Posn(WIDTH / 2, HEIGHT / 2), 
        WIDTH, HEIGHT, SKYBLUE).overlayImages(
      new FromFileImage(new Posn(WIDTH / 2, HEIGHT / 2),"apple-tree.png"));
  
  AppleOrchard(Apple apple, Basket basket){
    this.apple = apple;
    this.basket = basket;
  }
  
  /* TEMPLATE:
  FIELDS:
  ... this.apple ...     -- Apple
  ... this.basket ...    -- Basket
  
  METHODS:
  ... this.onTick() ...              -- World
  ... this.onKeyEvent(String) ...    -- World
  ... this.makeImage() ...           -- WorldImage
  ... this.lastImage() ...           -- WorldImage
  ... this.worldEnds() ...           -- WorldEnd
   
  METHODS FOR FIELDS:
  ... this.apple.fall() ...          -- Apple
  ... this.apple.appleImage() ...    -- WorldImage
  ... this.apple.hitGround(int) ...  -- boolean
  
  ... this.basket.onKeyEvent(String) ...   -- Basket
  ... this.basket.moveLeft() ...           -- Basket
  ... this.basket.moveRight() ...          -- Basket
  ... this.basket.basketImage() ...        -- WorldImage
  ... this.basket.caughtApple(Apple) ...   -- boolean
   */
  
  // produce the AppleOrchard after one tick passed
  // the apple falls, the basket does not move
  public World onTick(){
    return new AppleOrchard(this.apple.fall(), this.basket);
  }
  
  // produce the AppleOrchard in response to a key event
  // the apple  does not move, the basket may move left or right
  // if the basket had caught an apple, the game ends
  public World onKeyEvent(String ke){
    if (basket.caughtApple(this.apple))
      return this.endOfWorld("Caught an apple");
    else
      return new AppleOrchard(this.apple, this.basket.onKeyEvent(ke));
  }

  // produce the image that represents this apple orchard game world
  public WorldImage makeImage(){
    return 
    this.BACKGROUND.overlayImages(this.basket.basketImage(), 
                                  this.apple.appleImage());
  }
  
  // produce the last image if the basket has caught an apple
  public WorldImage lastImage(String s){
    return this.makeImage().overlayImages(
        new TextImage(new Posn(WIDTH / 2, HEIGHT / 2), s, Color.red));
  }
  
  // After each tick, check if the apple hit the ground - 
  // if yes, end the game
  public WorldEnd worldEnds(){
    if (this.apple.hitGround(HEIGHT))
      return new WorldEnd(true, this.makeImage().overlayImages(
                 new TextImage(new Posn(WIDTH / 2, HEIGHT / 2),  
                               "The apple hit the ground", Color.red)));
    else
      return (new WorldEnd(false, this.makeImage()));
  }
  
  // unused method - just shows how to construct the initial world
  public AppleOrchard initWorld(){
    return 
      new AppleOrchard(
          new Apple(new CartPt(WIDTH / 2, 0), "red-apple.png"), 
          new Basket(new CartPt(WIDTH / 2, HEIGHT - 20)));
  }
}

// to represent an apple falling from an apple tree
class Apple{
  
  // the location of this apple
  CartPt loc;
  
  // the name of the image file for displaying this apple
  String name;
  
  Apple(CartPt loc, String name){
    this.loc = loc;
    this.name = name;
  }
  
  /* TEMPLATE:
  FIELDS:
  ... this.loc ...     -- CartPt
  ... this.name ...    -- String
  
  METHODS:
  ... this.fall() ...          -- Apple
  ... this.appleImage() ...    -- WorldImage
  ... this.hitGround(int) ...  -- boolean
   
  METHODS FOR FIELDS:
  ... this.loc.moveBy(int, int) ...  -- CartPt
  ... this.loc.distTo(CartPt) ...    -- double
   
   */
  
  // from this apple produce a new apple, fallen down a bit (3 pixels)
  Apple fall(){
    return new Apple(this.loc.moveBy(0, 3), this.name);
  }

  // produce the image of this apple at its position
  WorldImage appleImage(){
    return new FromFileImage(this.loc, this.name);
  }
  
  // did this apple hit the ground?
  boolean hitGround(int HEIGHT){
    return this.loc.y >= HEIGHT;
  }
}

// to represent a basket for catching apples falling from an apple tree
class Basket{
  
  // the location of this basket
  CartPt loc;
  
  Basket(CartPt loc){
    this.loc = loc;
  }
  
  /* TEMPLATE:
  FIELDS:
  ... this.loc ...     -- CartPt
  
  METHODS:
  ... this.onKeyEvent(String) ...   -- Basket
  ... this.moveLeft() ...           -- Basket
  ... this.moveRight() ...          -- Basket
  ... this.basketImage() ...        -- WorldImage
  ... this.caughtApple(Apple) ...   -- boolean
   
  METHODS FOR FIELDS:
  ... this.loc.moveBy(int, int) ...  -- CartPt
  ... this.loc.distTo(CartPt) ...    -- double
   */
  // move the basket left and right on corresponding key press
  Basket onKeyEvent(String ke){
    if (ke.equals("left"))
      return this.moveLeft();
    else if (ke.equals("right"))
      return this.moveRight();
    else
      return this;
  }
  
  // from this basket produce a new basket, moved left a bit (3 pixels)
  Basket moveLeft(){
    return new Basket(this.loc.moveBy(-3, 0));
  }
  
  // from this basket produce a new basket, moved right a bit (3 pixels)
  Basket moveRight(){
    return new Basket(this.loc.moveBy(+3, 0));
  }
  
  // did the basket catch the falling apple?
  boolean caughtApple(Apple apple){
    return false;
  }

  // produce the image of this basket at its position
  WorldImage basketImage(){
    return new RectangleImage(this.loc, 60, 40, Color.darkGray);
  }
}

// extension of the Posn class with move methods
class CartPt extends Posn{
  CartPt(int x, int y){
    super(x, y);
  }
  
  // produce a point moved by the given distance from this point
  CartPt moveBy(int dx, int dy){
    return new CartPt(this.x + dx, this.y + dy);
  }
  
  // Compute the distance from this point to the given one
  double distTo(CartPt that){
    return Math.sqrt((this.x - that.x) * (this.x - that.x) + 
             (this.y - that.y) * (this.y - that.y));
  }
}
