
// Represent a list of Strings
public class LoS{
    Node node;
  
    public LoS(){
        this.node = Sentinel.tail;
    }

    /* Template:
     *   Fields:
     *     ... this.node ... -- Node
     *
     *   Methods:
     *     ... this.clear() ...                -- void
     *     ... this.add(String) ...            -- void
     *     ... this.removeFirst() ...          -- void
     *     ... this.insertSorted(String) ...   -- void
     *     ... this.isEmpty() ...              -- void
     *     ... this.getFirst() ...             -- void
     *     ... this.getRest() ...              -- void
     *
     *   Methods for Fields:
     *     ... this.node.lastNode() ...        -- void
     *     ... this.node.insertAfter(Node) ... -- void
     */
  
    // EFFECT: Remove all items from this list
    void clear(){
        this.node = Sentinel.tail;
    }
  
    // EFFECT: Add the given String to the front of this list
    void add(String s){
        this.node = new Node(s, this.node);
    }
  
    // EFFECT: Remove the first node from this list
    // Produce the removed item
    String removeFirst(){
        if(this.node.lastNode()){
            throw new RuntimeException("Cannot remove from an empty list");
        }else {
            String s = this.node.data;
            // !! Mutation...
            this.node = this.node.next;
            return s;
        }
    }
  
    // EFFECT: Insert a the given String into this list in sorted order
    void insertSorted(String s){
        if(this.node.lastNode()){
            this.node = new Node(s, this.node);
        }else{
            this.node.next.insertAfter(this.node, s);
        }
    }

    // Is this list empty?
    boolean isEmpty(){
        return this.node.lastNode();
    }
  
    // Get the first item in this list represents
    String getFirst(){
        if(this.node.lastNode()){
            throw new RuntimeException("No first in an empty list");
        }else{
            return this.node.data;
        }
    }
  
    // Produce this list with the first item removed
    LoS getRest(){
        if(this.node.lastNode()){
            throw new RuntimeException("Cannot advance beyond the last item");
        }else{
            this.node = this.node.next;
            return this;
        }
    }
}
