import tester.*;

// Linked list Examples
public class LinkedListExamples{
    LinkedListExamples(){}
  
    LoS alist = new LoS();
    Node node;
  
    // Clear the example list
    void clearLoS(){
        this.alist.clear();
    }
  
    // Reset the Node to our values
    void resetLoS(){
        this.node = new Node("abc", 
                             new Node("def", 
                                      new Node("ghi", Sentinel.tail)));
    }
  
    // test the effects for the methods invoked on the empty list
    void testSentinel(Tester t){
        // Clear the list
        this.clearLoS();
    
        // test isEmpty method:
        t.checkExpect(this.alist.isEmpty(), true);
    
        // test the exception thrown by removeFirst:
        t.checkException(new RuntimeException("Cannot remove from an empty list"), 
                         this.alist, "removeFirst");

        // Test the exception thrown by getFirst:
        t.checkException(new RuntimeException("No first in an empty list"), 
                         this.alist, "getFirst");

        // Test the exception thrown by getRest:
        t.checkException(new RuntimeException("Cannot advance beyond the last item"), 
                         this.alist, "getRest");
    
        // Test the insertSorted method:
        this.alist.insertSorted("hello");
    
        t.checkExpect(this.alist.node, new Node("hello", Sentinel.tail));
    
        // Tear-down, clear again
        this.clearLoS();
    }
  
    // Test the add method
    void testAdd(Tester t){
        this.clearLoS();
        this.resetLoS();
        
        this.alist.add("ghi");
        this.alist.add("def");
        this.alist.add("abc");
        t.checkExpect(this.alist.node, this.node);
    }
  
    // Test the insertSorted method
    void testInsertSorted(Tester t){
        this.clearLoS();
        this.resetLoS();

        // Test insertSorted for empty list:
        this.alist.insertSorted("abc");
        t.checkExpect(this.alist.node, new Node("abc", Sentinel.tail));  

        // Test insertSorted for nonempty list:
        this.alist.insertSorted("ghi");
        this.alist.insertSorted("def");
        t.checkExpect(this.alist.node, this.node);    
    }
}